/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.utils;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.LocalOsHandler;
import org.sentrysoftware.metricshub.engine.configuration.WmiConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.WmiCriterion;
import org.sentrysoftware.metricshub.engine.strategy.detection.CriterionTestResult;
import org.sentrysoftware.metricshub.engine.strategy.utils.WqlDetectionHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CriterionProcessVisitor
implements LocalOsHandler.ILocalOsVisitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CriterionProcessVisitor.class);
    private static final String CRITERION_PROCESSOR_VISITOR_LOG_MESSAGE = "Hostname {} - Process Criterion, {}";
    @NonNull
    private final String command;
    private final WqlDetectionHelper wqlDetectionHelper;
    private final String hostname;
    private CriterionTestResult criterionTestResult;

    @Override
    public void visit(LocalOsHandler.Windows os) {
        Assert.state((this.wqlDetectionHelper != null ? 1 : 0) != 0, (String)"wqlDetectionHelper cannot be null.");
        WmiConfiguration localWmiConfiguration = WmiConfiguration.builder().username(null).password(null).timeout(30L).build();
        WmiCriterion criterion = WmiCriterion.builder().query("SELECT ProcessId,Name,ParentProcessId,CommandLine FROM Win32_Process").namespace("root\\cimv2").expectedResult(this.command).build();
        this.criterionTestResult = this.wqlDetectionHelper.performDetectionTest("localhost", localWmiConfiguration, criterion);
    }

    @Override
    public void visit(LocalOsHandler.Linux os) {
        List<List<String>> result = CriterionProcessVisitor.listAllLinuxProcesses();
        this.processResult(result);
    }

    @Override
    public void visit(LocalOsHandler.Hp os) {
        this.notImplemented(LocalOsHandler.HP.getOsTag());
    }

    @Override
    public void visit(LocalOsHandler.Sun os) {
        this.notImplemented(LocalOsHandler.SUN.getOsTag());
    }

    @Override
    public void visit(LocalOsHandler.Solaris os) {
        this.notImplemented(LocalOsHandler.SOLARIS.getOsTag());
    }

    @Override
    public void visit(LocalOsHandler.FreeBsd os) {
        this.notImplemented(LocalOsHandler.FREE_BSD.getOsTag());
    }

    @Override
    public void visit(LocalOsHandler.OpenBsd os) {
        this.notImplemented(LocalOsHandler.OPEN_BSD.getOsTag());
    }

    @Override
    public void visit(LocalOsHandler.NetBsd os) {
        this.notImplemented(LocalOsHandler.NET_BSD.getOsTag());
    }

    @Override
    public void visit(LocalOsHandler.Aix os) {
        this.notImplemented(LocalOsHandler.AIX.getOsTag());
    }

    @Override
    public void visit(LocalOsHandler.MacOsx os) {
        this.notImplemented(LocalOsHandler.MAC_OS_X.getOsTag());
    }

    public static List<List<String>> listAllLinuxProcesses() {
        return ProcessHandle.allProcesses().map(CriterionProcessVisitor::getProcessDetails).collect(Collectors.toList());
    }

    static List<String> getProcessDetails(ProcessHandle processHandle) {
        return List.of(String.valueOf(processHandle.pid()), processHandle.info().command().orElse(""), processHandle.info().user().orElse(""), processHandle.parent().map(ProcessHandle::pid).map(String::valueOf).orElse(""), processHandle.info().commandLine().orElse(""));
    }

    private void processResult(List<List<String>> result) {
        result.stream().filter(line -> ((String)line.get(1)).matches(this.command)).findFirst().ifPresentOrElse(line -> this.success(String.format("One or more currently running processes match the following regular expression:\n- Regexp (should match with the command-line): %s", this.command)), () -> this.fail(String.format("No currently running processes match the following regular expression:\n- Regexp (should match with the command-line): %s\n- Currently running process list:\n%s", this.command, result.stream().map(line -> line.stream().collect(Collectors.joining(";"))).collect(Collectors.joining("\n")))));
    }

    private void notImplemented(String os) {
        this.success(String.format("Process presence check: No tests will be performed for OS: %s.", os));
    }

    private void fail(String message) {
        log.error(CRITERION_PROCESSOR_VISITOR_LOG_MESSAGE, (Object)this.hostname, (Object)message);
        this.criterionTestResult = CriterionTestResult.builder().message(message).build();
    }

    private void success(String message) {
        log.debug(CRITERION_PROCESSOR_VISITOR_LOG_MESSAGE, (Object)this.hostname, (Object)message);
        this.criterionTestResult = CriterionTestResult.builder().success(true).message(message).build();
    }

    @Generated
    public CriterionProcessVisitor(@NonNull String command, WqlDetectionHelper wqlDetectionHelper, String hostname) {
        if (command == null) {
            throw new IllegalArgumentException("command is marked non-null but is null");
        }
        this.command = command;
        this.wqlDetectionHelper = wqlDetectionHelper;
        this.hostname = hostname;
    }

    @Generated
    public CriterionTestResult getCriterionTestResult() {
        return this.criterionTestResult;
    }
}

