/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.detection;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.sentrysoftware.metricshub.engine.strategy.detection.AbstractConnectorProcessor;
import org.sentrysoftware.metricshub.engine.strategy.detection.ConnectorTestResult;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorSelection
extends AbstractConnectorProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectorSelection.class);

    public ConnectorSelection(@NonNull TelemetryManager telemetryManager, @NonNull ClientsExecutor clientsExecutor, @NonNull Set<String> connectorIds) {
        super(telemetryManager, clientsExecutor, connectorIds);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (connectorIds == null) {
            throw new IllegalArgumentException("connectorIds is marked non-null but is null");
        }
    }

    @Override
    public List<ConnectorTestResult> run() {
        HostConfiguration hostConfiguration = this.telemetryManager.getHostConfiguration();
        if (hostConfiguration == null) {
            log.error("Empty host configuration, aborting detection job.");
            return Collections.emptyList();
        }
        String hostname = hostConfiguration.getHostname();
        log.debug("Hostname {} - Start connector selection.", (Object)hostname);
        ConnectorStore telemetryManagerConnectorStore = this.telemetryManager.getConnectorStore();
        if (telemetryManagerConnectorStore == null) {
            log.error("Hostname {} - No connectorStore found. Stopping detection operation.", (Object)hostname);
            return Collections.emptyList();
        }
        Map<String, Connector> connectorStore = telemetryManagerConnectorStore.getStore();
        if (connectorStore == null) {
            log.error("Hostname {} - No connectorStore found. Stopping detection operation.", (Object)hostname);
            return Collections.emptyList();
        }
        if (this.connectorIds.isEmpty()) {
            log.error("Hostname {} - No connectors have been selected for the detection. Stopping discovery operation.", (Object)hostname);
            return Collections.emptyList();
        }
        return this.runAllConnectorsDetectionCriteria(connectorStore.values().stream().filter(connector -> this.isConnectorContainedInSet((Connector)connector, this.connectorIds)), hostConfiguration).collect(Collectors.toList());
    }

    @Generated
    public ConnectorSelection() {
    }
}

