/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.collect;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.ipmi.client.IpmiClient;
import org.sentrysoftware.ipmi.client.IpmiClientConfiguration;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.client.http.HttpRequest;
import org.sentrysoftware.metricshub.engine.configuration.HttpConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.IpmiConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.OsCommandConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.SnmpConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.SshConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.WbemConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.WinRmConfiguration;
import org.sentrysoftware.metricshub.engine.configuration.WmiConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.common.ResultContent;
import org.sentrysoftware.metricshub.engine.strategy.AbstractStrategy;
import org.sentrysoftware.metricshub.engine.strategy.utils.OsCommandHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.WqlDetectionHelper;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolHealthCheckStrategy
extends AbstractStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProtocolHealthCheckStrategy.class);
    public static final Double UP = 1.0;
    public static final Double DOWN = 0.0;
    private static final String UP_METRIC_FORMAT = "metricshub.host.up{protocol=\"%s\"}";
    public static final String HTTP_UP_METRIC = String.format("metricshub.host.up{protocol=\"%s\"}", "http");
    public static final String SNMP_UP_METRIC = String.format("metricshub.host.up{protocol=\"%s\"}", "snmp");
    public static final String SSH_UP_METRIC = String.format("metricshub.host.up{protocol=\"%s\"}", "ssh");
    public static final String IPMI_UP_METRIC = String.format("metricshub.host.up{protocol=\"%s\"}", "ipmi");
    public static final String WBEM_UP_METRIC = String.format("metricshub.host.up{protocol=\"%s\"}", "wbem");
    public static final String WMI_UP_METRIC = String.format("metricshub.host.up{protocol=\"%s\"}", "wmi");
    public static final String WINRM_UP_METRIC = String.format("metricshub.host.up{protocol=\"%s\"}", "winrm");
    public static final String SNMP_OID = "1.3.6.1";
    public static final String SSH_TEST_COMMAND = "echo test";
    public static final List<String> WBEM_UP_TEST_NAMESPACES = Collections.unmodifiableList(List.of("root/Interop", "interop", "root/PG_Interop", "PG_Interop"));
    public static final String WBEM_TEST_QUERY = "SELECT Name FROM CIM_NameSpace";
    public static final String WMI_AND_WINRM_TEST_QUERY = "Select Name FROM Win32_ComputerSystem";
    public static final String WMI_AND_WINRM_TEST_NAMESPACE = "root\\cimv2";

    public ProtocolHealthCheckStrategy(@NonNull TelemetryManager telemetryManager, @NonNull Long strategyTime, @NonNull ClientsExecutor clientsExecutor) {
        super(telemetryManager, strategyTime, clientsExecutor);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
    }

    @Override
    public void run() {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        Monitor hostMonitor = this.telemetryManager.getEndpointHostMonitor();
        if (hostMonitor == null) {
            return;
        }
        log.info("Hostname {} - Performing protocol health check.", (Object)hostname);
        MetricFactory metricFactory = new MetricFactory(hostname);
        this.checkHttpHealth(hostname, hostMonitor, metricFactory);
        this.checkSnmpHealth(hostname, hostMonitor, metricFactory);
        this.checkSshHealth(hostname, hostMonitor, metricFactory);
        this.checkIpmiHealth(hostname, hostMonitor, metricFactory);
        this.checkWbemHealth(hostname, hostMonitor, metricFactory);
        this.checkWmiHealth(hostname, hostMonitor, metricFactory);
        this.checkWinRmHealth(hostname, hostMonitor, metricFactory);
    }

    @Override
    public long getStrategyTimeout() {
        return this.telemetryManager.getHostConfiguration().getStrategyTimeout();
    }

    @Override
    public Long getStrategyTime() {
        return this.telemetryManager.getStrategyTime();
    }

    public void checkHttpHealth(String hostname, Monitor hostMonitor, MetricFactory metricFactory) {
        String httpResult = null;
        HttpConfiguration httpConfiguration = (HttpConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(HttpConfiguration.class);
        if (httpConfiguration == null) {
            return;
        }
        log.info("Hostname {} - Checking HTTP protocol status. Sending GET request to '/'.", (Object)hostname);
        try {
            HttpRequest request = HttpRequest.builder().hostname(hostname).path("/").httpConfiguration(httpConfiguration).resultContent(ResultContent.ALL).build();
            httpResult = this.clientsExecutor.executeHttp(request, true);
        }
        catch (Exception e) {
            log.debug("Hostname {} - Checking HTTP protocol status. HTTP exception when performing a GET request to '/': ", (Object)hostname, (Object)e);
        }
        metricFactory.collectNumberMetric(hostMonitor, HTTP_UP_METRIC, httpResult != null ? UP : DOWN, this.strategyTime);
    }

    public void checkSnmpHealth(String hostname, Monitor hostMonitor, MetricFactory metricFactory) {
        String snmpResult = null;
        SnmpConfiguration snmpConfiguration = (SnmpConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(SnmpConfiguration.class);
        if (snmpConfiguration == null) {
            return;
        }
        log.info("Hostname {} - Checking SNMP protocol status. Sending Get Next request on {}.", (Object)hostname, (Object)SNMP_OID);
        try {
            snmpResult = this.clientsExecutor.executeSNMPGetNext(SNMP_OID, snmpConfiguration, hostname, true);
        }
        catch (Exception e) {
            log.debug("Hostname {} - Checking SNMP protocol status. SNMP exception when performing a SNMP Get Next query on {}: ", new Object[]{hostname, SNMP_OID, e});
        }
        metricFactory.collectNumberMetric(hostMonitor, SNMP_UP_METRIC, snmpResult != null ? UP : DOWN, this.strategyTime);
    }

    public void checkSshHealth(String hostname, Monitor hostMonitor, MetricFactory metricFactory) {
        Double sshResult = UP;
        SshConfiguration sshConfiguration = (SshConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(SshConfiguration.class);
        if (sshConfiguration == null || !this.telemetryManager.getHostProperties().isMustCheckSshStatus()) {
            return;
        }
        log.info("Hostname {} - Checking SSH protocol status. Sending an SSH 'echo test' command.", (Object)hostname);
        if (this.telemetryManager.getHostProperties().isOsCommandExecutesLocally()) {
            sshResult = this.localSshTest(hostname);
        }
        if (this.telemetryManager.getHostProperties().isOsCommandExecutesRemotely()) {
            sshResult = this.remoteSshTest(hostname, sshResult, sshConfiguration);
        }
        metricFactory.collectNumberMetric(hostMonitor, SSH_UP_METRIC, sshResult, this.strategyTime);
    }

    private Double localSshTest(String hostname) {
        try {
            if (OsCommandHelper.runLocalCommand(SSH_TEST_COMMAND, OsCommandConfiguration.DEFAULT_TIMEOUT, null) == null) {
                log.debug("Hostname {} - Checking SSH protocol status. Local OS command has not returned any results.", (Object)hostname);
                return DOWN;
            }
        }
        catch (Exception e) {
            log.debug("Hostname {} - Checking SSH protocol status. SSH exception when performing a local OS command test: ", (Object)hostname, (Object)e);
            return DOWN;
        }
        return UP;
    }

    private Double remoteSshTest(String hostname, Double previousSshStatus, SshConfiguration sshConfiguration) {
        try {
            if (OsCommandHelper.runSshCommand(SSH_TEST_COMMAND, hostname, sshConfiguration, OsCommandConfiguration.DEFAULT_TIMEOUT, null, null) == null) {
                log.debug("Hostname {} - Checking SSH protocol status. Remote SSH command has not returned any results.", (Object)hostname);
                return DOWN;
            }
        }
        catch (Exception e) {
            log.debug("Hostname {} - Checking SSH protocol status. SSH exception when performing a remote SSH command test: ", (Object)hostname, (Object)e);
            return DOWN;
        }
        return previousSshStatus;
    }

    public void checkIpmiHealth(String hostname, Monitor hostMonitor, MetricFactory metricFactory) {
        String ipmiResult = null;
        IpmiConfiguration ipmiConfiguration = (IpmiConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(IpmiConfiguration.class);
        if (ipmiConfiguration == null) {
            return;
        }
        log.info("Hostname {} - Checking IPMI protocol status. Sending a IPMI 'Get Chassis Status As String Result' request.", (Object)hostname);
        try {
            ipmiResult = IpmiClient.getChassisStatusAsStringResult((IpmiClientConfiguration)new IpmiClientConfiguration(hostname, ipmiConfiguration.getUsername(), ipmiConfiguration.getPassword(), ipmiConfiguration.getBmcKey(), ipmiConfiguration.isSkipAuth(), ipmiConfiguration.getTimeout().longValue()));
        }
        catch (Exception e) {
            log.debug("Hostname {} - Checking IPMI protocol status. IPMI exception when performing a IPMI 'Get Chassis Status As String Result' query: ", (Object)hostname, (Object)e);
        }
        metricFactory.collectNumberMetric(hostMonitor, IPMI_UP_METRIC, ipmiResult != null ? UP : DOWN, this.strategyTime);
    }

    public void checkWbemHealth(String hostname, Monitor hostMonitor, MetricFactory metricFactory) {
        WbemConfiguration wbemConfiguration = (WbemConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(WbemConfiguration.class);
        if (wbemConfiguration == null) {
            return;
        }
        log.info("Hostname {} - Checking WBEM protocol status. Sending a WQL SELECT request on different namespaces.", (Object)hostname);
        for (String wbemNamespace : WBEM_UP_TEST_NAMESPACES) {
            try {
                log.info("Hostname {} - Checking WBEM protocol status. Sending a WQL SELECT request on {} namespace.", (Object)hostname, (Object)wbemNamespace);
                if (this.clientsExecutor.executeWbem(hostname, wbemConfiguration, WBEM_TEST_QUERY, wbemNamespace) == null) continue;
                metricFactory.collectNumberMetric(hostMonitor, WBEM_UP_METRIC, UP, this.strategyTime);
                return;
            }
            catch (Exception e) {
                if (WqlDetectionHelper.isAcceptableException(e)) {
                    metricFactory.collectNumberMetric(hostMonitor, WBEM_UP_METRIC, UP, this.strategyTime);
                    return;
                }
                log.debug("Hostname {} - Checking WBEM protocol status. WBEM exception when performing a WQL SELECT query on '{}' namespace: ", new Object[]{hostname, wbemNamespace, e});
            }
        }
        metricFactory.collectNumberMetric(hostMonitor, WBEM_UP_METRIC, DOWN, this.strategyTime);
    }

    public void checkWmiHealth(String hostname, Monitor hostMonitor, MetricFactory metricFactory) {
        List<List<String>> wmiResult = null;
        WmiConfiguration wmiConfiguration = (WmiConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(WmiConfiguration.class);
        if (wmiConfiguration == null) {
            return;
        }
        log.info("Hostname {} - Checking WMI protocol status. Sending a WQL SELECT request on {} namespace.", (Object)hostname, (Object)WMI_AND_WINRM_TEST_NAMESPACE);
        try {
            wmiResult = this.clientsExecutor.executeWmi(hostname, wmiConfiguration, WMI_AND_WINRM_TEST_QUERY, WMI_AND_WINRM_TEST_NAMESPACE);
        }
        catch (Exception e) {
            if (WqlDetectionHelper.isAcceptableException(e)) {
                metricFactory.collectNumberMetric(hostMonitor, WMI_UP_METRIC, UP, this.strategyTime);
                return;
            }
            log.debug("Hostname {} - Checking WMI protocol status. WMI exception when performing a WQL SELECT request on {} namespace: ", new Object[]{hostname, WMI_AND_WINRM_TEST_NAMESPACE, e});
        }
        metricFactory.collectNumberMetric(hostMonitor, WMI_UP_METRIC, wmiResult != null ? UP : DOWN, this.strategyTime);
    }

    public void checkWinRmHealth(String hostname, Monitor hostMonitor, MetricFactory metricFactory) {
        List<List<String>> winRmResult = null;
        WinRmConfiguration winRmConfiguration = (WinRmConfiguration)this.telemetryManager.getHostConfiguration().getConfigurations().get(WinRmConfiguration.class);
        if (winRmConfiguration == null) {
            return;
        }
        log.info("Hostname {} - Checking WinRM protocol status. Sending a WQL SELECT request on {} namespace.", (Object)hostname, (Object)WMI_AND_WINRM_TEST_NAMESPACE);
        try {
            winRmResult = this.clientsExecutor.executeWqlThroughWinRm(hostname, winRmConfiguration, WMI_AND_WINRM_TEST_QUERY, WMI_AND_WINRM_TEST_NAMESPACE);
        }
        catch (Exception e) {
            if (WqlDetectionHelper.isAcceptableException(e)) {
                metricFactory.collectNumberMetric(hostMonitor, WINRM_UP_METRIC, UP, this.strategyTime);
                return;
            }
            log.debug("Hostname {} - Checking WinRM protocol status. WinRM exception when performing a WQL SELECT request on {} namespace: ", new Object[]{hostname, WMI_AND_WINRM_TEST_NAMESPACE, e});
        }
        metricFactory.collectNumberMetric(hostMonitor, WINRM_UP_METRIC, winRmResult != null ? UP : DOWN, this.strategyTime);
    }

    @Generated
    public static ProtocolHealthCheckStrategyBuilder builder() {
        return new ProtocolHealthCheckStrategyBuilder();
    }

    @Generated
    public static class ProtocolHealthCheckStrategyBuilder {
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private Long strategyTime;
        @Generated
        private ClientsExecutor clientsExecutor;

        @Generated
        ProtocolHealthCheckStrategyBuilder() {
        }

        @Generated
        public ProtocolHealthCheckStrategyBuilder telemetryManager(@NonNull TelemetryManager telemetryManager) {
            if (telemetryManager == null) {
                throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
            }
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public ProtocolHealthCheckStrategyBuilder strategyTime(@NonNull Long strategyTime) {
            if (strategyTime == null) {
                throw new IllegalArgumentException("strategyTime is marked non-null but is null");
            }
            this.strategyTime = strategyTime;
            return this;
        }

        @Generated
        public ProtocolHealthCheckStrategyBuilder clientsExecutor(@NonNull ClientsExecutor clientsExecutor) {
            if (clientsExecutor == null) {
                throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
            }
            this.clientsExecutor = clientsExecutor;
            return this;
        }

        @Generated
        public ProtocolHealthCheckStrategy build() {
            return new ProtocolHealthCheckStrategy(this.telemetryManager, this.strategyTime, this.clientsExecutor);
        }

        @Generated
        public String toString() {
            return "ProtocolHealthCheckStrategy.ProtocolHealthCheckStrategyBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ", strategyTime=" + this.strategyTime + ", clientsExecutor=" + String.valueOf(this.clientsExecutor) + ")";
        }
    }
}

