/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.ConnectorMonitorTypeComparator;
import org.sentrysoftware.metricshub.engine.common.JobInfo;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.ConnectorStore;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.MonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.AbstractMonitorTask;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.Mapping;
import org.sentrysoftware.metricshub.engine.strategy.AbstractStrategy;
import org.sentrysoftware.metricshub.engine.strategy.pre.PreSourcesStrategy;
import org.sentrysoftware.metricshub.engine.strategy.source.OrderedSources;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.utils.MappingProcessor;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.MonitorFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Resource;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAllAtOnceStrategy
extends AbstractStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractAllAtOnceStrategy.class);

    protected AbstractAllAtOnceStrategy(@NonNull TelemetryManager telemetryManager, long strategyTime, @NonNull ClientsExecutor clientsExecutor) {
        super(telemetryManager, strategyTime, clientsExecutor);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
    }

    private void process(Connector currentConnector, String hostname) {
        if (!this.validateConnectorDetectionCriteria(currentConnector, hostname)) {
            log.error("Hostname {} - The connector {} no longer matches the host. Stopping the connector's {} job.", new Object[]{hostname, currentConnector.getCompiledFilename(), this.getJobName()});
            return;
        }
        PreSourcesStrategy preSourcesStrategy = PreSourcesStrategy.builder().clientsExecutor(this.clientsExecutor).strategyTime(this.strategyTime).telemetryManager(this.telemetryManager).connector(currentConnector).build();
        preSourcesStrategy.run();
        Map connectorMonitorJobs = currentConnector.getMonitors().entrySet().stream().sorted(Comparator.comparing(entry -> MetricsHubConstants.MONITOR_JOBS_PRIORITY.containsKey(entry.getKey()) ? MetricsHubConstants.MONITOR_JOBS_PRIORITY.get(entry.getKey()) : MetricsHubConstants.MONITOR_JOBS_PRIORITY.get("otherMonitorJobTypes"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        Map sequentialMonitorJobs = connectorMonitorJobs.entrySet().stream().filter(entry -> MetricsHubConstants.MONITOR_JOBS_PRIORITY.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        Map otherMonitorJobs = connectorMonitorJobs.entrySet().stream().filter(entry -> !MetricsHubConstants.MONITOR_JOBS_PRIORITY.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue, LinkedHashMap::new));
        sequentialMonitorJobs.entrySet().forEach(entry -> this.processMonitorJob(currentConnector, hostname, (Map.Entry<String, MonitorJob>)entry));
        if (this.telemetryManager.getHostConfiguration().isSequential()) {
            otherMonitorJobs.entrySet().forEach(entry -> this.processMonitorJob(currentConnector, hostname, (Map.Entry<String, MonitorJob>)entry));
        } else {
            log.info("Hostname {} - Running {} in parallel mode. Connector: {}.", new Object[]{hostname, this.getJobName(), currentConnector.getConnectorIdentity().getCompiledFilename()});
            ExecutorService threadsPool = Executors.newFixedThreadPool(50);
            otherMonitorJobs.entrySet().forEach(entry -> threadsPool.execute(() -> this.processMonitorJob(currentConnector, hostname, (Map.Entry<String, MonitorJob>)entry)));
            threadsPool.shutdown();
            try {
                threadsPool.awaitTermination(900L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                log.debug("Hostname {} - Waiting for threads' termination aborted with an error.", (Object)hostname, (Object)e);
            }
        }
    }

    private void processMonitorJob(Connector currentConnector, String hostname, Map.Entry<String, MonitorJob> monitorJobEntry) {
        MonitorJob monitorJob = monitorJobEntry.getValue();
        AbstractMonitorTask monitorTask = this.retrieveTask(monitorJob);
        if (monitorTask == null) {
            return;
        }
        String monitorType = monitorJobEntry.getKey();
        JobInfo jobInfo = JobInfo.builder().hostname(hostname).connectorId(currentConnector.getCompiledFilename()).jobName(this.getJobName()).monitorType(monitorType).build();
        OrderedSources orderedSources = OrderedSources.builder().sources(monitorTask.getSources(), monitorTask.getExecutionOrder().stream().collect(Collectors.toList()), monitorTask.getSourceDep(), jobInfo).build();
        this.processSourcesAndComputes(orderedSources.getSources(), jobInfo);
        Mapping mapping = monitorTask.getMapping();
        this.processSameTypeMonitors(currentConnector, mapping, monitorType, hostname);
    }

    private void processSameTypeMonitors(Connector connector, Mapping mapping, String monitorType, String hostname) {
        String connectorId = connector.getCompiledFilename();
        String source = mapping.getSource();
        if (source == null) {
            log.warn("Hostname {} - No instance tables found with {} during the {} job for the connector {}. Skip processing.", new Object[]{hostname, monitorType, this.getJobName(), connectorId});
            return;
        }
        if (mapping.getAttributes() == null) {
            log.info("Hostname {} - No mapping attributes defined with {} during the {} job for the connector {}. Skip processing.", new Object[]{hostname, monitorType, this.getJobName(), connectorId});
            return;
        }
        Optional<SourceTable> maybeSourceTable = SourceTable.lookupSourceTable(source, connectorId, this.telemetryManager);
        if (maybeSourceTable.isEmpty()) {
            log.warn("Hostname {} - The source table {} is not found during the {} job for the connector {}. Skip processing.", new Object[]{hostname, source, this.getJobName(), connectorId});
            return;
        }
        SourceTable sourceTable = maybeSourceTable.get();
        log.debug("Hostname {} - Start {} {} mapping with source {}, attributes {}, metrics {}, conditional collection {}, legacy text parameters {} and resource{}. Connector ID: {}.", new Object[]{hostname, monitorType, this.getJobName(), mapping.getSource(), mapping.getAttributes(), mapping.getMetrics(), mapping.getConditionalCollection(), mapping.getLegacyTextParameters(), mapping.getResource(), connectorId});
        for (List<String> row : sourceTable.getTable()) {
            MappingProcessor mappingProcessor = MappingProcessor.builder().telemetryManager(this.telemetryManager).mapping(mapping).jobInfo(JobInfo.builder().connectorId(connectorId).hostname(hostname).monitorType(monitorType).jobName(this.getJobName()).build()).collectTime(this.strategyTime).row(row).build();
            Map<String, String> noContextAttributeInterpretedValues = mappingProcessor.interpretNonContextMappingAttributes();
            Resource resource = mappingProcessor.interpretMappingResource();
            MonitorFactory monitorFactory = MonitorFactory.builder().monitorType(monitorType).telemetryManager(this.telemetryManager).attributes(noContextAttributeInterpretedValues).resource(resource).connectorId(connectorId).discoveryTime(this.strategyTime).build();
            if (noContextAttributeInterpretedValues.get("id") == null) {
                log.info("Hostname {} - No mapping attribute 'id' found with {} during the {} job for the connector {}. Processed row: {}. The monitor will not be created.", new Object[]{hostname, monitorType, this.getJobName(), connectorId, row});
                continue;
            }
            Monitor monitor = monitorFactory.createOrUpdateMonitor();
            Map<String, String> contextAttributes = mappingProcessor.interpretContextMappingAttributes(monitor);
            monitor.addAttributes(contextAttributes);
            monitor.addConditionalCollection(mappingProcessor.interpretNonContextMappingConditionalCollection());
            monitor.addConditionalCollection(mappingProcessor.interpretContextMappingConditionalCollection(monitor));
            Map<String, String> metrics = mappingProcessor.interpretNonContextMappingMetrics();
            metrics.putAll(mappingProcessor.interpretContextMappingMetrics(monitor));
            MetricFactory metricFactory = new MetricFactory(hostname);
            metricFactory.collectMonitorMetrics(monitorType, connector, monitor, connectorId, metrics, this.strategyTime, true);
            monitor.addLegacyParameters(mappingProcessor.interpretNonContextMappingLegacyTextParameters());
            monitor.addLegacyParameters(mappingProcessor.interpretContextMappingLegacyTextParameters(monitor));
        }
    }

    @Override
    public void run() {
        String hostname = this.telemetryManager.getHostConfiguration().getHostname();
        Monitor endpointHost = this.telemetryManager.getEndpointHostMonitor();
        if (endpointHost == null) {
            log.info("Hostname {} - No endpoint host found during {} strategy.", (Object)hostname, (Object)this.getJobName());
        } else {
            endpointHost.setDiscoveryTime(this.strategyTime);
        }
        Map<String, Monitor> connectorMonitors = this.telemetryManager.getMonitors().get(KnownMonitorType.CONNECTOR.getKey());
        if (connectorMonitors == null || connectorMonitors.isEmpty()) {
            log.error("Hostname {} - Collect - No connectors detected in the detection operation. Collect operation will now be stopped.", (Object)hostname);
            return;
        }
        ConnectorStore connectorStore = this.telemetryManager.getConnectorStore();
        Set detectedConnectorFileNames = connectorMonitors.values().stream().map(monitor -> monitor.getAttributes().get("id")).collect(Collectors.toSet());
        List detectedConnectors = connectorStore.getStore().entrySet().stream().filter(entry -> detectedConnectorFileNames.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        List connectorsWithMonitorJobs = detectedConnectors.stream().filter(connector -> !connector.getMonitors().isEmpty()).collect(Collectors.toList());
        List<Connector> sortedConnectors = connectorsWithMonitorJobs.stream().sorted(new ConnectorMonitorTypeComparator()).collect(Collectors.toList());
        sortedConnectors.forEach(connector -> this.process((Connector)connector, hostname));
    }

    protected abstract String getJobName();

    protected abstract AbstractMonitorTask retrieveTask(MonitorJob var1);

    @Override
    @Generated
    public String toString() {
        return "AbstractAllAtOnceStrategy()";
    }

    @Generated
    public AbstractAllAtOnceStrategy() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractAllAtOnceStrategy)) {
            return false;
        }
        AbstractAllAtOnceStrategy other = (AbstractAllAtOnceStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractAllAtOnceStrategy;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

