/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.connector.parser.AbstractNodeProcessor;
import org.sentrysoftware.metricshub.engine.connector.parser.JsonNodeContextUpdater;

public class ReferenceResolverProcessor
extends AbstractNodeProcessor {
    private static final String SOURCE_REF_FORMAT = "${source::%s}";
    private static final Pattern REGEX_SOURCE_REF_MONITORS = Pattern.compile("\\$\\{source::(?!((?i)monitors\\.([\\w()\\.-]+)\\.(discovery|collect|simple)\\.sources\\.([\\w()\\.-]+)\\}))([\\w()\\.-]+)\\}");
    private static final Pattern REGEX_SOURCE_REF_PRE = Pattern.compile("\\$\\{source::(?!((?i)pre\\.([\\w()\\.-]+)\\}))([\\w()\\.-]+)\\}");
    private static final Set<String> JOBS = Set.of("discovery", "collect", "simple");

    public ReferenceResolverProcessor(AbstractNodeProcessor next) {
        super(next);
    }

    private String updateSourceReferences(String valueToUpdate, String context) {
        if (valueToUpdate == null || valueToUpdate.isEmpty() || context == null || context.isEmpty()) {
            return valueToUpdate;
        }
        String[] parts = context.split("\\.");
        valueToUpdate = REGEX_SOURCE_REF_MONITORS.matcher(valueToUpdate).replaceAll(match -> {
            if (parts.length >= 4 && parts[0].equals("monitors") && JOBS.contains(parts[2]) && (parts[3].equals("sources") || parts[3].equals("mapping"))) {
                return Matcher.quoteReplacement(String.format(SOURCE_REF_FORMAT, Stream.of(parts[0], parts[1], parts[2], "sources", match.group(5)).collect(Collectors.joining("."))));
            }
            return Matcher.quoteReplacement(match.group());
        });
        return REGEX_SOURCE_REF_PRE.matcher(valueToUpdate).replaceAll(match -> {
            if (parts.length >= 2 && parts[0].equals("pre")) {
                return Matcher.quoteReplacement(String.format(SOURCE_REF_FORMAT, Stream.of(parts[0], match.group(3)).collect(Collectors.joining("."))));
            }
            return Matcher.quoteReplacement(match.group());
        });
    }

    @Override
    protected JsonNode processNode(JsonNode node) throws IOException {
        JsonNodeContextUpdater.jsonNodeContextUpdaterBuilder().withJsonNode(node).withPredicate(Objects::nonNull).withUpdater(this::updateSourceReferences).build().update();
        return node;
    }

    @Generated
    public static ReferenceResolverProcessorBuilder builder() {
        return new ReferenceResolverProcessorBuilder();
    }

    @Override
    @Generated
    public String toString() {
        return "ReferenceResolverProcessor()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferenceResolverProcessor)) {
            return false;
        }
        ReferenceResolverProcessor other = (ReferenceResolverProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReferenceResolverProcessor;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public static class ReferenceResolverProcessorBuilder {
        @Generated
        private AbstractNodeProcessor next;

        @Generated
        ReferenceResolverProcessorBuilder() {
        }

        @Generated
        public ReferenceResolverProcessorBuilder next(AbstractNodeProcessor next) {
            this.next = next;
            return this;
        }

        @Generated
        public ReferenceResolverProcessor build() {
            return new ReferenceResolverProcessor(this.next);
        }

        @Generated
        public String toString() {
            return "ReferenceResolverProcessor.ReferenceResolverProcessorBuilder(next=" + String.valueOf(this.next) + ")";
        }
    }
}

