/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import org.sentrysoftware.metricshub.engine.common.helpers.FileHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.connector.parser.JsonNodeUpdater;

public class EmbeddedFilesResolver {
    private final JsonNode connector;
    private final Path connectorDirectory;
    private final Set<URI> parents;
    private final Map<String, URI> alreadyProcessedEmbeddedFiles;

    public EmbeddedFilesResolver(JsonNode connector, Path connectorDirectory, Set<URI> parents) {
        this.connector = connector;
        this.connectorDirectory = connectorDirectory;
        this.parents = parents;
        this.alreadyProcessedEmbeddedFiles = new HashMap<String, URI>();
    }

    public void internalize() throws IOException {
        JsonParser jsonParser = this.connector.traverse();
        JsonToken token = jsonParser.nextToken();
        while (token != null) {
            String currentValue = jsonParser.getValueAsString();
            if (currentValue == null) {
                token = jsonParser.nextToken();
                continue;
            }
            Matcher fileMatcher = MetricsHubConstants.FILE_PATTERN.matcher(currentValue);
            while (fileMatcher.find()) {
                String fileName = fileMatcher.group(1);
                this.alreadyProcessedEmbeddedFiles.computeIfAbsent(fileName, name -> this.findAbsoluteUri((String)name, this.connectorDirectory));
            }
            token = jsonParser.nextToken();
        }
        if (this.alreadyProcessedEmbeddedFiles.isEmpty()) {
            return;
        }
        JsonNodeUpdater.jsonNodeUpdaterBuilder().withJsonNode(this.connector).withPredicate(value -> value.indexOf("${file::") != -1).withUpdater(this::performFileRefReplacements).build().update();
    }

    public URI findAbsoluteUri(String fileName, Path connectorDirectory) {
        Path connectorPathFile;
        Path connectorsDirectoryPath;
        Path filePath = connectorDirectory.resolve(fileName).normalize();
        if (Files.exists(filePath, new LinkOption[0])) {
            return filePath.toUri();
        }
        Iterator<URI> iterator = this.parents.iterator();
        while (iterator.hasNext()) {
            Path path = Paths.get(iterator.next()).resolve(fileName).normalize();
            if (!Files.exists(path, new LinkOption[0])) continue;
            return path.toUri();
        }
        if (!fileName.startsWith(".") && (connectorsDirectoryPath = FileHelper.findConnectorsDirectory(connectorDirectory.toUri())) != null && Files.exists(connectorPathFile = connectorsDirectoryPath.resolve(fileName).normalize(), new LinkOption[0])) {
            return connectorPathFile.toUri();
        }
        throw new IllegalStateException("Can't find embedded file: " + fileName);
    }

    private String performFileRefReplacements(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        Matcher matcher = MetricsHubConstants.FILE_PATTERN.matcher(value);
        while (matcher.find()) {
            value = this.replaceFileReference(matcher, value);
        }
        return value;
    }

    private String replaceFileReference(Matcher matcher, String value) {
        String replacement = this.alreadyProcessedEmbeddedFiles.get(matcher.group(1)).toString();
        return value.replace(matcher.group(1), replacement);
    }
}

