/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.connector.parser.AbstractNodeProcessor;
import org.sentrysoftware.metricshub.engine.connector.parser.JsonNodeUpdater;

public class ConstantsProcessor
extends AbstractNodeProcessor {
    private static final String CONSTANTS_PATTERN = "${constant::%s}";

    private ConstantsProcessor(AbstractNodeProcessor next) {
        super(next);
    }

    public ConstantsProcessor() {
        this(null);
    }

    @Override
    public JsonNode processNode(JsonNode node) {
        JsonNode constantsNode = node.get("constants");
        if (constantsNode != null && constantsNode.isObject()) {
            ArrayList constantKeys = new ArrayList(constantsNode.size());
            constantsNode.fieldNames().forEachRemaining(constantKeys::add);
            HashMap<String, String> replacements = new HashMap<String, String>();
            for (String key : constantKeys) {
                JsonNode child = constantsNode.get(key);
                replacements.put(String.format(CONSTANTS_PATTERN, key), child.asText());
            }
            UnaryOperator updater = value -> this.performReplacements((Map<String, String>)replacements, (String)value);
            Predicate<String> replacementPredicate = Objects::nonNull;
            JsonNodeUpdater.jsonNodeUpdaterBuilder().withJsonNode(node).withPredicate(replacementPredicate).withUpdater(updater).build().update();
            ((ObjectNode)node).remove("constants");
        }
        return node;
    }

    private String performReplacements(Map<String, String> replacements, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            String key = entry.getKey();
            if (!value.contains(key)) continue;
            value = value.replace(key, entry.getValue());
        }
        return value;
    }

    @Override
    @Generated
    public String toString() {
        return "ConstantsProcessor()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstantsProcessor)) {
            return false;
        }
        ConstantsProcessor other = (ConstantsProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ConstantsProcessor;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

