/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;

public abstract class AbstractJsonNodeUpdater {
    @NonNull
    protected final JsonNode jsonNode;
    @NonNull
    protected final Predicate<String> predicate;

    protected abstract void update();

    protected void runUpdate(Runnable update, String value) {
        if (this.predicate.test(value)) {
            update.run();
        }
    }

    @NonNull
    @Generated
    public JsonNode getJsonNode() {
        return this.jsonNode;
    }

    @NonNull
    @Generated
    public Predicate<String> getPredicate() {
        return this.predicate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractJsonNodeUpdater)) {
            return false;
        }
        AbstractJsonNodeUpdater other = (AbstractJsonNodeUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        JsonNode this$jsonNode = this.getJsonNode();
        JsonNode other$jsonNode = other.getJsonNode();
        if (this$jsonNode == null ? other$jsonNode != null : !this$jsonNode.equals(other$jsonNode)) {
            return false;
        }
        Predicate<String> this$predicate = this.getPredicate();
        Predicate<String> other$predicate = other.getPredicate();
        return !(this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractJsonNodeUpdater;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        JsonNode $jsonNode = this.getJsonNode();
        result = result * 59 + ($jsonNode == null ? 43 : $jsonNode.hashCode());
        Predicate<String> $predicate = this.getPredicate();
        result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractJsonNodeUpdater(jsonNode=" + String.valueOf(this.getJsonNode()) + ", predicate=" + String.valueOf(this.getPredicate()) + ")";
    }

    @Generated
    public AbstractJsonNodeUpdater(@NonNull JsonNode jsonNode, @NonNull Predicate<String> predicate) {
        if (jsonNode == null) {
            throw new IllegalArgumentException("jsonNode is marked non-null but is null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("predicate is marked non-null but is null");
        }
        this.jsonNode = jsonNode;
        this.predicate = predicate;
    }
}

