/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.ExtendsDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.SourcesDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.TranslationTable;
import org.sentrysoftware.metricshub.engine.connector.model.identity.ConnectorIdentity;
import org.sentrysoftware.metricshub.engine.connector.model.identity.Detection;
import org.sentrysoftware.metricshub.engine.connector.model.metric.MetricDefinition;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.MonitorJob;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;

public class Connector
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="connector")
    private ConnectorIdentity connectorIdentity;
    @JsonProperty(value="extends")
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=ExtendsDeserializer.class)
    private Set<String> extendsConnectors;
    private Map<String, MetricDefinition> metrics;
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> constants;
    @JsonSetter(nulls=Nulls.SKIP)
    private Set<String> sudoCommands;
    @JsonDeserialize(using=SourcesDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, Source> pre;
    private Map<String, MonitorJob> monitors;
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, TranslationTable> translations;
    private Set<Class<? extends Source>> sourceTypes;
    private List<Set<String>> preSourceDep;

    public ConnectorIdentity getOrCreateConnectorIdentity() {
        if (this.connectorIdentity == null) {
            this.connectorIdentity = new ConnectorIdentity();
        }
        return this.connectorIdentity;
    }

    public String getCompiledFilename() {
        String compiledFilename;
        if (this.connectorIdentity != null && (compiledFilename = this.connectorIdentity.getCompiledFilename()) != null) {
            return compiledFilename;
        }
        throw new IllegalStateException("No compiled file name found.");
    }

    public boolean hasTag(@NonNull String tag) {
        if (tag == null) {
            throw new IllegalArgumentException("tag is marked non-null but is null");
        }
        Detection detection = this.connectorIdentity.getDetection();
        if (detection == null) {
            return false;
        }
        Set<String> connectorTags = detection.getTags();
        if (connectorTags == null) {
            return false;
        }
        return connectorTags.contains(tag);
    }

    @Generated
    private static Set<String> $default$extendsConnectors() {
        return new LinkedHashSet<String>();
    }

    @Generated
    private static Map<String, MetricDefinition> $default$metrics() {
        return new HashMap<String, MetricDefinition>();
    }

    @Generated
    private static Map<String, String> $default$constants() {
        return new HashMap<String, String>();
    }

    @Generated
    private static Set<String> $default$sudoCommands() {
        return new HashSet<String>();
    }

    @Generated
    private static Map<String, Source> $default$pre() {
        return new HashMap<String, Source>();
    }

    @Generated
    private static Map<String, MonitorJob> $default$monitors() {
        return new LinkedHashMap<String, MonitorJob>();
    }

    @Generated
    private static Map<String, TranslationTable> $default$translations() {
        return new HashMap<String, TranslationTable>();
    }

    @Generated
    private static Set<Class<? extends Source>> $default$sourceTypes() {
        return new HashSet<Class<? extends Source>>();
    }

    @Generated
    private static List<Set<String>> $default$preSourceDep() {
        return new ArrayList<Set<String>>();
    }

    @Generated
    public static ConnectorBuilder builder() {
        return new ConnectorBuilder();
    }

    @Generated
    public ConnectorIdentity getConnectorIdentity() {
        return this.connectorIdentity;
    }

    @Generated
    public Set<String> getExtendsConnectors() {
        return this.extendsConnectors;
    }

    @Generated
    public Map<String, MetricDefinition> getMetrics() {
        return this.metrics;
    }

    @Generated
    public Map<String, String> getConstants() {
        return this.constants;
    }

    @Generated
    public Set<String> getSudoCommands() {
        return this.sudoCommands;
    }

    @Generated
    public Map<String, Source> getPre() {
        return this.pre;
    }

    @Generated
    public Map<String, MonitorJob> getMonitors() {
        return this.monitors;
    }

    @Generated
    public Map<String, TranslationTable> getTranslations() {
        return this.translations;
    }

    @Generated
    public Set<Class<? extends Source>> getSourceTypes() {
        return this.sourceTypes;
    }

    @Generated
    public List<Set<String>> getPreSourceDep() {
        return this.preSourceDep;
    }

    @JsonProperty(value="connector")
    @Generated
    public void setConnectorIdentity(ConnectorIdentity connectorIdentity) {
        this.connectorIdentity = connectorIdentity;
    }

    @JsonProperty(value="extends")
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=ExtendsDeserializer.class)
    @Generated
    public void setExtendsConnectors(Set<String> extendsConnectors) {
        this.extendsConnectors = extendsConnectors;
    }

    @Generated
    public void setMetrics(Map<String, MetricDefinition> metrics) {
        this.metrics = metrics;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setConstants(Map<String, String> constants) {
        this.constants = constants;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setSudoCommands(Set<String> sudoCommands) {
        this.sudoCommands = sudoCommands;
    }

    @JsonDeserialize(using=SourcesDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setPre(Map<String, Source> pre) {
        this.pre = pre;
    }

    @Generated
    public void setMonitors(Map<String, MonitorJob> monitors) {
        this.monitors = monitors;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setTranslations(Map<String, TranslationTable> translations) {
        this.translations = translations;
    }

    @Generated
    public void setSourceTypes(Set<Class<? extends Source>> sourceTypes) {
        this.sourceTypes = sourceTypes;
    }

    @Generated
    public void setPreSourceDep(List<Set<String>> preSourceDep) {
        this.preSourceDep = preSourceDep;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Connector)) {
            return false;
        }
        Connector other = (Connector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConnectorIdentity this$connectorIdentity = this.getConnectorIdentity();
        ConnectorIdentity other$connectorIdentity = other.getConnectorIdentity();
        if (this$connectorIdentity == null ? other$connectorIdentity != null : !((Object)this$connectorIdentity).equals(other$connectorIdentity)) {
            return false;
        }
        Set<String> this$extendsConnectors = this.getExtendsConnectors();
        Set<String> other$extendsConnectors = other.getExtendsConnectors();
        if (this$extendsConnectors == null ? other$extendsConnectors != null : !((Object)this$extendsConnectors).equals(other$extendsConnectors)) {
            return false;
        }
        Map<String, MetricDefinition> this$metrics = this.getMetrics();
        Map<String, MetricDefinition> other$metrics = other.getMetrics();
        if (this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics)) {
            return false;
        }
        Map<String, String> this$constants = this.getConstants();
        Map<String, String> other$constants = other.getConstants();
        if (this$constants == null ? other$constants != null : !((Object)this$constants).equals(other$constants)) {
            return false;
        }
        Set<String> this$sudoCommands = this.getSudoCommands();
        Set<String> other$sudoCommands = other.getSudoCommands();
        if (this$sudoCommands == null ? other$sudoCommands != null : !((Object)this$sudoCommands).equals(other$sudoCommands)) {
            return false;
        }
        Map<String, Source> this$pre = this.getPre();
        Map<String, Source> other$pre = other.getPre();
        if (this$pre == null ? other$pre != null : !((Object)this$pre).equals(other$pre)) {
            return false;
        }
        Map<String, MonitorJob> this$monitors = this.getMonitors();
        Map<String, MonitorJob> other$monitors = other.getMonitors();
        if (this$monitors == null ? other$monitors != null : !((Object)this$monitors).equals(other$monitors)) {
            return false;
        }
        Map<String, TranslationTable> this$translations = this.getTranslations();
        Map<String, TranslationTable> other$translations = other.getTranslations();
        if (this$translations == null ? other$translations != null : !((Object)this$translations).equals(other$translations)) {
            return false;
        }
        Set<Class<? extends Source>> this$sourceTypes = this.getSourceTypes();
        Set<Class<? extends Source>> other$sourceTypes = other.getSourceTypes();
        if (this$sourceTypes == null ? other$sourceTypes != null : !((Object)this$sourceTypes).equals(other$sourceTypes)) {
            return false;
        }
        List<Set<String>> this$preSourceDep = this.getPreSourceDep();
        List<Set<String>> other$preSourceDep = other.getPreSourceDep();
        return !(this$preSourceDep == null ? other$preSourceDep != null : !((Object)this$preSourceDep).equals(other$preSourceDep));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Connector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectorIdentity $connectorIdentity = this.getConnectorIdentity();
        result = result * 59 + ($connectorIdentity == null ? 43 : ((Object)$connectorIdentity).hashCode());
        Set<String> $extendsConnectors = this.getExtendsConnectors();
        result = result * 59 + ($extendsConnectors == null ? 43 : ((Object)$extendsConnectors).hashCode());
        Map<String, MetricDefinition> $metrics = this.getMetrics();
        result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
        Map<String, String> $constants = this.getConstants();
        result = result * 59 + ($constants == null ? 43 : ((Object)$constants).hashCode());
        Set<String> $sudoCommands = this.getSudoCommands();
        result = result * 59 + ($sudoCommands == null ? 43 : ((Object)$sudoCommands).hashCode());
        Map<String, Source> $pre = this.getPre();
        result = result * 59 + ($pre == null ? 43 : ((Object)$pre).hashCode());
        Map<String, MonitorJob> $monitors = this.getMonitors();
        result = result * 59 + ($monitors == null ? 43 : ((Object)$monitors).hashCode());
        Map<String, TranslationTable> $translations = this.getTranslations();
        result = result * 59 + ($translations == null ? 43 : ((Object)$translations).hashCode());
        Set<Class<? extends Source>> $sourceTypes = this.getSourceTypes();
        result = result * 59 + ($sourceTypes == null ? 43 : ((Object)$sourceTypes).hashCode());
        List<Set<String>> $preSourceDep = this.getPreSourceDep();
        result = result * 59 + ($preSourceDep == null ? 43 : ((Object)$preSourceDep).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Connector(connectorIdentity=" + String.valueOf(this.getConnectorIdentity()) + ", extendsConnectors=" + String.valueOf(this.getExtendsConnectors()) + ", metrics=" + String.valueOf(this.getMetrics()) + ", constants=" + String.valueOf(this.getConstants()) + ", sudoCommands=" + String.valueOf(this.getSudoCommands()) + ", pre=" + String.valueOf(this.getPre()) + ", monitors=" + String.valueOf(this.getMonitors()) + ", translations=" + String.valueOf(this.getTranslations()) + ", sourceTypes=" + String.valueOf(this.getSourceTypes()) + ", preSourceDep=" + String.valueOf(this.getPreSourceDep()) + ")";
    }

    @Generated
    public Connector(ConnectorIdentity connectorIdentity, Set<String> extendsConnectors, Map<String, MetricDefinition> metrics, Map<String, String> constants, Set<String> sudoCommands, Map<String, Source> pre, Map<String, MonitorJob> monitors, Map<String, TranslationTable> translations, Set<Class<? extends Source>> sourceTypes, List<Set<String>> preSourceDep) {
        this.connectorIdentity = connectorIdentity;
        this.extendsConnectors = extendsConnectors;
        this.metrics = metrics;
        this.constants = constants;
        this.sudoCommands = sudoCommands;
        this.pre = pre;
        this.monitors = monitors;
        this.translations = translations;
        this.sourceTypes = sourceTypes;
        this.preSourceDep = preSourceDep;
    }

    @Generated
    public Connector() {
        this.extendsConnectors = Connector.$default$extendsConnectors();
        this.metrics = Connector.$default$metrics();
        this.constants = Connector.$default$constants();
        this.sudoCommands = Connector.$default$sudoCommands();
        this.pre = Connector.$default$pre();
        this.monitors = Connector.$default$monitors();
        this.translations = Connector.$default$translations();
        this.sourceTypes = Connector.$default$sourceTypes();
        this.preSourceDep = Connector.$default$preSourceDep();
    }

    @Generated
    public static class ConnectorBuilder {
        @Generated
        private ConnectorIdentity connectorIdentity;
        @Generated
        private boolean extendsConnectors$set;
        @Generated
        private Set<String> extendsConnectors$value;
        @Generated
        private boolean metrics$set;
        @Generated
        private Map<String, MetricDefinition> metrics$value;
        @Generated
        private boolean constants$set;
        @Generated
        private Map<String, String> constants$value;
        @Generated
        private boolean sudoCommands$set;
        @Generated
        private Set<String> sudoCommands$value;
        @Generated
        private boolean pre$set;
        @Generated
        private Map<String, Source> pre$value;
        @Generated
        private boolean monitors$set;
        @Generated
        private Map<String, MonitorJob> monitors$value;
        @Generated
        private boolean translations$set;
        @Generated
        private Map<String, TranslationTable> translations$value;
        @Generated
        private boolean sourceTypes$set;
        @Generated
        private Set<Class<? extends Source>> sourceTypes$value;
        @Generated
        private boolean preSourceDep$set;
        @Generated
        private List<Set<String>> preSourceDep$value;

        @Generated
        ConnectorBuilder() {
        }

        @JsonProperty(value="connector")
        @Generated
        public ConnectorBuilder connectorIdentity(ConnectorIdentity connectorIdentity) {
            this.connectorIdentity = connectorIdentity;
            return this;
        }

        @JsonProperty(value="extends")
        @JsonSetter(nulls=Nulls.SKIP)
        @JsonDeserialize(using=ExtendsDeserializer.class)
        @Generated
        public ConnectorBuilder extendsConnectors(Set<String> extendsConnectors) {
            this.extendsConnectors$value = extendsConnectors;
            this.extendsConnectors$set = true;
            return this;
        }

        @Generated
        public ConnectorBuilder metrics(Map<String, MetricDefinition> metrics) {
            this.metrics$value = metrics;
            this.metrics$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public ConnectorBuilder constants(Map<String, String> constants) {
            this.constants$value = constants;
            this.constants$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public ConnectorBuilder sudoCommands(Set<String> sudoCommands) {
            this.sudoCommands$value = sudoCommands;
            this.sudoCommands$set = true;
            return this;
        }

        @JsonDeserialize(using=SourcesDeserializer.class)
        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public ConnectorBuilder pre(Map<String, Source> pre) {
            this.pre$value = pre;
            this.pre$set = true;
            return this;
        }

        @Generated
        public ConnectorBuilder monitors(Map<String, MonitorJob> monitors) {
            this.monitors$value = monitors;
            this.monitors$set = true;
            return this;
        }

        @JsonSetter(nulls=Nulls.SKIP)
        @Generated
        public ConnectorBuilder translations(Map<String, TranslationTable> translations) {
            this.translations$value = translations;
            this.translations$set = true;
            return this;
        }

        @Generated
        public ConnectorBuilder sourceTypes(Set<Class<? extends Source>> sourceTypes) {
            this.sourceTypes$value = sourceTypes;
            this.sourceTypes$set = true;
            return this;
        }

        @Generated
        public ConnectorBuilder preSourceDep(List<Set<String>> preSourceDep) {
            this.preSourceDep$value = preSourceDep;
            this.preSourceDep$set = true;
            return this;
        }

        @Generated
        public Connector build() {
            Set<String> extendsConnectors$value = this.extendsConnectors$value;
            if (!this.extendsConnectors$set) {
                extendsConnectors$value = Connector.$default$extendsConnectors();
            }
            Map<String, MetricDefinition> metrics$value = this.metrics$value;
            if (!this.metrics$set) {
                metrics$value = Connector.$default$metrics();
            }
            Map<String, String> constants$value = this.constants$value;
            if (!this.constants$set) {
                constants$value = Connector.$default$constants();
            }
            Set<String> sudoCommands$value = this.sudoCommands$value;
            if (!this.sudoCommands$set) {
                sudoCommands$value = Connector.$default$sudoCommands();
            }
            Map<String, Source> pre$value = this.pre$value;
            if (!this.pre$set) {
                pre$value = Connector.$default$pre();
            }
            Map<String, MonitorJob> monitors$value = this.monitors$value;
            if (!this.monitors$set) {
                monitors$value = Connector.$default$monitors();
            }
            Map<String, TranslationTable> translations$value = this.translations$value;
            if (!this.translations$set) {
                translations$value = Connector.$default$translations();
            }
            Set<Class<? extends Source>> sourceTypes$value = this.sourceTypes$value;
            if (!this.sourceTypes$set) {
                sourceTypes$value = Connector.$default$sourceTypes();
            }
            List<Set<String>> preSourceDep$value = this.preSourceDep$value;
            if (!this.preSourceDep$set) {
                preSourceDep$value = Connector.$default$preSourceDep();
            }
            return new Connector(this.connectorIdentity, extendsConnectors$value, metrics$value, constants$value, sudoCommands$value, pre$value, monitors$value, translations$value, sourceTypes$value, preSourceDep$value);
        }

        @Generated
        public String toString() {
            return "Connector.ConnectorBuilder(connectorIdentity=" + String.valueOf(this.connectorIdentity) + ", extendsConnectors$value=" + String.valueOf(this.extendsConnectors$value) + ", metrics$value=" + String.valueOf(this.metrics$value) + ", constants$value=" + String.valueOf(this.constants$value) + ", sudoCommands$value=" + String.valueOf(this.sudoCommands$value) + ", pre$value=" + String.valueOf(this.pre$value) + ", monitors$value=" + String.valueOf(this.monitors$value) + ", translations$value=" + String.valueOf(this.translations$value) + ", sourceTypes$value=" + String.valueOf(this.sourceTypes$value) + ", preSourceDep$value=" + String.valueOf(this.preSourceDep$value) + ")";
        }
    }
}

