/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.deserializer.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;

public abstract class AbstractMapDeserializer<T>
extends JsonDeserializer<Map<String, T>> {
    protected String nodePath;

    public Map<String, T> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        if (parser == null) {
            return this.emptyMap();
        }
        this.nodePath = this.getNodePath(parser.getParsingContext().getParent(), new LinkedList<String>());
        Map map = (Map)parser.readValueAs(this.getTypeReference());
        if (map == null) {
            return this.emptyMap();
        }
        if (!this.isValidMap(map)) {
            throw new InvalidFormatException(parser, this.messageOnInvalidMap(parser.getCurrentName()), (Object)map, Map.class);
        }
        this.updateMapValues(parser, ctxt, map);
        if (this.isExpectedInstance(map)) {
            return map;
        }
        return this.fromMap(map);
    }

    private String getNodePath(JsonStreamContext context, LinkedList<String> path) {
        if (context != null && context.getParent() != null) {
            if (context.inObject()) {
                path.push(context.getCurrentName());
            } else if (context.inArray()) {
                path.push(String.format("[%s]", context.getCurrentIndex()));
            }
            this.getNodePath(context.getParent(), path);
        }
        return path.stream().collect(Collectors.joining(".", "${source::", ""));
    }

    protected abstract void updateMapValues(JsonParser var1, DeserializationContext var2, Map<String, T> var3);

    protected abstract String messageOnInvalidMap(String var1);

    protected abstract Map<String, T> fromMap(Map<String, T> var1);

    protected abstract boolean isExpectedInstance(Map<String, T> var1);

    protected abstract Map<String, T> emptyMap();

    protected abstract boolean isValidMap(Map<String, T> var1);

    protected abstract TypeReference<Map<String, T>> getTypeReference();
}

