/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.configuration;

import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;

public class SnmpConfiguration
implements IConfiguration {
    private static final String INVALID_SNMP_VERSION_EXCEPTION_MESSAGE = "Invalid SNMP version: ";
    private final SnmpVersion version;
    private final String community;
    private Integer port;
    private final Long timeout;

    public String toString() {
        return this.version.getDisplayName() + " (" + this.community + ")";
    }

    @Generated
    private static SnmpVersion $default$version() {
        return SnmpVersion.V1;
    }

    @Generated
    private static String $default$community() {
        return "public";
    }

    @Generated
    private static Integer $default$port() {
        return 161;
    }

    @Generated
    private static Long $default$timeout() {
        return 120L;
    }

    @Generated
    public static SnmpConfigurationBuilder builder() {
        return new SnmpConfigurationBuilder();
    }

    @Generated
    public SnmpVersion getVersion() {
        return this.version;
    }

    @Generated
    public String getCommunity() {
        return this.community;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpConfiguration)) {
            return false;
        }
        SnmpConfiguration other = (SnmpConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        SnmpVersion this$version = this.getVersion();
        SnmpVersion other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)((Object)this$version)).equals((Object)other$version)) {
            return false;
        }
        String this$community = this.getCommunity();
        String other$community = other.getCommunity();
        return !(this$community == null ? other$community != null : !this$community.equals(other$community));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnmpConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        SnmpVersion $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)((Object)$version)).hashCode());
        String $community = this.getCommunity();
        result = result * 59 + ($community == null ? 43 : $community.hashCode());
        return result;
    }

    @Generated
    public SnmpConfiguration(SnmpVersion version, String community, Integer port, Long timeout) {
        this.version = version;
        this.community = community;
        this.port = port;
        this.timeout = timeout;
    }

    @Generated
    public SnmpConfiguration() {
        this.version = SnmpConfiguration.$default$version();
        this.community = SnmpConfiguration.$default$community();
        this.port = SnmpConfiguration.$default$port();
        this.timeout = SnmpConfiguration.$default$timeout();
    }

    public static enum SnmpVersion {
        V1(1, "SNMP v1"),
        V2C(2, "SNMP v2c");

        private final int intVersion;
        private final String displayName;

        public static SnmpVersion interpretValueOf(@NonNull String version) {
            if (version == null) {
                throw new IllegalArgumentException("version is marked non-null but is null");
            }
            String lowerCaseVersion = version.toLowerCase();
            if ("1".equals(lowerCaseVersion) || "v1".equals(lowerCaseVersion)) {
                return V1;
            }
            if ("2".equals(lowerCaseVersion) || "v2".equals(lowerCaseVersion) || "v2c".equals(lowerCaseVersion)) {
                return V2C;
            }
            throw new IllegalArgumentException(SnmpConfiguration.INVALID_SNMP_VERSION_EXCEPTION_MESSAGE + version);
        }

        @Generated
        private SnmpVersion(int intVersion, String displayName) {
            this.intVersion = intVersion;
            this.displayName = displayName;
        }

        @Generated
        public int getIntVersion() {
            return this.intVersion;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }
    }

    @Generated
    public static class SnmpConfigurationBuilder {
        @Generated
        private boolean version$set;
        @Generated
        private SnmpVersion version$value;
        @Generated
        private boolean community$set;
        @Generated
        private String community$value;
        @Generated
        private boolean port$set;
        @Generated
        private Integer port$value;
        @Generated
        private boolean timeout$set;
        @Generated
        private Long timeout$value;

        @Generated
        SnmpConfigurationBuilder() {
        }

        @Generated
        public SnmpConfigurationBuilder version(SnmpVersion version) {
            this.version$value = version;
            this.version$set = true;
            return this;
        }

        @Generated
        public SnmpConfigurationBuilder community(String community) {
            this.community$value = community;
            this.community$set = true;
            return this;
        }

        @Generated
        public SnmpConfigurationBuilder port(Integer port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        @Generated
        public SnmpConfigurationBuilder timeout(Long timeout) {
            this.timeout$value = timeout;
            this.timeout$set = true;
            return this;
        }

        @Generated
        public SnmpConfiguration build() {
            SnmpVersion version$value = this.version$value;
            if (!this.version$set) {
                version$value = SnmpConfiguration.$default$version();
            }
            String community$value = this.community$value;
            if (!this.community$set) {
                community$value = SnmpConfiguration.$default$community();
            }
            Integer port$value = this.port$value;
            if (!this.port$set) {
                port$value = SnmpConfiguration.$default$port();
            }
            Long timeout$value = this.timeout$value;
            if (!this.timeout$set) {
                timeout$value = SnmpConfiguration.$default$timeout();
            }
            return new SnmpConfiguration(version$value, community$value, port$value, timeout$value);
        }

        @Generated
        public String toString() {
            return "SnmpConfiguration.SnmpConfigurationBuilder(version$value=" + String.valueOf((Object)this.version$value) + ", community$value=" + this.community$value + ", port$value=" + this.port$value + ", timeout$value=" + this.timeout$value + ")";
        }
    }
}

