/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.LocalOsHandler;

public class FileHelper {
    public static long getLastModifiedTime(@NonNull Path path) {
        if (path == null) {
            throw new IllegalArgumentException("path is marked non-null but is null");
        }
        try {
            return Files.getLastModifiedTime(path, LinkOption.NOFOLLOW_LINKS).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public static Path findConnectorsDirectory(URI zipUri) {
        String strPath = zipUri.toString();
        int connectorsIndex = strPath.lastIndexOf("/connectors/");
        if (connectorsIndex == -1) {
            return null;
        }
        int beginIndex = LocalOsHandler.isWindows() ? "jar:file:///".length() : "jar:file://".length();
        return Paths.get(strPath.substring(beginIndex, connectorsIndex + 1 + "connectors".length()), new String[0]);
    }

    public static void fileSystemTask(@NonNull URI uri, @NonNull Map<String, ?> env, @NonNull Runnable runnable) throws IOException {
        if (uri == null) {
            throw new IllegalArgumentException("uri is marked non-null but is null");
        }
        if (env == null) {
            throw new IllegalArgumentException("env is marked non-null but is null");
        }
        if (runnable == null) {
            throw new IllegalArgumentException("runnable is marked non-null but is null");
        }
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
            runnable.run();
        }
    }

    public static <T> T fileSystemTask(@NonNull URI uri, @NonNull Map<String, ?> env, @NonNull Callable<T> callable) throws Exception {
        if (uri == null) {
            throw new IllegalArgumentException("uri is marked non-null but is null");
        }
        if (env == null) {
            throw new IllegalArgumentException("env is marked non-null but is null");
        }
        if (callable == null) {
            throw new IllegalArgumentException("callable is marked non-null but is null");
        }
        try (FileSystem fs = FileSystems.newFileSystem(uri, env);){
            T t = callable.call();
            return t;
        }
    }

    public static String readFileContent(Path filePath) throws IOException {
        try (Stream<String> lines = Files.lines(filePath);){
            String string = lines.collect(Collectors.joining("\n"));
            return string;
        }
    }

    @Generated
    private FileHelper() {
    }
}

