/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.client.http;

import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;

public class Url {
    public static String format(@NonNull String hostname, @NonNull Integer port, @NonNull String requestPath, @NonNull String protocol) {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (port == null) {
            throw new IllegalArgumentException("port is marked non-null but is null");
        }
        if (requestPath == null) {
            throw new IllegalArgumentException("requestPath is marked non-null but is null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is marked non-null but is null");
        }
        String fullUrl = String.format("%s://%s:%d%s%s", protocol, hostname, port, requestPath.startsWith("/") ? "" : "/", requestPath);
        return fullUrl.replace("%{HOSTNAME}", hostname);
    }

    public static String format(@NonNull String url, @NonNull String path) {
        if (url == null) {
            throw new IllegalArgumentException("url is marked non-null but is null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path is marked non-null but is null");
        }
        return String.format("%s%s%s", url, url.endsWith("/") || path.startsWith("/") ? "" : "/", url.endsWith("/") && path.startsWith("/") ? path.substring(1) : path);
    }

    public static String format(String protocol, String hostname, Integer port, String path, String url) {
        if (StringHelper.nonNullNonBlank(url) && StringHelper.nonNullNonBlank(path)) {
            return Url.format(url, path);
        }
        if (StringHelper.nonNullNonBlank(url)) {
            return url;
        }
        if (StringHelper.nonNullNonBlank(path)) {
            return Url.format(hostname, port, path, protocol);
        }
        throw new IllegalArgumentException("At least one of the required properties 'url' or 'path' must be specified, but both are missing");
    }

    @Generated
    private Url() {
    }
}

