/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.client.http;

import java.util.Base64;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.JUtils;

public class HttpMacrosUpdater {
    private static final String PASSWORD_BASE64_MACRO = "%{PASSWORD_BASE64}";
    private static final String BASIC_AUTH_BASE64_MACRO = "%{BASIC_AUTH_BASE64}";
    private static final String SHA256_AUTH_MACRO = "%{SHA256_AUTH}";

    public static String update(String text, String username, char[] password, String authenticationToken, @NonNull String hostname) {
        if (hostname == null) {
            throw new IllegalArgumentException("hostname is marked non-null but is null");
        }
        if (text == null || text.isEmpty()) {
            return "";
        }
        String passwordAsString = password != null ? String.valueOf(password) : "";
        username = username != null ? username : "";
        authenticationToken = authenticationToken != null ? authenticationToken : "";
        String updatedContent = text.replace("%{USERNAME}", username).replace("%{HOSTNAME}", hostname).replace("%{PASSWORD}", passwordAsString).replace("%{AUTHENTICATIONTOKEN}", authenticationToken);
        if (updatedContent.indexOf(PASSWORD_BASE64_MACRO) != -1) {
            updatedContent = updatedContent.replace(PASSWORD_BASE64_MACRO, Base64.getEncoder().encodeToString(passwordAsString.getBytes()));
        }
        if (updatedContent.indexOf(BASIC_AUTH_BASE64_MACRO) != -1) {
            updatedContent = updatedContent.replace(BASIC_AUTH_BASE64_MACRO, Base64.getEncoder().encodeToString(String.format("%s:%s", username, passwordAsString).getBytes()));
        }
        if (updatedContent.indexOf(SHA256_AUTH_MACRO) != -1) {
            updatedContent = updatedContent.replace(SHA256_AUTH_MACRO, JUtils.encodeSha256(authenticationToken));
        }
        return updatedContent;
    }

    @Generated
    private HttpMacrosUpdater() {
    }
}

