/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import uk.co.westhawk.snmp.beans.UsmDiscoveryBean;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextv3Basis;
import uk.co.westhawk.snmp.stack.TimeWindow;
import uk.co.westhawk.snmp.stack.TimeWindowNode;
import uk.co.westhawk.snmp.stack.UsmAgent;

public class DefaultUsmAgent
implements UsmAgent {
    static final String version_id = "@(#)$Id: DefaultUsmAgent.java,v 3.10 2009/03/05 15:51:42 birgita Exp $ Copyright Westhawk Ltd";
    public static final String LOCAL_HOST = "localhost";
    public static final int LOCAL_PORT = 161;
    private SnmpContextv3Basis context;
    private String hostname;
    private String hostaddress;
    private int port;

    public DefaultUsmAgent() {
        try {
            this.setAgentName(LOCAL_HOST);
        }
        catch (UnknownHostException exc) {
            this.hostname = LOCAL_HOST;
            this.hostaddress = "127.0.0.1";
        }
        this.setAgentPort(161);
    }

    @Override
    public String getSnmpEngineId() {
        TimeWindow tWindow = TimeWindow.getCurrent();
        String engineId = tWindow.getSnmpEngineId(this.hostaddress, this.port);
        return engineId;
    }

    @Override
    public int getSnmpEngineBoots() {
        int boots = 1;
        TimeWindowNode node = null;
        TimeWindow tWindow = TimeWindow.getCurrent();
        String engineId = tWindow.getSnmpEngineId(this.hostaddress, this.port);
        if (engineId != null) {
            node = tWindow.getTimeLine(engineId);
        }
        if (node != null) {
            boots = node.getSnmpEngineBoots();
        }
        return boots;
    }

    @Override
    public int getSnmpEngineTime() {
        int time = 1;
        TimeWindowNode node = null;
        TimeWindow tWindow = TimeWindow.getCurrent();
        String engineId = tWindow.getSnmpEngineId(this.hostaddress, this.port);
        if (engineId != null) {
            node = tWindow.getTimeLine(engineId);
        }
        if (node != null) {
            time = node.getSnmpEngineTime();
        }
        return time;
    }

    @Override
    public void setSnmpContext(SnmpContextv3Basis c) {
        block4: {
            this.context = c;
            try {
                this.discoverIfNeeded();
            }
            catch (PduException exc) {
                if (AsnObject.debug > 4) {
                    System.out.println(this.getClass().getName() + ".setSnmpContext(): " + exc.getMessage());
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 4) break block4;
                System.out.println(this.getClass().getName() + ".setSnmpContext(): " + exc.getMessage());
            }
        }
    }

    public void setAgentName(String host) throws UnknownHostException {
        this.hostname = host;
        InetAddress ipAddr = InetAddress.getByName(this.hostname);
        this.hostaddress = ipAddr.getHostAddress();
    }

    public void setAgentPort(int p) {
        this.port = p;
    }

    void discoverIfNeeded() throws IOException, PduException {
        UsmDiscoveryBean discBean = null;
        boolean isNeeded = false;
        TimeWindow tWindow = TimeWindow.getCurrent();
        String engineId = tWindow.getSnmpEngineId(this.hostaddress, this.port);
        if (engineId == null) {
            isNeeded = true;
            discBean = new UsmDiscoveryBean(this.hostname, this.port, this.context.getBindAddress(), this.context.getTypeSocket());
        }
        if (this.context.isUseAuthentication()) {
            if (isNeeded) {
                discBean.setAuthenticationDetails(this.context.getUserName(), this.context.getUserAuthenticationPassword(), this.context.getAuthenticationProtocol());
            } else if (!tWindow.isTimeLineKnown(engineId)) {
                isNeeded = true;
                discBean = new UsmDiscoveryBean(this.hostname, this.port, this.context.getBindAddress(), this.context.getTypeSocket());
                discBean.setAuthenticationDetails(this.context.getUserName(), this.context.getUserAuthenticationPassword(), this.context.getAuthenticationProtocol());
            }
            if (isNeeded && this.context.isUsePrivacy()) {
                discBean.setPrivacyDetails(this.context.getUserPrivacyPassword(), this.context.getPrivacyProtocol());
            }
        }
        if (isNeeded) {
            discBean.startDiscovery();
            discBean.freeResources();
        }
    }

    @Override
    public long getUsmStatsUnknownEngineIDs() {
        return 0L;
    }

    @Override
    public long getUsmStatsNotInTimeWindows() {
        return 0L;
    }
}

