/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.westhawk.snmp.stack.AsnObject;

public class AsnUnsInteger64
extends AsnObject {
    private static final String version_id = "@(#)$Id: AsnUnsInteger64.java,v 3.16 2009/03/05 13:11:33 birgita Exp $ Copyright Westhawk Ltd";
    protected long value;

    public AsnUnsInteger64(long v) {
        this.value = v;
        this.type = (byte)70;
    }

    public AsnUnsInteger64(InputStream in, int len) throws IOException {
        byte[] data = new byte[len];
        if (len != in.read(data, 0, len)) {
            throw new IOException("AsnUnsInteger64(): Not enough data");
        }
        this.value = this.bytesToLong(data);
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    int size() {
        int count;
        int empty = 0;
        int sign = 0;
        if (this.value < 0L) {
            empty = 255;
            sign = 128;
        }
        for (count = 56; count > 0 && (this.value >> count & 0xFFL) == (long)empty; count -= 8) {
        }
        if ((this.value >> count & 0x80L) != (long)sign) {
            count += 8;
        }
        return (count >> 3) + 1;
    }

    @Override
    void write(OutputStream out, int pos) throws IOException {
        int count;
        int empty = 0;
        int sign = 0;
        if (this.value < 0L) {
            empty = 255;
            sign = 128;
        }
        for (count = 56; count > 0 && (this.value >> count & 0xFFL) == (long)empty; count -= 8) {
        }
        if ((this.value >> count & 0x80L) != (long)sign) {
            count += 8;
        }
        this.AsnBuildHeader(out, (byte)70, (count >> 3) + 1);
        if (debug > 10) {
            System.out.println("\tAsnUnsInteger64(): value = " + this.value + ", pos = " + pos);
        }
        while (count >= 0) {
            out.write((byte)(this.value >> count & 0xFFL));
            count -= 8;
        }
    }

    protected long bytesToLong(byte[] data) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        long val2 = 0L;
        int size = data.length;
        for (int n = 0; n < size; ++n) {
            val2 = (val2 << 8) + (long)dis.readUnsignedByte();
        }
        return val2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AsnUnsInteger64) {
            return this.value == ((AsnUnsInteger64)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }
}

