/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.EncodingException;

public class AsnObjectId
extends AsnObject
implements Comparable {
    private static final String version_id = "@(#)$Id: AsnObjectId.java,v 3.25 2008/08/19 13:34:13 birgita Exp $ Copyright Westhawk Ltd";
    private long[] value = new long[0];
    static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    protected AsnObjectId() {
        this.type = (byte)6;
    }

    AsnObjectId(InputStream in, int len) throws IOException {
        int off;
        byte[] data = new byte[len];
        if (len != in.read(data, 0, len)) {
            throw new IOException("AsnObjectId(): Not enough data");
        }
        int sids = 1;
        for (off = 0; off < len; ++off) {
            if (data[off] < 0) continue;
            ++sids;
        }
        this.value = new long[sids];
        if (len > 0) {
            this.value[0] = data[0] / 40;
            if (this.value.length > 1) {
                this.value[1] = data[0] % 40;
            }
        }
        off = 1;
        for (int idx = 2; idx < this.value.length; ++idx) {
            long tval = 0L;
            do {
                tval <<= 7;
                tval |= (long)(data[off] & 0x7F);
            } while (data[off++] < 0);
            this.value[idx] = tval;
        }
    }

    public AsnObjectId(String s) throws IllegalArgumentException {
        this();
        this.value = this.toArrayOfLongs(s);
    }

    public AsnObjectId(long[] oida) {
        this();
        int len = oida.length;
        this.value = new long[len];
        System.arraycopy(oida, 0, this.value, 0, len);
    }

    private long[] toArrayOfLongs(String s) throws IllegalArgumentException {
        long[] oidArray = new long[]{};
        if (s != null && s.length() > 0) {
            StringTokenizer tok = new StringTokenizer(s, ".");
            int count = tok.countTokens();
            oidArray = new long[count];
            int n = 0;
            while (tok.hasMoreTokens()) {
                try {
                    String num = tok.nextToken();
                    Long val2 = Long.valueOf(num);
                    oidArray[n] = val2;
                    ++n;
                }
                catch (NumberFormatException exc) {
                    throw new IllegalArgumentException("AsnObjectId(): Bad OID '" + s + "' " + exc.getMessage());
                }
                catch (NoSuchElementException noSuchElementException) {
                }
            }
        } else {
            throw new IllegalArgumentException("AsnObjectId(): Bad OID '" + s + "' ");
        }
        return oidArray;
    }

    public boolean startsWith(AsnObjectId prefix) {
        boolean sw = true;
        if (prefix.value.length < this.value.length) {
            for (int pos = 0; pos < prefix.value.length && sw; ++pos) {
                sw = prefix.value[pos] == this.value[pos];
            }
        } else {
            sw = false;
        }
        return sw;
    }

    public void add(long sub_oid) {
        int size = this.value.length;
        long[] tmp_value = this.value;
        this.value = new long[size + 1];
        System.arraycopy(tmp_value, 0, this.value, 0, size);
        this.value[size] = sub_oid;
    }

    public void add(long[] sub_oid) {
        int size1 = this.value.length;
        int size2 = sub_oid.length;
        long[] tmp_value = this.value;
        this.value = new long[size1 + size2];
        System.arraycopy(tmp_value, 0, this.value, 0, size1);
        System.arraycopy(sub_oid, 0, this.value, size1, size2);
    }

    public void add(String s) throws IllegalArgumentException {
        long[] sub_oid = this.toArrayOfLongs(s);
        this.add(sub_oid);
    }

    public long removeLast() {
        long lastSubOid = -1L;
        int size = this.value.length;
        if (size > 0) {
            lastSubOid = this.value[--size];
            long[] tmp_value = this.value;
            this.value = new long[size];
            System.arraycopy(tmp_value, 0, this.value, 0, size);
        }
        return lastSubOid;
    }

    @Override
    int size() throws EncodingException {
        int len;
        if (this.value.length > 1) {
            len = this.getSIDLen(this.value[0] * 40L + this.value[1]);
            for (int idx = 2; idx < this.value.length; ++idx) {
                len += this.getSIDLen(this.value[idx]);
            }
        } else if (this.value.length == 1) {
            len = this.getSIDLen(this.value[0] * 40L);
        } else if (this.value.length == 0) {
            len = this.getSIDLen(0L);
        } else {
            throw new EncodingException("Negative numbers cannot be encoded as OID sub-identifiers");
        }
        return len;
    }

    @Override
    void write(OutputStream out, int pos) throws IOException, EncodingException {
        this.AsnBuildHeader(out, (byte)6, this.size());
        if (debug > 10) {
            System.out.println("\tAsnObjectId(): value = " + this.toString() + ", pos = " + pos);
        }
        if (this.value.length > 1) {
            this.EncodeSID(out, this.value[0] * 40L + this.value[1]);
            for (int idx = 2; idx < this.value.length; ++idx) {
                this.EncodeSID(out, this.value[idx]);
            }
        } else if (this.value.length == 1) {
            this.EncodeSID(out, this.value[0] * 40L);
        } else {
            this.EncodeSID(out, 0L);
        }
    }

    private int getSIDLen(long value) {
        int count = 1;
        while ((value >>= 7) != 0L) {
            ++count;
        }
        return count;
    }

    private void EncodeSID(OutputStream out, long value) throws IOException {
        int mask = 15;
        int count = 0;
        mask = 15;
        for (count = 28; count > 0 && (value >> count & (long)mask) == 0L; count -= 7) {
            mask = 127;
        }
        while (count >= 0) {
            out.write((byte)(value >> count & (long)mask | (long)(count > 0 ? 128 : 0)));
            mask = 127;
            count -= 7;
        }
    }

    public String getValue() {
        return this.toString();
    }

    @Override
    public String toString() {
        return this.toString(this.value);
    }

    public String toString(long[] v) {
        StringBuffer buffer = new StringBuffer("");
        if (v.length > 0) {
            for (int n = 0; n < v.length - 1 && n < 100; ++n) {
                if (0L <= v[n] && v[n] <= 9L) {
                    int i = (int)v[n];
                    buffer.append(digits[i]);
                } else {
                    buffer.append(v[n]);
                }
                buffer.append(".");
            }
            if (v.length - 1 > 100) {
                buffer.append("[.. cut ..].");
            }
            buffer.append(v[v.length - 1]);
        }
        return buffer.toString();
    }

    public int getSize() {
        return this.value.length;
    }

    public synchronized long getElementAt(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this.value.length) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.value.length);
        }
        try {
            return this.value[index];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public long lastElement() throws ArrayIndexOutOfBoundsException {
        return this.getElementAt(this.value.length - 1);
    }

    public long[] getOid() {
        int len = this.value.length;
        long[] oida = new long[len];
        System.arraycopy(this.value, 0, oida, 0, len);
        return oida;
    }

    public long[] getSubOid(int beginIndex, int endIndex) throws ArrayIndexOutOfBoundsException {
        int len1 = this.value.length;
        if (beginIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(beginIndex + " < 0");
        }
        if (endIndex > len1) {
            throw new ArrayIndexOutOfBoundsException(endIndex + " > " + len1);
        }
        if (beginIndex > endIndex) {
            throw new ArrayIndexOutOfBoundsException(beginIndex + " > " + endIndex);
        }
        int len2 = endIndex - beginIndex;
        long[] oida = new long[len2];
        System.arraycopy(this.value, beginIndex, oida, 0, len2);
        return oida;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof AsnObjectId) {
            AsnObjectId anotherOid = (AsnObjectId)anObject;
            int n = this.value.length;
            if (n == anotherOid.value.length) {
                long[] v1 = this.value;
                long[] v2 = anotherOid.value;
                int i = 0;
                int j = 0;
                while (n-- != 0) {
                    if (v1[i++] == v2[j++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        if (h == 0) {
            int off = 0;
            long[] val2 = this.value;
            int len = this.value.length;
            for (int i = 0; i < len; ++i) {
                long l = val2[off++];
                int hi = (int)(l ^ l >>> 32);
                h = 31 * h + hi;
            }
        }
        return h;
    }

    public int compareTo(Object o) {
        return this.compareTo((AsnObjectId)o);
    }

    public int compareTo(AsnObjectId b) {
        if (b == null) {
            throw new NullPointerException("Trying to compare with null");
        }
        int aElts = this.getSize();
        int bElts = b.getSize();
        if (aElts == 0 && bElts > 0) {
            return -1;
        }
        if (bElts == 0 && aElts > 0) {
            return 1;
        }
        for (int i = 0; i < aElts && i < bElts; ++i) {
            if (this.getElementAt(i) == b.getElementAt(i)) continue;
            if (this.getElementAt(i) > b.getElementAt(i)) {
                return 1;
            }
            return -1;
        }
        if (aElts > bElts) {
            return 1;
        }
        if (bElts > aElts) {
            return -1;
        }
        return 0;
    }

    public int leftMostCompare(int n, AsnObjectId b) {
        int bElts;
        if (b == null) {
            throw new NullPointerException("Trying to compare with null");
        }
        int aElts = this.getSize();
        int min = Math.min(aElts, bElts = b.getSize());
        if (min < n) {
            if (aElts > bElts) {
                return 1;
            }
            if (bElts > aElts) {
                return -1;
            }
            return this.compareTo(b);
        }
        long[] aOids = this.getSubOid(0, n);
        long[] bOids = b.getSubOid(0, n);
        AsnObjectId aCopy = new AsnObjectId(aOids);
        AsnObjectId bCopy = new AsnObjectId(bOids);
        return aCopy.compareTo(bCopy);
    }
}

