/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import uk.co.westhawk.snmp.stack.AsnObject;

public class AsnInteger
extends AsnObject {
    private static final String version_id = "@(#)$Id: AsnInteger.java,v 3.14 2008/05/27 15:40:14 birgita Exp $ Copyright Westhawk Ltd";
    protected int value;

    public AsnInteger(int v) {
        this.value = v;
        this.type = (byte)2;
    }

    public AsnInteger(InputStream in, int len) throws IOException {
        int val2;
        byte[] data = new byte[len];
        if (len != in.read(data, 0, len)) {
            throw new IOException("AsnInteger(): Not enough data");
        }
        this.value = val2 = this.bytesToInteger(data);
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    int size() {
        int count;
        int empty = 0;
        int sign = 0;
        if (this.value < 0) {
            empty = 255;
            sign = 128;
        }
        for (count = 24; count > 0 && (this.value >> count & 0xFF) == empty; count -= 8) {
        }
        if ((this.value >> count & 0x80) != sign) {
            count += 8;
        }
        return (count >> 3) + 1;
    }

    @Override
    void write(OutputStream out, int pos) throws IOException {
        int count;
        int empty = 0;
        int sign = 0;
        if (this.value < 0) {
            empty = 255;
            sign = 128;
        }
        for (count = 24; count > 0 && (this.value >> count & 0xFF) == empty; count -= 8) {
        }
        if ((this.value >> count & 0x80) != sign) {
            count += 8;
        }
        this.AsnBuildHeader(out, (byte)2, (count >> 3) + 1);
        if (debug > 10) {
            System.out.println("\tAsnInteger(): value = " + this.value + ", pos = " + pos);
        }
        while (count >= 0) {
            out.write((byte)(this.value >> count & 0xFF));
            count -= 8;
        }
    }

    protected int bytesToInteger(byte[] data) throws IOException {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));
        int val2 = 0;
        int size = data.length;
        val2 = dis.readByte();
        for (int n = 1; n < size; ++n) {
            val2 = (val2 << 8) + dis.readUnsignedByte();
        }
        return val2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AsnInteger) {
            return this.value == ((AsnInteger)obj).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }
}

