/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.pdu;

import java.io.IOException;
import java.util.HashMap;
import java.util.Observer;
import uk.co.westhawk.snmp.stack.AsnInteger;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.GetNextPdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.varbind;

public class InterfaceGetNextPduStub
extends GetNextPdu {
    private static final String version_id = "@(#)$Id: InterfaceGetNextPduStub.java,v 3.4 2006/11/29 16:12:50 birgit Exp $ Copyright Westhawk Ltd";
    public static final String sysUpTime_OID = "1.3.6.1.2.1.1.3";
    public static final String ifNumber_OID = "1.3.6.1.2.1.2.1";
    public static final String ifIndex_OID = "1.3.6.1.2.1.2.2.1.1";
    public static final String ifDescr_OID = "1.3.6.1.2.1.2.2.1.2";
    public static final String ifSpeed_OID = "1.3.6.1.2.1.2.2.1.5";
    public static final String ifOperStatus_OID = "1.3.6.1.2.1.2.2.1.8";
    public static final String ifInOctets_OID = "1.3.6.1.2.1.2.2.1.10";
    public static final String ifOutOctets_OID = "1.3.6.1.2.1.2.2.1.16";
    public static final int NO_SCAL = 2;
    public static final int NO_COL = 6;
    public static final int NO_OID = 8;
    public static final String[] scal_oids = new String[]{"1.3.6.1.2.1.1.3", "1.3.6.1.2.1.2.1"};
    public static final String[] col_oids = new String[]{"1.3.6.1.2.1.2.2.1.1", "1.3.6.1.2.1.2.2.1.2", "1.3.6.1.2.1.2.2.1.5", "1.3.6.1.2.1.2.2.1.8", "1.3.6.1.2.1.2.2.1.10", "1.3.6.1.2.1.2.2.1.16"};
    public static final String[] all_oids = new String[]{"1.3.6.1.2.1.1.3", "1.3.6.1.2.1.2.1", "1.3.6.1.2.1.2.2.1.1", "1.3.6.1.2.1.2.2.1.2", "1.3.6.1.2.1.2.2.1.5", "1.3.6.1.2.1.2.2.1.8", "1.3.6.1.2.1.2.2.1.10", "1.3.6.1.2.1.2.2.1.16"};
    protected long _sysUpTime;
    protected int _ifNumber;
    protected int _ifIndex;
    protected String _ifDescr;
    protected long _ifSpeed;
    protected HashMap _ifOperStatusMap = new HashMap(3);
    protected int _ifOperStatus;
    protected long _ifInOctets;
    protected long _ifOutOctets;
    protected boolean _valid = false;

    public InterfaceGetNextPduStub(SnmpContextBasisFace con) {
        super(con);
        this._ifOperStatusMap.put(new Integer(3), "testing");
        this._ifOperStatusMap.put(new Integer(1), "up");
        this._ifOperStatusMap.put(new Integer(2), "down");
        this._valid = false;
    }

    public InterfaceGetNextPduStub(SnmpContextBasisFace con, Observer o) throws PduException, IOException {
        this(con);
        this.addOids(null);
        if (o != null) {
            this.addObserver(o);
        }
        this.send();
    }

    public void addOids(InterfaceGetNextPduStub old) {
        if (old != null) {
            int i;
            for (i = 0; i < 2; ++i) {
                this.addOid(scal_oids[i]);
            }
            for (i = 2; i < 8; ++i) {
                varbind var2 = (varbind)old.respVarbinds.elementAt(i);
                this.addOid(var2.getOid());
            }
        } else {
            for (int i = 0; i < 8; ++i) {
                this.addOid(all_oids[i]);
            }
        }
    }

    public void addOids(int index) {
        int i;
        for (i = 0; i < 2; ++i) {
            this.addOid(scal_oids[i]);
        }
        for (i = 0; i < 6; ++i) {
            this.addOid(col_oids[i] + "." + index);
        }
    }

    @Override
    protected void new_value(int n, varbind res) {
        if (this.getErrorStatus() == 0) {
            AsnObjectId oid = res.getOid();
            AsnObject value = res.getValue();
            if (res.getOid().toString().startsWith(all_oids[n])) {
                try {
                    switch (n) {
                        case 0: {
                            this.setSysUpTime(value);
                            break;
                        }
                        case 1: {
                            this.setIfNumber(value);
                            break;
                        }
                        case 2: {
                            this.setIfIndex(value);
                            break;
                        }
                        case 3: {
                            this.setIfDescr(value);
                            break;
                        }
                        case 4: {
                            this.setIfSpeed(value);
                            break;
                        }
                        case 5: {
                            this.setIfOperStatus(value);
                            break;
                        }
                        case 6: {
                            this.setIfInOctets(value);
                            break;
                        }
                        case 7: {
                            this.setIfOutOctets(value);
                            break;
                        }
                        default: {
                            this._valid = false;
                            break;
                        }
                    }
                }
                catch (ClassCastException exc) {
                    this._valid = false;
                }
                if (n == 7) {
                    this._valid = true;
                }
            } else {
                this.setErrorStatus(2);
                this.setErrorIndex(n);
            }
        }
    }

    public void setSysUpTime(AsnObject new_value) {
        AsnUnsInteger obj = (AsnUnsInteger)new_value;
        this._sysUpTime = obj.getValue();
    }

    public long getSysUpTime() {
        return this._sysUpTime;
    }

    public void setIfNumber(AsnObject new_value) {
        AsnInteger obj = (AsnInteger)new_value;
        this._ifNumber = obj.getValue();
    }

    public int getIfNumber() {
        return this._ifNumber;
    }

    public void setIfIndex(AsnObject new_value) {
        AsnInteger obj = (AsnInteger)new_value;
        this._ifIndex = obj.getValue();
    }

    public int getIfIndex() {
        return this._ifIndex;
    }

    public void setIfDescr(AsnObject new_value) {
        AsnOctets obj = (AsnOctets)new_value;
        this._ifDescr = obj.toDisplayString();
    }

    public String getIfDescr() {
        return this._ifDescr;
    }

    public void setIfSpeed(AsnObject new_value) {
        AsnUnsInteger obj = (AsnUnsInteger)new_value;
        this._ifSpeed = obj.getValue();
    }

    public long getIfSpeed() {
        return this._ifSpeed;
    }

    public void setIfOperStatus(AsnObject new_value) {
        AsnInteger obj = (AsnInteger)new_value;
        this._ifOperStatus = obj.getValue();
    }

    public String getIfOperStatusStr() {
        return (String)this._ifOperStatusMap.get(new Integer(this._ifOperStatus));
    }

    public int getIfOperStatus() {
        return this._ifOperStatus;
    }

    public void setIfInOctets(AsnObject new_value) {
        AsnUnsInteger obj = (AsnUnsInteger)new_value;
        this._ifInOctets = obj.getValue();
    }

    public long getIfInOctets() {
        return this._ifInOctets;
    }

    public void setIfOutOctets(AsnObject new_value) {
        AsnUnsInteger obj = (AsnUnsInteger)new_value;
        this._ifOutOctets = obj.getValue();
    }

    public long getIfOutOctets() {
        return this._ifOutOctets;
    }

    public boolean isValid() {
        return this._valid;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append("[");
        buffer.append("sysUpTime=").append(this._sysUpTime);
        buffer.append(", ifNumber=").append(this._ifNumber);
        buffer.append(", ifIndex=").append(this._ifIndex);
        buffer.append(", ifDescr=").append(this._ifDescr);
        buffer.append(", ifSpeed=").append(this._ifSpeed);
        buffer.append(", ifOperStatus=").append(this._ifOperStatusMap.get(new Integer(this._ifOperStatus)));
        buffer.append(", ifInOctets=").append(this._ifInOctets);
        buffer.append(", ifOutOctets=").append(this._ifOutOctets);
        buffer.append(", valid=").append(this._valid);
        buffer.append("]");
        return buffer.toString();
    }
}

