/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.pdu;

import java.io.IOException;
import java.util.Vector;
import uk.co.westhawk.snmp.pdu.GetNextPdu_vec;
import uk.co.westhawk.snmp.pdu.GetPdu_vec;
import uk.co.westhawk.snmp.pdu.SetPdu_vec;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnObjectId;
import uk.co.westhawk.snmp.stack.GetBulkPdu;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.varbind;

public class BlockPdu {
    private static final String version_id = "@(#)$Id: BlockPdu.java,v 3.13 2006/01/17 17:43:53 birgit Exp $ Copyright Westhawk Ltd";
    public static final int GET = 0;
    public static final int SET = 1;
    public static final int GETNEXT = 2;
    public static final int GETBULK = 3;
    protected Vector reqVarbinds;
    private SnmpContextBasisFace context;
    private Pdu pdu;
    private int type = 0;
    private int non_rep = 0;
    private int max_rep = 0;
    private int[] retry_intervals = null;

    public BlockPdu(SnmpContextBasisFace con) {
        this.context = con;
        this.reqVarbinds = new Vector(1, 1);
    }

    public void addOid(String oid) {
        varbind vb = new varbind(oid);
        this.addOid(vb);
    }

    public void addOid(String oid, AsnObject val2) {
        varbind vb = new varbind(oid, val2);
        this.addOid(vb);
    }

    public void addOid(AsnObjectId oid, AsnObject val2) {
        varbind vb = new varbind(oid, val2);
        this.addOid(vb);
    }

    public void addOid(AsnObjectId oid) {
        varbind vb = new varbind(oid);
        this.addOid(vb);
    }

    public void addOid(varbind var2) {
        this.reqVarbinds.addElement(var2);
    }

    public void setBulkParameters(int nr, int mr) {
        this.non_rep = nr;
        this.max_rep = mr;
    }

    public void addOid(String[] oids) {
        for (int i = 0; i < oids.length; ++i) {
            varbind vb = new varbind(oids[i]);
            this.reqVarbinds.addElement(vb);
        }
    }

    public void setPduType(int newType) {
        this.type = newType;
    }

    public void setRetryIntervals(int[] retryIntervals) {
        this.retry_intervals = retryIntervals;
    }

    public AsnObject getResponseVariable() throws PduException, IOException {
        AsnObject value = null;
        varbind[] vars = this.sendAndWait();
        if (vars != null && vars.length > 0) {
            value = vars[0].getValue();
        }
        return value;
    }

    public AsnObject[] getResponseVariables() throws PduException, IOException {
        AsnObject[] values = null;
        varbind[] vars = this.sendAndWait();
        if (vars != null) {
            values = new AsnObject[vars.length];
            for (int i = 0; i < vars.length; ++i) {
                values[i] = vars[i].getValue();
            }
        }
        return values;
    }

    public varbind getResponseVariableBinding() throws PduException, IOException {
        varbind var2 = null;
        varbind[] vars = this.sendAndWait();
        if (vars != null && vars.length > 0) {
            var2 = vars[0];
        }
        return var2;
    }

    public varbind[] getResponseVariableBindings() throws PduException, IOException {
        varbind[] vars = this.sendAndWait();
        return vars;
    }

    protected synchronized varbind[] sendAndWait() throws PduException, IOException {
        int sz = this.reqVarbinds.size();
        switch (this.type) {
            case 1: {
                this.pdu = new SetPdu_vec(this.context, sz);
                break;
            }
            case 2: {
                this.pdu = new GetNextPdu_vec(this.context, sz);
                break;
            }
            case 3: {
                this.pdu = new GetBulkPdu(this.context);
                ((GetBulkPdu)this.pdu).setNonRepeaters(this.non_rep);
                ((GetBulkPdu)this.pdu).setMaxRepetitions(this.max_rep);
                break;
            }
            default: {
                this.pdu = new GetPdu_vec(this.context, sz);
            }
        }
        for (int i = 0; i < sz; ++i) {
            varbind var2 = (varbind)this.reqVarbinds.elementAt(i);
            this.pdu.addOid(var2);
        }
        if (this.retry_intervals != null) {
            this.pdu.setRetryIntervals(this.retry_intervals);
        }
        this.pdu.send();
        this.pdu.waitForSelf();
        varbind[] vars = this.pdu.getResponseVarbinds();
        return vars;
    }

    public int getErrorIndex() {
        return this.pdu.getErrorIndex();
    }

    public int getErrorStatus() {
        return this.pdu.getErrorStatus();
    }

    public String getErrorStatusString() {
        return this.pdu.getErrorStatusString();
    }
}

