/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import uk.co.westhawk.snmp.beans.SNMPRunBean;
import uk.co.westhawk.snmp.stack.AsnOctets;
import uk.co.westhawk.snmp.stack.GetNextPdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.varbind;

public class NTSharedResBean
extends SNMPRunBean
implements Observer {
    private static final String version_id = "@(#)$Id: NTSharedResBean.java,v 1.13 2006/01/25 18:08:56 birgit Exp $ Copyright Westhawk Ltd";
    public static final String svShareName = "1.3.6.1.4.1.77.1.2.27.1.1";
    private int svShareName_len;
    private GetNextPdu pdu;
    private Hashtable resourceHash = new Hashtable();
    private boolean isGetNextInFlight;
    private Date lastUpdateDate = null;

    public NTSharedResBean() {
        this.svShareName_len = svShareName.length();
    }

    public NTSharedResBean(String h, int p) {
        this(h, p, null);
    }

    public NTSharedResBean(String h, int p, String b) {
        this();
        this.setHost(h);
        this.setPort(p);
        this.setBindAddress(b);
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public Enumeration getIndices() {
        return this.resourceHash.elements();
    }

    public String getIndex(String name) {
        String ret = null;
        if (name != null) {
            ret = (String)this.resourceHash.get(name);
        }
        return ret;
    }

    public Enumeration getNames() {
        return this.resourceHash.keys();
    }

    public synchronized int getCount() {
        return this.resourceHash.size();
    }

    @Override
    public void action() {
        if (this.isHostPortReachable()) {
            this.resourceHash.clear();
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.setRunning(true);
        }
    }

    @Override
    public void run() {
        while (this.context != null && this.isRunning()) {
            if (!this.isGetNextInFlight) {
                this.isGetNextInFlight = true;
                this.pdu = new GetNextPdu(this.context);
                this.pdu.addObserver(this);
                this.pdu.addOid(svShareName);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public void update(Observable obs, Object ov) {
        this.pdu = (GetNextPdu)obs;
        if (this.pdu.getErrorStatus() == 0) {
            varbind var2 = (varbind)ov;
            String oid = var2.getOid().toString();
            if (oid.startsWith(svShareName)) {
                String index = oid.substring(this.svShareName_len + 1);
                String name = ((AsnOctets)var2.getValue()).getValue();
                this.resourceHash.put(name, index);
                this.pdu = new GetNextPdu(this.context);
                this.pdu.addObserver(this);
                this.pdu.addOid(oid);
                try {
                    this.pdu.send();
                }
                catch (PduException exc) {
                    System.out.println("PduException " + exc.getMessage());
                }
                catch (IOException exc) {
                    System.out.println("IOException " + exc.getMessage());
                }
            } else {
                this.lastUpdateDate = new Date();
                this.isGetNextInFlight = false;
                this.firePropertyChange("resourceNames", null, null);
            }
        } else {
            this.lastUpdateDate = new Date();
            this.isGetNextInFlight = false;
            this.firePropertyChange("resourceNames", null, null);
        }
    }
}

