/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.xflat.handlers;

import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.sentrysoftware.xflat.Utils;
import org.sentrysoftware.xflat.exceptions.XFlatException;
import org.sentrysoftware.xflat.types.SearchPathElement;
import org.sentrysoftware.xflat.types.SearchPathElementAttribute;
import org.sentrysoftware.xflat.types.SearchPathElementProperty;
import org.sentrysoftware.xflat.types.SearchPathNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlHandler {
    private static final DocumentBuilderFactory DOCUMENT_FACTORY = DocumentBuilderFactory.newInstance((String)"com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", (ClassLoader)ClassLoader.getSystemClassLoader());
    private final Set<String> linkKeys = new HashSet<String>();
    private final Map<String, Map<Integer, String>> resultMap = new LinkedHashMap<String, Map<Integer, String>>();

    private XmlHandler() {
    }

    public static Map<String, Map<Integer, String>> parse(String xml, SearchPathNode searchPathNode) throws XFlatException {
        Utils.checkNonNull(xml, "xml");
        Utils.checkNonNull(searchPathNode, "searchPathNode");
        StringReader stringReader = new StringReader(xml);
        try {
            Document document = DOCUMENT_FACTORY.newDocumentBuilder().parse(new InputSource(stringReader));
            XmlHandler xmlHandler = XmlHandler.createXmlHandlerInstance();
            xmlHandler.initNavigation(searchPathNode, document);
            Map<String, Map<Integer, String>> map = xmlHandler.getResultMap();
            stringReader.close();
            return map;
        }
        catch (Throwable throwable) {
            try {
                try {
                    stringReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new XFlatException("Error in parsing xml.", e);
            }
        }
    }

    void initNavigation(SearchPathNode searchPathNode, Node node) {
        HashMap<Integer, String> dataValues = new HashMap<Integer, String>();
        String linkKey = this.generateUniqueLinkKey();
        SearchPathElement pathElement = searchPathNode.getElement();
        NodeList nodeList = node instanceof Document ? ((Document)node).getElementsByTagName(pathElement.getName()) : ((Element)node).getElementsByTagName(pathElement.getName());
        int totalNodes = nodeList.getLength();
        if (totalNodes == 0) {
            this.endNavigate(pathElement, linkKey, dataValues);
        } else if (totalNodes == 1) {
            this.navigateNext(searchPathNode, nodeList.item(0), linkKey, dataValues);
        } else {
            for (int nodeIndex = 0; nodeIndex < totalNodes; ++nodeIndex) {
                String nextLinkKey = this.generateNextLinkKey(linkKey);
                this.navigateNext(searchPathNode, nodeList.item(nodeIndex), nextLinkKey, new HashMap<Integer, String>(dataValues));
            }
        }
    }

    String generateNextLinkKey(String linkKey) {
        return linkKey + "=>" + this.generateUniqueLinkKey();
    }

    void navigateNext(SearchPathNode searchPathNode, Node node, String linkKey, Map<Integer, String> dataValues) {
        if (searchPathNode.getNexts().isEmpty()) {
            this.endNavigate(linkKey, dataValues);
            return;
        }
        for (SearchPathNode next : searchPathNode.getNexts()) {
            SearchPathElement pathElement = next.getElement();
            if (pathElement instanceof SearchPathElementAttribute) {
                Element element = (Element)node;
                Attr attr = (Attr)element.getAttributes().getNamedItem(pathElement.getName());
                String value = attr != null ? attr.getValue() : null;
                SearchPathElementAttribute searchPathElementAttribute = (SearchPathElementAttribute)pathElement;
                dataValues.put(searchPathElementAttribute.getId(), value);
                this.navigateNext(next, element, linkKey, dataValues);
                continue;
            }
            NodeList children = node.getChildNodes();
            List elements = IntStream.range(0, children.getLength()).mapToObj(children::item).filter(child -> pathElement.getName().equals(child.getNodeName())).map(Element.class::cast).collect(Collectors.toList());
            if (elements.isEmpty()) {
                this.endNavigate(pathElement, linkKey, dataValues);
                continue;
            }
            if (elements.size() == 1) {
                this.navigateElement(next, (Element)elements.get(0), linkKey, dataValues);
                continue;
            }
            for (Element element : elements) {
                String nextLinkKey = this.generateNextLinkKey(linkKey);
                this.navigateElement(next, element, nextLinkKey, new HashMap<Integer, String>(dataValues));
            }
        }
    }

    void navigateElement(SearchPathNode searchPathNode, Element element, String linkKey, Map<Integer, String> dataValues) {
        if (searchPathNode.getElement() instanceof SearchPathElementProperty) {
            SearchPathElementProperty searchPathElementProperty = (SearchPathElementProperty)searchPathNode.getElement();
            dataValues.put(searchPathElementProperty.getId(), element.getTextContent());
        }
        this.navigateNext(searchPathNode, element, linkKey, dataValues);
    }

    void endNavigate(SearchPathElement searchPathElement, String linkKey, Map<Integer, String> dataValues) {
        if (searchPathElement.isFromRootTag()) {
            dataValues.put(-1, "");
        }
        this.endNavigate(linkKey, dataValues);
    }

    void endNavigate(String linkKey, Map<Integer, String> dataValues) {
        this.getResultMap().compute(linkKey, (key, value) -> value == null ? dataValues : Stream.concat(value.entrySet().stream(), dataValues.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldValue, newValue) -> oldValue)));
    }

    String generateUniqueLinkKey() {
        String linkKey = Integer.toHexString(Objects.hash(Math.random()));
        if (this.linkKeys.contains(linkKey)) {
            return this.generateUniqueLinkKey();
        }
        this.linkKeys.add(linkKey);
        return linkKey;
    }

    static XmlHandler createXmlHandlerInstance() {
        return new XmlHandler();
    }

    public Map<String, Map<Integer, String>> getResultMap() {
        return this.resultMap;
    }

    static {
        DOCUMENT_FACTORY.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        DOCUMENT_FACTORY.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
    }
}

