/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi.windows.remote.share;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.sentrysoftware.wmi.TimeoutHelper;
import org.sentrysoftware.wmi.Utils;
import org.sentrysoftware.wmi.exceptions.WindowsRemoteException;
import org.sentrysoftware.wmi.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.wmi.windows.remote.WindowsRemoteExecutor;
import org.sentrysoftware.wmi.windows.remote.share.ShareRemoteDirectoryConsumer;

public class WindowsTempShare {
    private final String shareName;
    private final String uncSharePath;
    private final String remotePath;
    private final WindowsRemoteExecutor windowsRemoteExecutor;

    public WindowsTempShare(WindowsRemoteExecutor windowsRemoteExecutor, String shareNameOrUnc, String remotePath) {
        Utils.checkNonNull(windowsRemoteExecutor, "windowsRemoteExecutor");
        Utils.checkNonNull(shareNameOrUnc, "shareNameOrUnc");
        if (shareNameOrUnc.startsWith("\\\\")) {
            this.uncSharePath = shareNameOrUnc;
            String[] uncElements = shareNameOrUnc.split("\\\\");
            this.shareName = uncElements[3];
        } else {
            this.uncSharePath = WindowsTempShare.buildUncPath(windowsRemoteExecutor.getHostname(), shareNameOrUnc);
            this.shareName = shareNameOrUnc;
        }
        this.remotePath = remotePath;
        this.windowsRemoteExecutor = windowsRemoteExecutor;
    }

    public static WindowsTempShare getOrCreateShare(WindowsRemoteExecutor windowsRemoteExecutor, long timeout, ShareRemoteDirectoryConsumer<WindowsRemoteExecutor, String, String, Long> shareRemoteDirectory) throws TimeoutException, WindowsRemoteException {
        Utils.checkNonNull(windowsRemoteExecutor, "windowsRemoteExecutor");
        Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
        Utils.checkNonNull(shareRemoteDirectory, "shareRemoteDirectory");
        long start = Utils.getCurrentTimeMillis();
        Optional<WindowsTempShare> clusterShare = WindowsTempShare.getClusterShare(windowsRemoteExecutor, TimeoutHelper.getRemainingTime(timeout, start, "No time left to check for cluster share"));
        if (clusterShare.isPresent()) {
            return clusterShare.get();
        }
        String shareName = WindowsTempShare.buildShareName();
        Optional<WindowsTempShare> share = WindowsTempShare.getShare(windowsRemoteExecutor, shareName, TimeoutHelper.getRemainingTime(timeout, start, "No time left to get a normal temporary share"));
        if (share.isPresent()) {
            return share.get();
        }
        return WindowsTempShare.createTempShare(windowsRemoteExecutor, shareName, TimeoutHelper.getRemainingTime(timeout, start, "No time left to create the temporary share"), shareRemoteDirectory);
    }

    public static String getWindowsDirectory(WindowsRemoteExecutor windowsRemoteExecutor, long timeout) throws WindowsRemoteException, TimeoutException {
        Utils.checkNonNull(windowsRemoteExecutor, "windowsRemoteExecutor");
        Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
        try {
            return windowsRemoteExecutor.executeWql("SELECT WindowsDirectory FROM Win32_OperatingSystem", timeout).stream().limit(1L).map(row -> (String)row.get("WindowsDirectory")).filter(Objects::nonNull).findFirst().orElseThrow(() -> new WindowsRemoteException(String.format("Couldn't identify the Windows root directory on %s.", windowsRemoteExecutor.getHostname())));
        }
        catch (WqlQuerySyntaxException e) {
            throw new WindowsRemoteException(e);
        }
    }

    public static void createRemoteDirectory(WindowsRemoteExecutor windowsRemoteExecutor, String remotePath, long timeout) throws WindowsRemoteException, TimeoutException {
        Utils.checkNonNull(windowsRemoteExecutor, "windowsRemoteExecutor");
        windowsRemoteExecutor.executeCommand(WindowsTempShare.buildCreateRemoteDirectoryCommand(remotePath), null, null, timeout);
    }

    static String buildUncPath(String hostname, String share) {
        Utils.checkNonNull(hostname, "hostname");
        return hostname.contains(":") ? String.format("\\\\%s.ipv6-literal.net\\%s", hostname.replace(":", "-").replace("%", "s"), share) : String.format("\\\\%s\\%s", hostname, share);
    }

    static String buildCreateRemoteDirectoryCommand(String remotePath) {
        Utils.checkNonBlank(remotePath, "remotePath");
        return String.format("CMD.EXE /C IF NOT EXIST \"%s\" MKDIR %s", remotePath, remotePath);
    }

    static String buildPathOnCluster(String path) {
        Utils.checkNonNull(path, "path");
        return String.format("%s\\Temp\\SEN_TempFor_%s", path, Utils.getComputerName());
    }

    static String buildRemotePath(String folder, String shareName) {
        Utils.checkNonNull(folder, "folder");
        Utils.checkNonBlank(shareName, "shareName");
        return String.format("%s\\Temp\\%s", folder, shareName);
    }

    static String buildShareName() {
        return String.format("SEN_ShareFor_%s$", Utils.getComputerName());
    }

    static Optional<WindowsTempShare> getClusterShare(WindowsRemoteExecutor windowsRemoteExecutor, long timeout) throws TimeoutException, WindowsRemoteException {
        try {
            Optional<WindowsTempShare> clusterShare = windowsRemoteExecutor.executeWql("SELECT Name,Path FROM Win32_ClusterShare WHERE ServerName <> '*' AND (Type = 2147483648 OR Type = 3221225472) AND Name LIKE '%\\\\_$'", timeout).stream().limit(1L).map(row -> new WindowsTempShare(windowsRemoteExecutor, WindowsTempShare.buildPathOnCluster((String)row.get("Name")), WindowsTempShare.buildPathOnCluster((String)row.get("Path")))).findFirst();
            if (clusterShare.isPresent()) {
                WindowsTempShare.createRemoteDirectory(windowsRemoteExecutor, clusterShare.get().getRemotePath(), timeout);
            }
            return clusterShare;
        }
        catch (WqlQuerySyntaxException e) {
            throw new WindowsRemoteException(e);
        }
    }

    static Optional<WindowsTempShare> getShare(WindowsRemoteExecutor windowsRemoteExecutor, String shareName, long timeout) throws TimeoutException, WindowsRemoteException {
        try {
            return windowsRemoteExecutor.executeWql(String.format("SELECT Name,Path FROM Win32_Share WHERE Name = '%s'", shareName), timeout).stream().limit(1L).map(row -> new WindowsTempShare(windowsRemoteExecutor, (String)row.get("Name"), (String)row.get("Path"))).findFirst();
        }
        catch (WqlQuerySyntaxException e) {
            throw new WindowsRemoteException(e);
        }
    }

    static WindowsTempShare createTempShare(WindowsRemoteExecutor windowsRemoteExecutor, String shareName, long timeout, ShareRemoteDirectoryConsumer<WindowsRemoteExecutor, String, String, Long> shareRemoteDirectory) throws WindowsRemoteException, TimeoutException {
        long start = Utils.getCurrentTimeMillis();
        String folder = WindowsTempShare.getWindowsDirectory(windowsRemoteExecutor, timeout);
        String remotePath = WindowsTempShare.buildRemotePath(folder, shareName);
        WindowsTempShare.createRemoteDirectory(windowsRemoteExecutor, remotePath, TimeoutHelper.getRemainingTime(timeout, start, "No time left to create the temporary directory"));
        shareRemoteDirectory.apply(windowsRemoteExecutor, remotePath, shareName, timeout);
        return new WindowsTempShare(windowsRemoteExecutor, shareName, remotePath);
    }

    public String getShareName() {
        return this.shareName;
    }

    public String getUncSharePath() {
        return this.uncSharePath;
    }

    public String getRemotePath() {
        return this.remotePath;
    }

    public WindowsRemoteExecutor getWindowsRemoteExecutor() {
        return this.windowsRemoteExecutor;
    }
}

