/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi.windows.remote;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sentrysoftware.wmi.Utils;
import org.sentrysoftware.wmi.exceptions.WindowsRemoteException;
import org.sentrysoftware.wmi.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.wmi.windows.remote.WindowsRemoteExecutor;

public class WindowsRemoteProcessUtils {
    private static final String DEFAULT_CODESET = "1252";
    private static final Charset DEFAULT_CHARSET = Charset.forName("windows-1252");
    private static final Map<String, Charset> CODESET_MAP;

    private WindowsRemoteProcessUtils() {
    }

    public static Charset getWindowsEncodingCharset(WindowsRemoteExecutor windowsRemoteExecutor, long timeout) throws TimeoutException, WqlQuerySyntaxException, WindowsRemoteException {
        if (windowsRemoteExecutor == null || timeout < 1L) {
            return DEFAULT_CHARSET;
        }
        List<Map<String, Object>> result = windowsRemoteExecutor.executeWql("SELECT CodeSet FROM Win32_OperatingSystem", timeout);
        String codeSet = result.stream().map(row -> (String)row.get("CodeSet")).filter(Objects::nonNull).findFirst().orElse(DEFAULT_CODESET);
        return CODESET_MAP.getOrDefault(codeSet, DEFAULT_CHARSET);
    }

    public static String buildNewOutputFileName() {
        return String.format("SEN_%s_%d_%d", Utils.getComputerName(), Utils.getCurrentTimeMillis(), (long)(Math.random() * 1000000.0));
    }

    public static String copyLocalFilesToShare(String command, List<String> localFiles, String uncSharePath, String remotePath) throws IOException {
        Utils.checkNonNull(command, "command");
        if (localFiles == null || localFiles.isEmpty()) {
            return command;
        }
        Utils.checkNonNull(uncSharePath, "uncSharePath");
        Utils.checkNonNull(remotePath, "remotePath");
        try {
            return localFiles.stream().reduce(command, (cmd, localFile) -> {
                try {
                    Path localFilePath = Paths.get(localFile, new String[0]);
                    Path remoteFilePath = WindowsRemoteProcessUtils.copyToShare(localFilePath, uncSharePath, remotePath);
                    return WindowsRemoteProcessUtils.caseInsensitiveReplace(cmd, localFile, remoteFilePath.toString());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    static Path copyToShare(Path localFilePath, String uncSharePath, String remotePath) throws IOException {
        FileTime targetFileTime;
        FileTime sourceFileTime;
        Path targetUncPath = Paths.get(uncSharePath, localFilePath.getFileName().toString());
        Path targetRemotePath = Paths.get(remotePath, localFilePath.getFileName().toString());
        if (Files.exists(targetUncPath, new LinkOption[0]) && (sourceFileTime = Files.getLastModifiedTime(localFilePath, new LinkOption[0])).compareTo(targetFileTime = Files.getLastModifiedTime(targetUncPath, new LinkOption[0])) <= 0) {
            return targetRemotePath;
        }
        Files.copy(localFilePath, targetUncPath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        return targetRemotePath;
    }

    static String caseInsensitiveReplace(String string, String target, String replacement) {
        return string == null || target == null ? string : Pattern.compile(target, 18).matcher(string).replaceAll(Matcher.quoteReplacement(replacement == null ? "" : replacement));
    }

    static {
        HashMap<String, Charset> map = new HashMap<String, Charset>();
        map.put("1250", Charset.forName("windows-1250"));
        map.put("1251", Charset.forName("windows-1251"));
        map.put(DEFAULT_CODESET, DEFAULT_CHARSET);
        map.put("1253", Charset.forName("windows-1253"));
        map.put("1254", Charset.forName("windows-1254"));
        map.put("1255", Charset.forName("windows-1255"));
        map.put("1256", Charset.forName("windows-1256"));
        map.put("1257", Charset.forName("windows-1257"));
        map.put("1258", Charset.forName("windows-1258"));
        map.put("874", Charset.forName("x-windows-874"));
        map.put("932", Charset.forName("Shift_JIS"));
        map.put("936", Charset.forName("GBK"));
        map.put("949", Charset.forName("EUC-KR"));
        map.put("950", Charset.forName("Big5"));
        map.put("951", Charset.forName("Big5-HKSCS"));
        map.put("28591", StandardCharsets.ISO_8859_1);
        map.put("20127", StandardCharsets.US_ASCII);
        map.put("65001", StandardCharsets.UTF_8);
        map.put("1200", StandardCharsets.UTF_16LE);
        map.put("1201", StandardCharsets.UTF_16BE);
        CODESET_MAP = Collections.unmodifiableMap(map);
    }
}

