/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wmi.remotecommand;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.sentrysoftware.wmi.TimeoutHelper;
import org.sentrysoftware.wmi.Utils;
import org.sentrysoftware.wmi.WmiHelper;
import org.sentrysoftware.wmi.exceptions.ProcessNotFoundException;
import org.sentrysoftware.wmi.exceptions.WmiComException;
import org.sentrysoftware.wmi.exceptions.WqlQuerySyntaxException;
import org.sentrysoftware.wmi.wbem.WmiWbemServices;

public class RemoteProcess {
    private static final String TERMINATE = "Terminate";
    private static final String CREATE = "Create";
    private static final String CIMV2_NAMESPACE = "ROOT\\CIMV2";
    private static final String WIN32_PROCESS = "Win32_Process";
    private static final Map<Integer, String> METHOD_RETURNVALUE_MAP;

    private RemoteProcess() {
    }

    public static int executeCommand(String command, String hostname, String username, char[] password, String workingDirectory, long timeout) throws WmiComException, TimeoutException {
        Utils.checkNonNull(command, "command");
        Utils.checkArgumentNotZeroOrNegative(timeout, "timeout");
        long start = Utils.getCurrentTimeMillis();
        String networkResource = WmiHelper.createNetworkResource(hostname, CIMV2_NAMESPACE);
        try (WmiWbemServices wmiWbemServices = WmiWbemServices.getInstance(networkResource, username, password);){
            Map<String, Object> createResult;
            Integer processId;
            HashMap<String, Object> createInputs = new HashMap<String, Object>();
            createInputs.put("CommandLine", command);
            if (!Utils.isBlank(workingDirectory)) {
                createInputs.put("CurrentDirectory", workingDirectory.trim());
            }
            if ((processId = (Integer)(createResult = wmiWbemServices.executeMethod(WIN32_PROCESS, WIN32_PROCESS, CREATE, createInputs)).get("ProcessId")) == null || processId < 1) {
                throw new WmiComException("Could not spawn the process: No ProcessId was returned by Win32_Process::Create");
            }
            try {
                while (RemoteProcess.existProcess(wmiWbemServices, processId, TimeoutHelper.getRemainingTime(timeout, start, "No time left to check if the process exists"))) {
                    TimeoutHelper.stagedSleep(timeout, start, String.format("Command %s execution has timed out", command));
                }
            }
            catch (TimeoutException e) {
                RemoteProcess.killProcessWithChildren(wmiWbemServices, processId, 10000L);
                throw e;
            }
            int n = (Integer)createResult.get("ReturnValue");
            return n;
        }
    }

    static boolean existProcess(WmiWbemServices wbemServices, int pid, long timeout) throws WmiComException, TimeoutException {
        try {
            return !wbemServices.executeWql(String.format("SELECT Handle FROM Win32_Process WHERE Handle = '%d'", pid), timeout).isEmpty();
        }
        catch (WqlQuerySyntaxException e) {
            throw new WmiComException(e);
        }
    }

    private static void killProcessWithChildren(WmiWbemServices wmiWbemServices, int pid, long timeout) throws WmiComException, TimeoutException {
        try {
            long start = Utils.getCurrentTimeMillis();
            ArrayList<Integer> pidToKillList = new ArrayList<Integer>();
            pidToKillList.add(pid);
            pidToKillList.addAll(wmiWbemServices.executeWql(String.format("SELECT Handle FROM Win32_Process WHERE ParentProcessId = '%d'", pid), timeout).stream().map(row -> (String)row.get("Handle")).filter(Objects::nonNull).map(Integer::parseInt).collect(Collectors.toList()));
            Iterator iterator = pidToKillList.iterator();
            while (iterator.hasNext()) {
                int pidToKill = (Integer)iterator.next();
                if (TimeoutHelper.getRemainingTime(timeout, start, "No time left to kill the process") < 0L) {
                    throw new TimeoutException("Timeout while killing remaining processes");
                }
                try {
                    RemoteProcess.killProcess(wmiWbemServices, pidToKill);
                }
                catch (ProcessNotFoundException processNotFoundException) {}
            }
        }
        catch (WqlQuerySyntaxException e) {
            throw new WmiComException(e);
        }
    }

    private static void killProcess(WmiWbemServices wmiWbemServices, int pid) throws WmiComException, ProcessNotFoundException {
        Map<String, Object> terminateResult;
        Map<String, Object> inputs = Collections.singletonMap("Reason", 1);
        try {
            terminateResult = wmiWbemServices.executeMethod(String.format("Win32_Process.Handle='%d'", pid), WIN32_PROCESS, TERMINATE, inputs);
        }
        catch (WmiComException e) {
            if (e.getMessage().contains("WBEM_E_NOT_FOUND")) {
                throw new ProcessNotFoundException(pid);
            }
            throw e;
        }
        Integer returnCode = (Integer)terminateResult.get("ReturnValue");
        if (returnCode == null || returnCode != 0) {
            throw new WmiComException("Could not terminate the process (%d): %s", pid, RemoteProcess.getReturnErrorMessage(returnCode));
        }
    }

    private static String getReturnErrorMessage(int returnCode) {
        return METHOD_RETURNVALUE_MAP.getOrDefault(returnCode, String.format("Unknown return code (%d)", returnCode));
    }

    static {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        map.put(2, "Access denied");
        map.put(3, "Insufficient privilege");
        map.put(8, "Unknown failure");
        map.put(9, "Path not found");
        map.put(21, "Invalid parameter");
        METHOD_RETURNVALUE_MAP = Collections.unmodifiableMap(map);
    }
}

