/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.encryption;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Message;
import org.apache.http.auth.Credentials;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTCredentialsWithEncryption;
import org.sentrysoftware.winrm.service.client.encryption.AsyncHttpEncryptionAwareConduit;
import org.sentrysoftware.winrm.service.client.encryption.ContentWithType;
import org.sentrysoftware.winrm.service.client.encryption.NtlmEncryptionUtils;
import org.sentrysoftware.winrm.service.client.encryption.NullOutputStream;

class EncryptAndSignOutputStream
extends CachedOutputStream {
    private final CachedOutputStream unencrypted;
    private ContentWithType unencryptedResult = null;
    private ContentWithType encrypted = null;
    private final Message message;
    private OutputStream wrapped;
    private NTCredentialsWithEncryption credentials;

    public EncryptAndSignOutputStream(Message message, OutputStream outputStream) {
        this.message = message;
        this.wrapped = outputStream;
        this.unencrypted = new CachedOutputStream();
        Object creds = message.get(Credentials.class.getName());
        if (creds instanceof NTCredentialsWithEncryption) {
            this.credentials = (NTCredentialsWithEncryption)creds;
        }
    }

    @Override
    public void resetOut(OutputStream outputStream, boolean copyOldContent) throws IOException {
        super.resetOut(outputStream, copyOldContent);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.unencrypted.write(this.getBytes());
        this.currentStream = NullOutputStream.NULL_OUTPUT_STREAM;
        if (this.wrapped != null) {
            this.processAndShip(this.wrapped);
            this.wrapped.close();
        }
    }

    private synchronized ContentWithType getEncrypted() {
        try {
            if (this.encrypted == null) {
                byte[] bytesEncryptedAndSigned = NtlmEncryptionUtils.of(this.credentials).encryptAndSign(this.message, this.unencrypted.getBytes());
                this.encrypted = ContentWithType.of(this.message, bytesEncryptedAndSigned);
            }
            return this.encrypted;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private byte[] getUnencrypted() {
        try {
            return this.unencrypted.getBytes();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    synchronized ContentWithType getAppropriate() {
        if (this.unencryptedResult == null) {
            this.unencryptedResult = ContentWithType.of(this.message, null);
        }
        if (this.credentials == null || !this.credentials.isAuthenticated()) {
            if (this.encrypted != null) {
                this.encrypted = null;
            }
            return this.credentials != null && !this.credentials.isAuthenticated() ? this.unencryptedResult.with(AsyncHttpEncryptionAwareConduit.PRE_AUTH_BOGUS_PAYLOAD) : this.unencryptedResult.with(this.getUnencrypted());
        }
        return this.getEncrypted();
    }

    private void processAndShip(OutputStream output) throws IOException {
        output.write(this.getAppropriate().getPayload());
        output.close();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.credentials, this.encrypted, this.message, this.unencrypted, this.unencryptedResult, this.wrapped);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof EncryptAndSignOutputStream)) {
            return false;
        }
        EncryptAndSignOutputStream other = (EncryptAndSignOutputStream)obj;
        return Objects.equals(this.credentials, other.credentials) && Objects.equals(this.encrypted, other.encrypted) && Objects.equals(this.message, other.message) && Objects.equals(this.unencrypted, other.unencrypted) && Objects.equals(this.unencryptedResult, other.unencryptedResult) && Objects.equals(this.wrapped, other.wrapped);
    }
}

