/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client.auth.ntlm;

import org.apache.http.impl.auth.NTLMEngineException;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTLMEngine;
import org.sentrysoftware.winrm.service.client.auth.ntlm.Type1Message;
import org.sentrysoftware.winrm.service.client.auth.ntlm.Type2Message;
import org.sentrysoftware.winrm.service.client.auth.ntlm.Type3Message;

class NTLMEngineImpl
implements NTLMEngine {
    NTLMEngineImpl() {
    }

    private static String stripDotSuffix(String value) {
        if (value == null) {
            return null;
        }
        int index = value.indexOf(46);
        if (index != -1) {
            return value.substring(0, index);
        }
        return value;
    }

    static String convertHost(String host) {
        return NTLMEngineImpl.stripDotSuffix(host);
    }

    static String convertDomain(String domain) {
        return NTLMEngineImpl.stripDotSuffix(domain);
    }

    @Override
    public String generateType1Msg(String domain, String workstation) throws NTLMEngineException {
        return new Type1Message(null, null, this.getDefaultFlags()).getResponse();
    }

    Integer getDefaultFlags() {
        return Type1Message.getDefaultFlags();
    }

    @Override
    public String generateType3Msg(String username, String password, String domain, String workstation, String challenge) throws NTLMEngineException {
        return this.generateType3MsgObject(username, password, domain, workstation, challenge).getResponse();
    }

    @Override
    public Type3Message generateType3MsgObject(String username, String password, String domain, String workstation, String challenge) throws NTLMEngineException {
        Type2Message t2m = new Type2Message(challenge);
        return new Type3Message(domain, workstation, username, password, t2m.getChallenge(), t2m.getFlags(), t2m.getTarget(), t2m.getTargetInfo());
    }
}

