/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm.service.client;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.TrustManager;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.cxf.Bus;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.transport.http.HTTPConduitFactory;
import org.apache.cxf.transport.http.asyncclient.AsyncHTTPConduit;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.ws.addressing.WSAddressingFeature;
import org.apache.cxf.ws.addressing.policy.MetadataConstants;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.builders.PrimitiveAssertion;
import org.sentrysoftware.winrm.Utils;
import org.sentrysoftware.winrm.WinRMHttpProtocolEnum;
import org.sentrysoftware.winrm.service.WinRMEndpoint;
import org.sentrysoftware.winrm.service.WinRMWebService;
import org.sentrysoftware.winrm.service.WinRMWebServiceClient;
import org.sentrysoftware.winrm.service.client.StripShellResponseHandler;
import org.sentrysoftware.winrm.service.client.WSManHeaderInterceptor;
import org.sentrysoftware.winrm.service.client.auth.AuthenticationEnum;
import org.sentrysoftware.winrm.service.client.auth.TrustAllX509Manager;
import org.sentrysoftware.winrm.service.client.auth.kerberos.KerberosUtils;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NTCredentialsWithEncryption;
import org.sentrysoftware.winrm.service.client.auth.ntlm.NtlmMasqAsSpnegoSchemeFactory;
import org.sentrysoftware.winrm.service.client.encryption.AsyncHttpEncryptionAwareConduitFactory;
import org.sentrysoftware.winrm.service.client.encryption.DecryptAndVerifyInInterceptor;
import org.sentrysoftware.winrm.service.client.encryption.SignAndEncryptOutInterceptor;

public class WinRMInvocationHandler
implements InvocationHandler {
    public static final String WSMAN_SCHEMA_NAMESPACE = "http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd";
    private static final long PAUSE_TIME_MILLISECONDS = 500L;
    private static final int MAX_RETRY = 3;
    private static final URL WSDL_LOCATION_URL = WinRMWebServiceClient.class.getClassLoader().getResource("wsdl/WinRM.wsdl");
    private static final QName SERVICE = new QName("http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd", "WinRMWebServiceClient");
    private static final QName PORT = new QName("http://schemas.dmtf.org/wbem/wsman/1/wsman.xsd", "WinRMPort");
    private static final List<String> CONTENT_TYPE_LIST = Collections.singletonList("application/soap+xml;charset=UTF-8");
    private static final List<Handler> HANDLER_CHAIN = Arrays.asList(new StripShellResponseHandler());
    private static final Registry<AuthSchemeProvider> AUTH_SCHEME_REGISTRY = RegistryBuilder.create().register("Negotiate", new NtlmMasqAsSpnegoSchemeFactory()).register("Kerberos", (NtlmMasqAsSpnegoSchemeFactory)((Object)new KerberosSchemeFactory(true))).build();
    private static final Policy POLICY = new Policy();
    private static final WSAddressingFeature WS_ADDRESSING_FEATURE;
    private static final TLSClientParameters TLS_CLIENT_PARAMETERS;
    private static final Map<CredentialsMapKey, Credentials> CREDENTIALS;
    private final WinRMWebService winRMWebService;
    private final WinRMEndpoint winRMEndpoint;
    private final long timeout;
    private final String resourceUri;
    private final Path ticketCache;
    private final Queue<AuthenticationEnum> authenticationsQueue;
    private AuthenticationEnum authentication;
    private Client wsClient;

    public WinRMInvocationHandler(WinRMEndpoint winRMEndpoint, Bus bus, long timeout, String resourceUri, Path ticketCache, List<AuthenticationEnum> authentications) {
        Utils.checkNonNull(winRMEndpoint, "winRMEndpoint");
        Utils.checkNonNull(bus, "bus");
        Utils.checkNonNull(authentications, "authentications");
        this.winRMEndpoint = winRMEndpoint;
        this.timeout = timeout;
        this.resourceUri = resourceUri;
        this.ticketCache = ticketCache;
        this.authenticationsQueue = authentications.stream().collect(Collectors.toCollection(LinkedList::new));
        this.winRMWebService = WinRMInvocationHandler.createWinRMWebService(winRMEndpoint, bus);
        AuthCredentials authCredentials = WinRMInvocationHandler.computeCredentials(winRMEndpoint, ticketCache, this.authenticationsQueue);
        this.authentication = authCredentials.getAuthentication();
        this.wsClient = WinRMInvocationHandler.getWebServiceClient(winRMEndpoint, timeout, resourceUri, this.winRMWebService, authCredentials.getCredentials());
    }

    public Client getClient() {
        return this.wsClient;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Utils.checkNonNull(method, "method");
        try {
            return this.invokeMethod(method, args);
        }
        catch (RetryTgtExpirationException e) {
            Credentials credentials;
            block8: {
                this.authentication = null;
                try {
                    credentials = KerberosUtils.createCredentials(this.winRMEndpoint.getUsername(), this.winRMEndpoint.getPassword(), this.ticketCache);
                    CREDENTIALS.put(new CredentialsMapKey(this.winRMEndpoint, this.ticketCache, AuthenticationEnum.KERBEROS), credentials);
                }
                catch (Exception e1) {
                    if (this.continueToRetry()) {
                        AuthCredentials authCredentials = WinRMInvocationHandler.computeCredentials(this.winRMEndpoint, this.ticketCache, this.authenticationsQueue);
                        this.authentication = authCredentials.getAuthentication();
                        credentials = authCredentials.getCredentials();
                        break block8;
                    }
                    throw e1;
                }
            }
            this.wsClient = WinRMInvocationHandler.getWebServiceClient(this.winRMEndpoint, this.timeout, this.resourceUri, this.winRMWebService, credentials);
            return this.invoke(proxy, method, args);
        }
        catch (RetryAuthenticationException e) {
            if (this.continueToRetry()) {
                AuthCredentials authCredentials = WinRMInvocationHandler.computeCredentials(this.winRMEndpoint, this.ticketCache, this.authenticationsQueue);
                this.authentication = authCredentials.getAuthentication();
                this.wsClient = WinRMInvocationHandler.getWebServiceClient(this.winRMEndpoint, this.timeout, this.resourceUri, this.winRMWebService, authCredentials.getCredentials());
                return this.invoke(proxy, method, args);
            }
            Throwable cause = e.getCause();
            if (cause instanceof SOAPFaultException) {
                throw new RuntimeException("KERBEROS with encryption over HTTP is not implemented.", cause);
            }
            throw cause;
        }
    }

    boolean continueToRetry() {
        return !this.authenticationsQueue.isEmpty();
    }

    Object invokeMethod(Method method, Object[] args) throws IllegalAccessException, RetryAuthenticationException {
        WebServiceException firstEx = null;
        int retry = 0;
        while (retry < 3) {
            ++retry;
            try {
                return method.invoke((Object)this.winRMWebService, args);
            }
            catch (InvocationTargetException ite) {
                Throwable targetEx = ite.getTargetException();
                if (targetEx instanceof SOAPFaultException) {
                    if (this.winRMEndpoint.getProtocol() == WinRMHttpProtocolEnum.HTTP && this.authentication != AuthenticationEnum.NTLM) {
                        throw new RetryAuthenticationException(targetEx);
                    }
                    throw (SOAPFaultException)targetEx;
                }
                if (!(targetEx instanceof WebServiceException)) {
                    throw new IllegalStateException("Failure when calling " + WinRMInvocationHandler.createCallInfos(method, args), targetEx);
                }
                WebServiceException wsEx = (WebServiceException)targetEx;
                if (!(wsEx.getCause() instanceof IOException)) {
                    throw new RuntimeException("Exception occurred while making WinRM WebService call " + WinRMInvocationHandler.createCallInfos(method, args), wsEx);
                }
                if (wsEx.getCause().getMessage() != null && wsEx.getCause().getMessage().startsWith("Authorization loop detected on Conduit")) {
                    RuntimeException authEx = new RuntimeException(String.format("Authentication error on %s with user name \"%s\"", this.winRMEndpoint.getEndpoint(), this.winRMEndpoint.getRawUsername()));
                    if (this.authentication == AuthenticationEnum.KERBEROS) {
                        throw new RetryTgtExpirationException(authEx);
                    }
                    throw new RetryAuthenticationException(authEx);
                }
                if (firstEx == null) {
                    firstEx = wsEx;
                }
                if (retry >= 3) continue;
                try {
                    Utils.sleep(500L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Exception occured while making WinRM WebService call " + WinRMInvocationHandler.createCallInfos(method, args), ie);
                }
            }
        }
        throw new RuntimeException(String.format("failed task \"%s\" after %d attempts", WinRMInvocationHandler.createCallInfos(method, args), 3), firstEx);
    }

    static String createCallInfos(Method method, Object[] args) {
        String name = method != null && method.getName() != null ? method.getName() : "";
        return args == null ? name : Stream.concat(Stream.of(name), Stream.of(args)).filter(Objects::nonNull).map(Object::toString).collect(Collectors.joining(" "));
    }

    static Credentials createCredentials(WinRMEndpoint winRMEndpoint, AuthenticationEnum authentication, Path ticketCache) {
        switch (authentication) {
            case KERBEROS: {
                return KerberosUtils.createCredentials(winRMEndpoint.getUsername(), winRMEndpoint.getPassword(), ticketCache);
            }
        }
        String password = String.valueOf(winRMEndpoint.getPassword());
        return winRMEndpoint.getProtocol() == WinRMHttpProtocolEnum.HTTP ? new NTCredentialsWithEncryption(winRMEndpoint.getUsername(), password, null, winRMEndpoint.getDomain()) : new NTCredentials(winRMEndpoint.getUsername(), password, null, winRMEndpoint.getDomain());
    }

    static AuthCredentials computeCredentials(WinRMEndpoint winRMEndpoint, Path ticketCache, Queue<AuthenticationEnum> authenticationsQueue) {
        try {
            AuthenticationEnum authenticationEnum = authenticationsQueue.remove();
            Credentials credentials = CREDENTIALS.compute(new CredentialsMapKey(winRMEndpoint, ticketCache, authenticationEnum), (user2, cred) -> cred != null ? cred : WinRMInvocationHandler.createCredentials(winRMEndpoint, authenticationEnum, ticketCache));
            return new AuthCredentials(authenticationEnum, credentials);
        }
        catch (Exception e) {
            if (!authenticationsQueue.isEmpty()) {
                return WinRMInvocationHandler.computeCredentials(winRMEndpoint, ticketCache, authenticationsQueue);
            }
            throw e;
        }
    }

    static WinRMWebService createWinRMWebService(WinRMEndpoint winRMEndpoint, Bus bus) {
        JaxWsProxyFactoryBean jaxWsProxyFactoryBean = new JaxWsProxyFactoryBean();
        jaxWsProxyFactoryBean.setServiceName(SERVICE);
        jaxWsProxyFactoryBean.setEndpointName(PORT);
        jaxWsProxyFactoryBean.setBus(bus);
        jaxWsProxyFactoryBean.setServiceClass(WinRMWebService.class);
        jaxWsProxyFactoryBean.setAddress(winRMEndpoint.getEndpoint());
        jaxWsProxyFactoryBean.getFeatures().add(WS_ADDRESSING_FEATURE);
        jaxWsProxyFactoryBean.setBindingId("http://schemas.xmlsoap.org/wsdl/soap12/");
        jaxWsProxyFactoryBean.getClientFactoryBean().getServiceFactory().setWsdlURL(WSDL_LOCATION_URL);
        return jaxWsProxyFactoryBean.create(WinRMWebService.class);
    }

    static Client getWebServiceClient(WinRMEndpoint winRMEndpoint, long timeout, String enumerateResourceUri, WinRMWebService winRMWebService, Credentials credentials) {
        Client client = ClientProxy.getClient(winRMWebService);
        if (enumerateResourceUri != null) {
            WSManHeaderInterceptor interceptor = new WSManHeaderInterceptor(enumerateResourceUri);
            client.getOutInterceptors().add(interceptor);
        }
        client.getInInterceptors().add(new DecryptAndVerifyInInterceptor());
        client.getOutInterceptors().add(new SignAndEncryptOutInterceptor());
        client.getEndpoint().getEndpointInfo().setProperty(HTTPConduitFactory.class.getName(), new AsyncHttpEncryptionAwareConduitFactory());
        ServiceInfo serviceInfo = client.getEndpoint().getEndpointInfo().getService();
        serviceInfo.setProperty("soap.force.doclit.bare", true);
        BindingProvider bindingProvider = (BindingProvider)((Object)winRMWebService);
        bindingProvider.getBinding().setHandlerChain(HANDLER_CHAIN);
        bindingProvider.getRequestContext().put("org.apache.cxf.ws.policy.override", POLICY);
        bindingProvider.getRequestContext().put("http.autoredirect", true);
        bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", winRMEndpoint.getEndpoint());
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        headers.put("Content-Type", CONTENT_TYPE_LIST);
        bindingProvider.getRequestContext().put(Message.PROTOCOL_HEADERS, headers);
        HTTPClientPolicy httpClientPolicy = new HTTPClientPolicy();
        httpClientPolicy.setConnectionTimeout(timeout);
        httpClientPolicy.setConnectionRequestTimeout(timeout);
        httpClientPolicy.setReceiveTimeout(timeout);
        httpClientPolicy.setAllowChunking(false);
        bindingProvider.getRequestContext().put(Credentials.class.getName(), credentials);
        bindingProvider.getRequestContext().put(AuthSchemeProvider.class.getName(), AUTH_SCHEME_REGISTRY);
        AsyncHTTPConduit asyncHTTPConduit = (AsyncHTTPConduit)client.getConduit();
        asyncHTTPConduit.setClient(httpClientPolicy);
        asyncHTTPConduit.getClient().setAutoRedirect(true);
        asyncHTTPConduit.setTlsClientParameters(TLS_CLIENT_PARAMETERS);
        return client;
    }

    static {
        POLICY.addAssertion(new PrimitiveAssertion(MetadataConstants.USING_ADDRESSING_2004_QNAME));
        WS_ADDRESSING_FEATURE = new WSAddressingFeature();
        WS_ADDRESSING_FEATURE.setResponses(WSAddressingFeature.AddressingResponses.ANONYMOUS);
        TLS_CLIENT_PARAMETERS = new TLSClientParameters();
        TLS_CLIENT_PARAMETERS.setDisableCNCheck(true);
        TLS_CLIENT_PARAMETERS.setTrustManagers(new TrustManager[]{new TrustAllX509Manager()});
        CREDENTIALS = new ConcurrentHashMap<CredentialsMapKey, Credentials>();
    }

    static class AuthCredentials {
        private final AuthenticationEnum authentication;
        private final Credentials credentials;

        AuthCredentials(AuthenticationEnum authentication, Credentials credentials) {
            this.authentication = authentication;
            this.credentials = credentials;
        }

        public AuthenticationEnum getAuthentication() {
            return this.authentication;
        }

        public Credentials getCredentials() {
            return this.credentials;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.authentication, this.credentials});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AuthCredentials)) {
                return false;
            }
            AuthCredentials other = (AuthCredentials)obj;
            return this.authentication == other.authentication && Objects.equals(this.credentials, other.credentials);
        }
    }

    static class RetryTgtExpirationException
    extends RetryAuthenticationException {
        private static final long serialVersionUID = 1L;

        RetryTgtExpirationException(Throwable throwable) {
            super(throwable);
        }
    }

    static class CredentialsMapKey {
        private final String canonizedRawUsername;
        private final char[] password;
        private final Path ticketCache;
        private final AuthenticationEnum authentication;

        CredentialsMapKey(WinRMEndpoint winRMEndpoint, Path ticketCache, AuthenticationEnum authentication) {
            this.ticketCache = ticketCache;
            this.authentication = authentication;
            this.password = winRMEndpoint.getPassword();
            this.canonizedRawUsername = winRMEndpoint.getRawUsername() != null ? winRMEndpoint.getRawUsername().replaceAll("\\s", "").toUpperCase() : null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.password);
            result = 31 * result + Objects.hash(new Object[]{this.authentication, this.canonizedRawUsername, this.ticketCache});
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CredentialsMapKey)) {
                return false;
            }
            CredentialsMapKey other = (CredentialsMapKey)obj;
            return this.authentication == other.authentication && Objects.equals(this.canonizedRawUsername, other.canonizedRawUsername) && Arrays.equals(this.password, other.password) && Objects.equals(this.ticketCache, other.ticketCache);
        }
    }

    static class RetryAuthenticationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        RetryAuthenticationException(Throwable throwable) {
            super(throwable);
        }
    }
}

