/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sentrysoftware.winrm.Utils;
import org.sentrysoftware.winrm.exceptions.WqlQuerySyntaxException;

public class WqlQuery {
    private static final Pattern WQL_PATTERN = Pattern.compile("^\\s*(SELECT\\s+(?:\\*|([a-z0-9._]+(?:\\s*,\\s*[a-z0-9._]+)*))\\s+FROM\\s+)?(?:((?:ASSOCIATORS|REFERENCES)\\s+OF\\s+\\{.*\\})|([a-z0-9_]+))(\\s+WHERE\\s*+.+)?\\s*$", 34);
    private String wql;
    private List<String> selectedProperties;
    private Map<String, Set<String>> subPropertiesMap;
    private String cleanWql;

    private WqlQuery(String wql, List<String> selectedProperties, Map<String, Set<String>> subPropertiesMap, String cleanWql) {
        this.wql = wql;
        this.selectedProperties = selectedProperties;
        this.subPropertiesMap = subPropertiesMap;
        this.cleanWql = cleanWql;
    }

    public static WqlQuery newInstance(CharSequence wql) throws WqlQuerySyntaxException {
        Utils.checkNonNull(wql, "wql");
        Matcher wqlMatcher = WQL_PATTERN.matcher(wql);
        if (!wqlMatcher.find()) {
            throw new WqlQuerySyntaxException(wql.toString());
        }
        String selectFragment = wqlMatcher.group(1);
        String propertiesFragment = wqlMatcher.group(2);
        String associatorsFragment = wqlMatcher.group(3);
        String classFragment = wqlMatcher.group(4);
        String restFragment = wqlMatcher.group(5);
        if (selectFragment == null && associatorsFragment == null) {
            throw new WqlQuerySyntaxException(wql.toString());
        }
        List<String> properties = WqlQuery.buildSelectedProperties(propertiesFragment);
        Map<String, Set<String>> subPropertiesMap = WqlQuery.buildSupPropertiesMap(properties);
        String cleanWql = WqlQuery.buildCleanWql(associatorsFragment, subPropertiesMap, classFragment, restFragment);
        return new WqlQuery(wql.toString(), properties, subPropertiesMap, cleanWql);
    }

    static List<String> buildSelectedProperties(String propertiesFragment) {
        if (Utils.isNotBlank(propertiesFragment)) {
            return Arrays.asList(propertiesFragment.trim().toLowerCase().split("\\s*,\\s*"));
        }
        return new ArrayList<String>();
    }

    static Map<String, Set<String>> buildSupPropertiesMap(List<String> properties) {
        if (properties == null || properties.isEmpty()) {
            return new HashMap<String, Set<String>>();
        }
        LinkedHashMap<String, Set<String>> subPropertiesMap = new LinkedHashMap<String, Set<String>>();
        properties.stream().filter(Utils::isNotBlank).forEachOrdered(property -> {
            String[] propertyFragmentArray = property.toLowerCase().split("\\.", 2);
            String mainProperty = propertyFragmentArray[0];
            String subProperty = propertyFragmentArray.length == 2 ? propertyFragmentArray[1] : null;
            subPropertiesMap.compute(mainProperty, (key, subPropertiesSet) -> {
                if (subPropertiesSet == null) {
                    subPropertiesSet = new HashSet<String>();
                }
                if (subProperty != null) {
                    subPropertiesSet.add(subProperty);
                }
                return subPropertiesSet;
            });
        });
        return subPropertiesMap;
    }

    static String buildCleanWql(String associatorsFragment, Map<String, Set<String>> subPropertiesMap, String classFragment, String restFragment) {
        String cleanWql = associatorsFragment == null ? (subPropertiesMap.keySet().isEmpty() ? "SELECT * FROM " + classFragment : String.format("SELECT %s FROM %s", subPropertiesMap.keySet().stream().collect(Collectors.joining(",")), classFragment)) : associatorsFragment;
        if (restFragment != null) {
            cleanWql = cleanWql + restFragment;
        }
        return cleanWql;
    }

    public List<String> getSelectedProperties() {
        return this.selectedProperties;
    }

    public Map<String, Set<String>> getSubPropertiesMap() {
        return this.subPropertiesMap;
    }

    public String getCleanWql() {
        return this.cleanWql;
    }

    public String toString() {
        return this.wql;
    }
}

