/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.winrm;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class Utils {
    public static final String EMPTY = "";
    public static final String NEW_LINE = "\n";

    public static <T> void checkNonNull(T argument, String name) {
        if (argument == null) {
            throw new IllegalArgumentException(name + " must not be null.");
        }
    }

    public static boolean isBlank(String value) {
        return value == null || Utils.isEmpty(value);
    }

    public static boolean isEmpty(String value) {
        return value.trim().isEmpty();
    }

    public static boolean isNotBlank(String value) {
        return !Utils.isBlank(value);
    }

    public static String getComputerName() {
        String computerName = System.getenv("COMPUTERNAME");
        if (computerName == null) {
            return "localhost";
        }
        return computerName;
    }

    public static void sleep(long millis) throws InterruptedException {
        Thread.sleep(millis);
    }

    public static void checkArgumentNotZeroOrNegative(long argument, String name) {
        if (argument <= 0L) {
            throw new IllegalArgumentException(String.format("%s=%d must not be negative or zero.", name, argument));
        }
    }

    public static long getCurrentTimeMillis() {
        return System.currentTimeMillis();
    }

    public static void checkNonBlank(String argument, String name) {
        if (Utils.isBlank(argument)) {
            throw new IllegalArgumentException(name + " must not be null or empty.");
        }
    }

    public static <T> T execute(Callable<T> callable, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<T> future = executorService.submit(callable);
        try {
            T t = future.get(timeout, TimeUnit.MILLISECONDS);
            return t;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw e;
        }
        finally {
            executorService.shutdownNow();
        }
    }

    public static <T> void checkNonNullField(T field, String name) {
        if (field == null) {
            throw new IllegalStateException(name + " must not be null.");
        }
    }
}

