/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.ua;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.sentrysoftware.wbem.sblim.slp.ServiceLocationException;
import org.sentrysoftware.wbem.sblim.slp.internal.SLPConfig;
import org.sentrysoftware.wbem.sblim.slp.internal.TRC;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.MsgFactory;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ReplyMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.RequestMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.ua.ResultTable;

public class TCPRequester
implements Runnable {
    private InetAddress iDestination;
    private Thread iThread;
    private ResultTable iResTable;
    private RequestMessage iReqMsg;
    private byte[] iRequestBytes;
    private int iPort = SLPConfig.getGlobalCfg().getPort();
    private final int iTCPTimeOut = SLPConfig.getGlobalCfg().getTCPTimeout();

    public TCPRequester(ResultTable pResTable, InetAddress pDestination, RequestMessage pReqMsg, boolean pAsThread) throws ServiceLocationException {
        this.iResTable = pResTable;
        this.iDestination = pDestination;
        this.iReqMsg = pReqMsg;
        this.iRequestBytes = pReqMsg.serializeWithoutResponders(false, false, true);
        if (pAsThread) {
            this.iThread = new Thread(this);
            this.iThread.start();
        } else {
            this.iThread = null;
            this.run();
        }
    }

    public void waitFor() {
        if (this.iThread == null) {
            return;
        }
        try {
            this.iThread.join();
        }
        catch (InterruptedException e) {
            TRC.error(e);
        }
    }

    @Override
    public void run() {
        Socket socket = null;
        try {
            socket = new Socket(this.iDestination, this.iPort);
            socket.setSoTimeout(this.iTCPTimeOut);
            OutputStream os = socket.getOutputStream();
            TRC.debug("sendTCP");
            os.write(this.iRequestBytes);
            os.flush();
            this.handleResponse(socket);
            TRC.debug("recievedOnTCP");
        }
        catch (Exception e) {
            TRC.error(e.getMessage());
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    TRC.error(e);
                }
            }
        }
    }

    private void handleResponse(Socket pSocket) {
        ReplyMessage replyMsg;
        try {
            replyMsg = (ReplyMessage)MsgFactory.parse(pSocket);
        }
        catch (Exception e) {
            this.iResTable.addException(e);
            return;
        }
        if (this.iReqMsg.getXID() == replyMsg.getXID() && this.iReqMsg.isAllowedResponseType(replyMsg)) {
            this.iResTable.addResults(replyMsg);
        }
    }
}

