/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.sa;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.sentrysoftware.wbem.sblim.slp.ServiceLocationAttribute;
import org.sentrysoftware.wbem.sblim.slp.ServiceType;
import org.sentrysoftware.wbem.sblim.slp.ServiceURL;
import org.sentrysoftware.wbem.sblim.slp.internal.IPv6MulticastAddressFactory;
import org.sentrysoftware.wbem.sblim.slp.internal.Net;
import org.sentrysoftware.wbem.sblim.slp.internal.SLPConfig;
import org.sentrysoftware.wbem.sblim.slp.internal.TRC;
import org.sentrysoftware.wbem.sblim.slp.internal.sa.DatagramThread;

public class ServiceTable {
    DatagramThread iDgramThread;
    private boolean iUseV6 = Net.hasIPv6() && SLPConfig.getGlobalCfg().useIPv6();
    private ServiceEntryList iSrvEntryTable = new ServiceEntryList();
    private AddressHashTable iAddressHashTable = new AddressHashTable();

    public ServiceTable(DatagramThread pDgramThread) {
        this.iDgramThread = pDgramThread;
    }

    public synchronized void add(ServiceURL pSrvURL, List<ServiceLocationAttribute> pAttrList, List<String> pScopes) throws UnknownHostException, IOException {
        if (pSrvURL == null) {
            return;
        }
        TRC.debug("add URL:" + pSrvURL + ", scopes:" + ServiceTable.dumpList(pScopes));
        ServiceEntry srvEntry = this.iSrvEntryTable.get(pSrvURL);
        if (srvEntry == null) {
            this.iSrvEntryTable.add(new ServiceEntry(pSrvURL, pAttrList, pScopes));
        } else {
            srvEntry.set(pSrvURL, pAttrList, pScopes);
        }
        if (!this.iUseV6) {
            return;
        }
        this.iAddressHashTable.register(pSrvURL.getServiceType());
    }

    public synchronized void remove(ServiceURL pSrvURL) throws UnknownHostException, IOException {
        this.iSrvEntryTable.remove(pSrvURL);
        if (!this.iUseV6) {
            return;
        }
        this.iAddressHashTable.unregister(pSrvURL.getServiceType());
    }

    public synchronized List<ServiceURL> getServiceURLs(ServiceType pSrvType, List<String> pScopes) {
        TRC.debug("getServiceURLs srvType:" + pSrvType + ", scopes:" + ServiceTable.dumpList(pScopes));
        List<ServiceURL> list = this.iSrvEntryTable.getServiceURLs(pSrvType, pScopes);
        return list;
    }

    public synchronized List<ServiceLocationAttribute> getAttributes(ServiceURL pSrvURL, List<String> pScopes) {
        if (pSrvURL == null) {
            return null;
        }
        if (pSrvURL.getURLPath() == null) {
            return this.getAttributes(pSrvURL.getServiceType(), pScopes);
        }
        ServiceEntry entry = this.iSrvEntryTable.get(pSrvURL);
        return entry == null ? null : entry.getAttributes();
    }

    public synchronized List<ServiceLocationAttribute> getAttributes(ServiceType pSrvType, List<String> pScopes) {
        if (pSrvType == null) {
            return null;
        }
        HashSet<ServiceLocationAttribute> attribs = new HashSet<ServiceLocationAttribute>();
        for (int i = 0; i < this.iSrvEntryTable.size(); ++i) {
            ServiceEntry entry = (ServiceEntry)this.iSrvEntryTable.get(i);
            ServiceType srvType = entry.getServiceType();
            if (!pSrvType.equals(srvType)) continue;
            attribs.addAll(entry.getAttributes());
        }
        return new ArrayList<ServiceLocationAttribute>(attribs);
    }

    public synchronized List<ServiceType> getServiceTypes(List<String> pScopes) {
        ArrayList<ServiceType> srvTypes = null;
        for (int i = 0; i < this.iSrvEntryTable.size(); ++i) {
            ServiceType srvType;
            ServiceEntry entry = (ServiceEntry)this.iSrvEntryTable.get(i);
            if (!entry.hasMatchingScope(pScopes) || (srvType = entry.getServiceType()) == null) continue;
            if (srvTypes == null) {
                srvTypes = new ArrayList<ServiceType>();
            }
            srvTypes.add(srvType);
        }
        return srvTypes;
    }

    static String dumpList(List<?> pList) {
        return ServiceTable.dumpList(pList, ",");
    }

    private static String dumpList(List<?> pList, String pSep) {
        if (pList == null) {
            return "null";
        }
        StringBuffer buf = new StringBuffer();
        Iterator<?> itr = pList.iterator();
        boolean first = true;
        while (itr.hasNext()) {
            if (!first) {
                buf.append(pSep);
            }
            buf.append(itr.next().toString());
            first = false;
        }
        return buf.toString();
    }

    static class ServiceEntryList
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        ServiceEntryList() {
        }

        public ServiceEntry get(ServiceURL pSrvURL) {
            for (int i = 0; i < this.size(); ++i) {
                ServiceEntry entry = (ServiceEntry)this.get(i);
                if (!pSrvURL.equals(entry.getServiceURL())) continue;
                return entry;
            }
            return null;
        }

        public void remove(ServiceURL pSrvURL) {
            for (int i = 0; i < this.size(); ++i) {
                ServiceEntry entry = (ServiceEntry)this.get(i);
                if (!pSrvURL.equals(entry.getServiceURL())) continue;
                this.remove(i);
                break;
            }
        }

        public List<ServiceURL> getServiceURLs(ServiceType pSrvType, List<String> pScopes) {
            if (pSrvType == null) {
                return null;
            }
            ArrayList<ServiceURL> srvURLs = null;
            for (int i = 0; i < this.size(); ++i) {
                ServiceEntry entry = (ServiceEntry)this.get(i);
                if (!entry.hasMatchingScope(pScopes) || !pSrvType.getPrincipleTypeName().equals(entry.getServiceType().getPrincipleTypeName())) continue;
                if (srvURLs == null) {
                    srvURLs = new ArrayList<ServiceURL>();
                }
                srvURLs.add(entry.getServiceURL());
            }
            return srvURLs;
        }
    }

    class AddressHashTable {
        private HashMap<Integer, Counter> iMap = new HashMap();

        AddressHashTable() {
        }

        public void register(ServiceType pType) throws UnknownHostException, IOException {
            Integer hash = IPv6MulticastAddressFactory.getSrvTypeHash(pType);
            TRC.debug("srvType:" + pType + ", hash:" + hash);
            Counter cntr = this.iMap.get(hash);
            if (cntr == null) {
                cntr = new Counter();
                this.iMap.put(hash, cntr);
                ServiceTable.this.iDgramThread.joinGroup(IPv6MulticastAddressFactory.get(5, hash));
            } else {
                ++cntr.iValue;
            }
        }

        public void unregister(ServiceType pType) throws UnknownHostException, IOException {
            Integer hash = IPv6MulticastAddressFactory.getSrvTypeHash(pType);
            Counter cntr = this.iMap.get(hash);
            if (cntr == null) {
                return;
            }
            if (cntr.iValue <= 1) {
                this.iMap.remove(hash);
                ServiceTable.this.iDgramThread.leaveGroup(IPv6MulticastAddressFactory.get(5, hash));
            } else {
                --cntr.iValue;
            }
        }

        class Counter {
            public int iValue = 1;

            Counter() {
            }
        }
    }

    private static class ServiceEntry {
        private ServiceURL iSrvURL;
        private List<ServiceLocationAttribute> iAttribs;
        private List<String> iScopes;

        public ServiceEntry(ServiceURL pSrvURL, List<ServiceLocationAttribute> pAttribs, List<String> pScopes) {
            this.set(pSrvURL, pAttribs, pScopes);
        }

        public void set(ServiceURL pSrvURL, List<ServiceLocationAttribute> pAttribs, List<String> pScopes) {
            this.iSrvURL = pSrvURL;
            this.iAttribs = pAttribs;
            this.iScopes = pScopes;
        }

        public ServiceURL getServiceURL() {
            return this.iSrvURL;
        }

        public ServiceType getServiceType() {
            return this.iSrvURL.getServiceType();
        }

        public List<ServiceLocationAttribute> getAttributes() {
            return this.iAttribs;
        }

        public List<String> getScopes() {
            return this.iScopes;
        }

        public boolean hasMatchingScope(List<String> pScopes) {
            if (pScopes == null) {
                return false;
            }
            Iterator<String> itr = pScopes.iterator();
            while (itr.hasNext()) {
                if (!this.hasScope(itr.next())) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return "url:" + this.iSrvURL + ", attribs:" + ServiceTable.dumpList(this.iAttribs) + ", scopes:" + ServiceTable.dumpList(this.iScopes);
        }

        private boolean hasScope(String pScope) {
            return this.iScopes == null ? false : this.iScopes.contains(pScope);
        }
    }
}

