/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.sa;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.List;
import org.sentrysoftware.wbem.sblim.slp.ServiceLocationException;
import org.sentrysoftware.wbem.sblim.slp.ServiceURL;
import org.sentrysoftware.wbem.sblim.slp.internal.IPv6MulticastAddressFactory;
import org.sentrysoftware.wbem.sblim.slp.internal.Net;
import org.sentrysoftware.wbem.sblim.slp.internal.SLPConfig;
import org.sentrysoftware.wbem.sblim.slp.internal.SLPDefaults;
import org.sentrysoftware.wbem.sblim.slp.internal.TRC;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.AttributeReply;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.AttributeRequest;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.FunctionIDs;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.MsgFactory;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ReplyMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.RequestMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ServiceAcknowledgment;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ServiceDeregistration;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ServiceRegistration;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ServiceReply;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ServiceRequest;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ServiceTypeReply;
import org.sentrysoftware.wbem.sblim.slp.internal.sa.DatagramThread;
import org.sentrysoftware.wbem.sblim.slp.internal.sa.MessageTable;
import org.sentrysoftware.wbem.sblim.slp.internal.sa.ServiceTable;
import org.sentrysoftware.wbem.sblim.slp.internal.sa.TCPThread;

public class ServiceAgent
implements FunctionIDs {
    private boolean iUseV4 = Net.hasIPv4() && SLPConfig.getGlobalCfg().useIPv4();
    private boolean iUseV6 = Net.hasIPv6() && SLPConfig.getGlobalCfg().useIPv6();
    boolean iStarted;
    private volatile boolean iSkipFirstRequest;
    private DatagramThread iDGThread = new DatagramThread(this);
    private TCPThread iTCPThread = new TCPThread(this);
    private ServiceTable iSrvTable = new ServiceTable(this.iDGThread);
    private MessageTable iMsgTable = new MessageTable();

    public static void main(String[] pArgs) throws IOException {
        if (pArgs != null && pArgs.length >= 1) {
            int port = Integer.parseInt(pArgs[0]);
            SLPConfig.getGlobalCfg().setPort(port);
        }
        ServiceAgent srvAgent = new ServiceAgent();
        srvAgent.start();
        TRC.debug("starting idle loop");
        while (true) {
            try {
                while (true) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void setSkipFirstRequest(boolean pValue) {
        this.iSkipFirstRequest = pValue;
    }

    public void start() throws IOException {
        if (this.iStarted) {
            return;
        }
        TRC.debug("start receivers");
        if (this.iUseV4 || this.iUseV6) {
            this.iTCPThread.start();
            this.iDGThread.start();
            TRC.debug("wait4 TCP init");
            this.iTCPThread.wait4init();
            TRC.debug("wait4 Datagram init");
            this.iDGThread.wait4init();
        }
        this.iStarted = true;
        TRC.debug("receivers started");
        if (this.iUseV4) {
            this.iDGThread.joinGroup(SLPConfig.getMulticastAddress());
        }
        if (this.iUseV6) {
            this.iDGThread.joinGroup(IPv6MulticastAddressFactory.getSrvLocAddress(5));
        }
    }

    public void stop() {
        if (this.iUseV4 || this.iUseV6) {
            this.iTCPThread.stop();
            this.iDGThread.stop();
        }
        this.iStarted = false;
    }

    public void processMessage(DatagramSocket pDGSock, DatagramPacket pPacket) {
        byte[] reply;
        SLPMessage msg;
        try {
            msg = MsgFactory.parse(pPacket);
        }
        catch (Exception e) {
            TRC.debug("Message parsing error!", e);
            return;
        }
        try {
            TRC.debug("processing: " + msg);
            reply = this.iMsgTable.getResponse(pPacket.getAddress(), msg);
            if (reply == null) {
                SLPMessage replyMsg = this.makeReply(msg);
                if (replyMsg != null) {
                    TRC.debug("response : " + replyMsg);
                    reply = replyMsg.serialize(false, true, true);
                    this.iMsgTable.addResponse(pPacket.getAddress(), msg, reply);
                    if (this.iSkipFirstRequest) {
                        TRC.debug("refusing response");
                        return;
                    }
                }
            } else {
                TRC.debug("cached response");
            }
        }
        catch (ServiceLocationException e) {
            TRC.debug(e.toString(), e);
            reply = ServiceAgent.makeErrorReply(msg, e);
        }
        if (reply != null) {
            try {
                TRC.debug("sending response");
                pDGSock.send(new DatagramPacket(reply, reply.length, pPacket.getAddress(), pPacket.getPort()));
            }
            catch (IOException e) {
                TRC.error(e);
            }
        }
    }

    public void processMessage(Socket pStreamSock) {
        byte[] reply;
        SLPMessage msg;
        try {
            msg = MsgFactory.parse(pStreamSock.getInputStream());
        }
        catch (Exception e) {
            TRC.debug("Message parsing error!", e);
            return;
        }
        try {
            SLPMessage replyMsg = this.makeReply(msg);
            reply = replyMsg == null ? null : replyMsg.serialize(false, false, true);
        }
        catch (ServiceLocationException e) {
            reply = ServiceAgent.makeErrorReply(msg, e);
        }
        if (reply != null) {
            try {
                OutputStream os = pStreamSock.getOutputStream();
                os.write(reply);
                os.flush();
            }
            catch (IOException e) {
                TRC.error(e);
            }
        }
        try {
            pStreamSock.close();
        }
        catch (IOException e) {
            TRC.error(e);
        }
    }

    private SLPMessage makeReply(SLPMessage pRequest) throws ServiceLocationException {
        try {
            SLPMessage msg;
            SLPMessage sLPMessage = msg = pRequest instanceof RequestMessage ? this.makeReply4Request((RequestMessage)pRequest) : this.makeReply4Others(pRequest);
            if (msg != null) {
                msg.setXID(pRequest.getXID());
            }
            return msg;
        }
        catch (UnknownHostException e) {
            TRC.error(e);
            throw new ServiceLocationException(19);
        }
        catch (IOException e) {
            TRC.error(e);
            throw new ServiceLocationException(19);
        }
    }

    private ReplyMessage makeReply4Request(RequestMessage pRequest) {
        ReplyMessage replyMsg;
        List<String> scopes = pRequest.getScopeList();
        switch (pRequest.getFunctionID()) {
            case 1: {
                ServiceRequest srvRqst = (ServiceRequest)pRequest;
                if (SLPDefaults.DA_SERVICE_TYPE.equals(srvRqst.getServiceType())) {
                    return null;
                }
                List<ServiceURL> urlList = this.iSrvTable.getServiceURLs(srvRqst.getServiceType(), scopes);
                TRC.debug("srvReply : " + urlList);
                replyMsg = new ServiceReply(0, urlList);
                break;
            }
            case 6: {
                AttributeRequest attrRqst = (AttributeRequest)pRequest;
                replyMsg = new AttributeReply(0, this.iSrvTable.getAttributes(attrRqst.getServiceURL(), scopes));
                break;
            }
            case 9: {
                replyMsg = new ServiceTypeReply(0, this.iSrvTable.getServiceTypes(scopes));
                break;
            }
            default: {
                return null;
            }
        }
        return replyMsg;
    }

    private SLPMessage makeReply4Others(SLPMessage pRequest) throws IOException {
        switch (pRequest.getFunctionID()) {
            case 3: {
                ServiceRegistration srvReg = (ServiceRegistration)pRequest;
                this.iSrvTable.add(srvReg.getServiceURL(), srvReg.getAttributeList(), srvReg.getScopeList());
                return new ServiceAcknowledgment(0);
            }
            case 4: {
                ServiceDeregistration srvDereg = (ServiceDeregistration)pRequest;
                this.iSrvTable.remove(srvDereg.getServiceURL());
                return new ServiceAcknowledgment(0);
            }
        }
        return null;
    }

    private static byte[] makeErrorReply(SLPMessage pRequest, ServiceLocationException pE) {
        return ServiceAgent.makeErrorReply(pRequest, pE.getErrorCode());
    }

    private static byte[] makeErrorReply(SLPMessage pRequest, int pErrorCode) {
        ReplyMessage replyMsg;
        switch (pRequest.getFunctionID()) {
            case 1: {
                replyMsg = new ServiceReply(pErrorCode, null);
                break;
            }
            case 6: {
                replyMsg = new AttributeReply(pErrorCode, null);
                break;
            }
            case 9: {
                replyMsg = new ServiceTypeReply(pErrorCode, null);
                break;
            }
            case 3: 
            case 4: {
                replyMsg = new ServiceAcknowledgment(pErrorCode);
                break;
            }
            default: {
                return null;
            }
        }
        replyMsg.setXID(pRequest.getXID());
        try {
            return replyMsg.serialize(false, true, true);
        }
        catch (ServiceLocationException se) {
            TRC.error(se);
            return null;
        }
    }
}

