/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal.sa;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import org.sentrysoftware.wbem.sblim.slp.internal.SLPConfig;
import org.sentrysoftware.wbem.sblim.slp.internal.TRC;
import org.sentrysoftware.wbem.sblim.slp.internal.sa.RecieverThread;
import org.sentrysoftware.wbem.sblim.slp.internal.sa.ServiceAgent;

public class DatagramThread
extends RecieverThread {
    private static MulticastSocket cMCastSocket;
    private DatagramPacket iPacket = new DatagramPacket(new byte[1400], 1400);

    public DatagramThread(ServiceAgent pSrvAgent) {
        super("DatagramThread", pSrvAgent);
    }

    public synchronized void joinGroup(InetAddress pGroup) throws IOException {
        TRC.debug("join:" + pGroup);
        cMCastSocket.joinGroup(pGroup);
    }

    public synchronized void leaveGroup(InetAddress pGroup) throws IOException {
        TRC.debug("leave:" + pGroup);
        cMCastSocket.leaveGroup(pGroup);
    }

    @Override
    protected void init() throws IOException {
        if (cMCastSocket == null) {
            cMCastSocket = new MulticastSocket(SLPConfig.getGlobalCfg().getPort());
            cMCastSocket.setReuseAddress(true);
            cMCastSocket.setSoTimeout(100);
        }
    }

    @Override
    protected void mainLoop() throws IOException {
        try {
            cMCastSocket.receive(this.iPacket);
            TRC.debug("Packet received");
            this.iSrvAgent.processMessage(cMCastSocket, this.iPacket);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
    }

    @Override
    protected void close() {
        if (cMCastSocket == null) {
            return;
        }
        cMCastSocket.close();
        cMCastSocket = null;
    }
}

