/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp.internal;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.sentrysoftware.wbem.sblim.slp.ServiceType;
import org.sentrysoftware.wbem.sblim.slp.internal.SLPDefaults;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.AttributeRequest;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.SLPMessage;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ServiceRequest;
import org.sentrysoftware.wbem.sblim.slp.internal.msg.ServiceTypeRequest;

public class IPv6MulticastAddressFactory {
    private static final byte[] SRVLOC = new byte[]{-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 22};
    private static final byte[] SRVLOC_DA = new byte[]{-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 35};
    private static final byte[] SRV_RQST = new byte[]{-1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0};

    public static InetAddress getSrvLocAddress(int pScope) throws UnknownHostException {
        IPv6MulticastAddressFactory.SRVLOC[1] = (byte)(pScope & 0xFF);
        return InetAddress.getByAddress(SRVLOC);
    }

    public static InetAddress get(int pScope, SLPMessage pMsg) throws UnknownHostException {
        if (pMsg instanceof ServiceTypeRequest || pMsg instanceof AttributeRequest) {
            return IPv6MulticastAddressFactory.getSrvLocAddress(pScope);
        }
        if (pMsg instanceof ServiceRequest) {
            ServiceRequest srvRqst = (ServiceRequest)pMsg;
            return IPv6MulticastAddressFactory.get(pScope, srvRqst.getServiceType());
        }
        throw new IllegalArgumentException("Cannot determine IPv6 multicast address for " + pMsg.getClass().getName() + " !");
    }

    public static InetAddress get(int pScope, ServiceType pSrvType) throws UnknownHostException {
        if (pSrvType.equals(SLPDefaults.DA_SERVICE_TYPE)) {
            IPv6MulticastAddressFactory.SRVLOC_DA[1] = (byte)(pScope & 0xFF);
            return InetAddress.getByAddress(SRVLOC_DA);
        }
        return IPv6MulticastAddressFactory.get(pScope, IPv6MulticastAddressFactory.getSrvTypeHash(pSrvType));
    }

    public static InetAddress get(int pScope, int pSrvHash) throws UnknownHostException {
        byte scope;
        IPv6MulticastAddressFactory.SRV_RQST[1] = scope = (byte)(pScope & 0xFF);
        IPv6MulticastAddressFactory.SRV_RQST[14] = (byte)(pSrvHash >> 8 & 0xFF);
        IPv6MulticastAddressFactory.SRV_RQST[15] = (byte)(pSrvHash & 0xFF);
        return InetAddress.getByAddress(SRV_RQST);
    }

    public static int getSrvTypeHash(ServiceType pServiceType) {
        if (pServiceType == null) {
            return 4096;
        }
        String typeStr = pServiceType.toString();
        int hash = 0;
        for (int i = 0; i < typeStr.length(); ++i) {
            hash *= 33;
            hash += typeStr.charAt(i);
        }
        return (0x3FF & hash) + 4096;
    }
}

