/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.slp;

import java.io.Serializable;
import org.sentrysoftware.wbem.sblim.slp.ServiceType;

public class ServiceURL
implements Serializable {
    private static final long serialVersionUID = 8998115518853094365L;
    public static final int NO_PORT = 0;
    public static final int LIFETIME_NONE = 0;
    public static final int LIFETIME_DEFAULT = 10800;
    public static final int LIFETIME_MAXIMUM = 65535;
    public static final int LIFETIME_PERMANENT = -1;
    static final int PORT_MAXIMUM = 65535;
    private ServiceType iServiceType = null;
    private String iTransport = null;
    private String iHost = null;
    private int iPort = 0;
    private String iURLPath = null;
    private int iLifetime = 10800;
    private int iHashCode = 0;
    private static final String DELIM = "://";

    public ServiceURL(String pServiceURL, int pLifetime) {
        if (pLifetime > 65535 || pLifetime < -1) {
            throw new IllegalArgumentException("lifetime:" + pLifetime);
        }
        for (int i = 0; i < pServiceURL.length(); ++i) {
            char c = pServiceURL.charAt(i);
            if ("/:-.%_'*()$!,+\\;@?&=[]".indexOf(c) != -1 || Character.isLetterOrDigit(c)) continue;
            throw new IllegalArgumentException("invalid character: '" + c + "' on string \"" + pServiceURL + "\"");
        }
        this.parseURL(pServiceURL);
        this.iLifetime = pLifetime == -1 ? 65535 : pLifetime;
    }

    public ServiceType getServiceType() {
        return this.iServiceType;
    }

    public void setServiceType(ServiceType pServicetype) {
        if (!this.iServiceType.isServiceURL()) {
            this.iServiceType = pServicetype;
        }
    }

    public String getTransport() {
        return "";
    }

    public String getHost() {
        return this.iHost;
    }

    public int getPort() {
        return this.iPort;
    }

    public String getURLPath() {
        return this.iURLPath;
    }

    public int getLifetime() {
        return this.iLifetime;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ServiceURL)) {
            return false;
        }
        ServiceURL that = (ServiceURL)obj;
        return ServiceURL.equalObjs(this.iServiceType, that.iServiceType) && ServiceURL.equalStrs(this.iTransport, that.iTransport) && ServiceURL.equalStrs(this.iHost, that.iHost) && this.iPort == that.iPort;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.iServiceType != null) {
            buf.append(this.iServiceType);
        }
        if (this.iURLPath != null) {
            if (buf.length() > 0) {
                buf.append(DELIM);
            }
            buf.append(this.iURLPath);
        }
        return buf.toString();
    }

    public int hashCode() {
        if (this.iHashCode == 0) {
            this.iHashCode = this.toString().hashCode();
        }
        return this.iHashCode;
    }

    private void parseURL(String pUrlStr) throws IllegalArgumentException {
        String addrStr;
        int srvTypeEndIdx = pUrlStr.indexOf(DELIM);
        if (srvTypeEndIdx >= 0) {
            this.iServiceType = new ServiceType(pUrlStr.substring(0, srvTypeEndIdx));
            addrStr = pUrlStr.substring(srvTypeEndIdx + DELIM.length());
        } else if (pUrlStr.startsWith("service:")) {
            this.iServiceType = new ServiceType(pUrlStr);
            addrStr = null;
        } else {
            addrStr = pUrlStr;
        }
        if (addrStr == null) {
            return;
        }
        this.iURLPath = addrStr;
        if (addrStr.charAt(0) == '[') {
            this.parseIPv6Address(addrStr);
        } else {
            this.parseIPv4Address(addrStr);
        }
    }

    private void parseIPv6Address(String pAddrStr) throws IllegalArgumentException {
        int hostEndIdx = pAddrStr.indexOf(93);
        if (hostEndIdx < 0) {
            throw new IllegalArgumentException("']' is not found for IPv6 address");
        }
        int colonIdx = hostEndIdx + 1;
        this.iHost = pAddrStr.substring(0, colonIdx);
        if (colonIdx < pAddrStr.length()) {
            if (pAddrStr.charAt(colonIdx) != ':') {
                throw new IllegalArgumentException("':' expected in \"" + pAddrStr + "\" at position " + colonIdx + " !");
            }
            this.parsePort(pAddrStr.substring(colonIdx + 1), pAddrStr);
        }
    }

    private void parseIPv4Address(String pAddrStr) {
        int colonIdx = pAddrStr.indexOf(58);
        if (colonIdx > 0) {
            this.iHost = pAddrStr.substring(0, colonIdx);
            this.parsePort(pAddrStr.substring(colonIdx + 1), pAddrStr);
        } else {
            this.iHost = pAddrStr;
        }
    }

    private void parsePort(String pPortStr, String pAddrStr) throws IllegalArgumentException {
        try {
            this.iPort = Integer.parseInt(pPortStr);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Port field : " + pPortStr + " in " + pAddrStr + " is invalid!");
        }
    }

    private static boolean equalObjs(Object pThis, Object pThat) {
        return pThis == null ? pThat == null : pThis.equals(pThat);
    }

    private static boolean equalStrs(String pThis, String pThat) {
        return pThis == null || pThis.length() == 0 ? pThat == null || pThat.length() == 0 : pThis.equals(pThat);
    }
}

