/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.wbem;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.net.SocketFactory;
import javax.net.ssl.SSLHandshakeException;
import javax.security.auth.Subject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sentrysoftware.wbem.javax.cim.CIMArgument;
import org.sentrysoftware.wbem.javax.cim.CIMClass;
import org.sentrysoftware.wbem.javax.cim.CIMInstance;
import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.javax.cim.CIMQualifierType;
import org.sentrysoftware.wbem.javax.cim.UnsignedInteger32;
import org.sentrysoftware.wbem.javax.cim.UnsignedInteger64;
import org.sentrysoftware.wbem.javax.wbem.CloseableIterator;
import org.sentrysoftware.wbem.javax.wbem.WBEMException;
import org.sentrysoftware.wbem.javax.wbem.client.EnumerateResponse;
import org.sentrysoftware.wbem.javax.wbem.client.PasswordCredential;
import org.sentrysoftware.wbem.javax.wbem.client.RoleCredential;
import org.sentrysoftware.wbem.sblim.cimclient.WBEMClientSBLIM;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cim.CIMHelper;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMClientXML_HelperImpl;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMMessage;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMResponse;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMXMLParseException;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMXMLParserImpl;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.SAXHelper;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.AuthorizationHandler;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.AuthorizationInfo;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpClientPool;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpHeader;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpHeaderParser;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpUrlConnection;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.DebugInputStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.TrailerException;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.TimeStamp;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.MOF;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.WBEMConfiguration;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.WBEMConstants;
import org.sentrysoftware.wbem.sblim.cimclient.internal.wbem.CloseableIteratorDOM;
import org.sentrysoftware.wbem.sblim.cimclient.internal.wbem.CloseableIteratorPULL;
import org.sentrysoftware.wbem.sblim.cimclient.internal.wbem.CloseableIteratorSAX;
import org.sentrysoftware.wbem.sblim.cimclient.internal.wbem.EnumerateResponseDOM;
import org.sentrysoftware.wbem.sblim.cimclient.internal.wbem.EnumerateResponsePULL;
import org.sentrysoftware.wbem.sblim.cimclient.internal.wbem.EnumerateResponseSAX;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WBEMClientCIMXML
implements WBEMClientSBLIM {
    private final WBEMConfiguration iConfiguration = new WBEMConfiguration(new Properties());
    private Locale[] iLocales;
    private HttpClientPool iHttpClientPool;
    private URI iUri;
    private AuthorizationHandler iAuthorizationHandler;
    private CIMClientXML_HelperImpl iXmlHelper;
    private volatile String iAuthorization;
    private volatile int iNsCounter = 10;
    private volatile boolean iMPostFailed = false;
    private volatile long iMPostFailTime = 0L;
    private volatile long iCurrentTime = 0L;
    private volatile boolean iInitialized = false;
    private volatile boolean iClosed = false;
    private String iInteropNamespace = null;
    private static final String[] InteropNamespaces = new String[]{"interop", "root/interop", "root/PG_InterOp"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initializeClient(URI pUri, Subject pSubject, Locale[] pLocales) throws IllegalArgumentException {
        if (this.iInitialized) {
            throw new IllegalStateException("WBEMClient is already initialized");
        }
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        try {
            String password;
            String user2;
            this.iHttpClientPool = new HttpClientPool(this.iConfiguration);
            this.iLocales = pLocales != null && pLocales.length > 0 ? pLocales : WBEMConstants.DEFAULT_LOCALES;
            this.iUri = pUri;
            AuthorizationInfo authInfo = AuthorizationInfo.createAuthorizationInfo(this.iConfiguration.getHttpAuthenticationModule(), Boolean.FALSE, this.iUri.getHost(), this.iUri.getPort(), null, null, null);
            Principal principal = pSubject != null && pSubject.getPrincipals() != null && !pSubject.getPrincipals().isEmpty() ? pSubject.getPrincipals().iterator().next() : null;
            Object credential = pSubject != null && pSubject.getPrivateCredentials() != null && !pSubject.getPrivateCredentials().isEmpty() ? pSubject.getPrivateCredentials().iterator().next() : null;
            boolean defaultAuthEnabled = WBEMConfiguration.getGlobalConfiguration().isDefaultAuthorizationEnabled();
            String string = user2 = principal != null ? principal.getName() : "";
            String string2 = credential != null && credential instanceof PasswordCredential ? new String(((PasswordCredential)credential).getUserPassword()) : (password = credential != null && credential instanceof RoleCredential ? new String(((RoleCredential)credential).getCredential()) : "");
            if (defaultAuthEnabled && (user2 == null || user2.length() == 0) && password.length() == 0) {
                logger.trace(Level.FINER, "Principal and Credential not set - using default authorization!");
                user2 = WBEMConfiguration.getGlobalConfiguration().getDefaultPrincipal();
                password = WBEMConfiguration.getGlobalConfiguration().getDefaultCredentials();
            }
            authInfo.setCredentials(new PasswordAuthentication(user2, password.toCharArray()));
            this.iAuthorizationHandler = new AuthorizationHandler();
            this.iAuthorizationHandler.addAuthorizationInfo(authInfo);
            try {
                this.iXmlHelper = new CIMClientXML_HelperImpl();
            }
            catch (ParserConfigurationException e) {
                logger.trace(Level.FINE, "Exception while instantiating CIMClientXML_HelperImpl", e);
                logger.message("CIM3000S");
                throw new RuntimeException(e);
            }
            this.iInitialized = true;
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(CIMObjectPath pName, Subject pSubject, Locale[] pLocales) throws IllegalArgumentException, WBEMException {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        try {
            URI uri;
            if (pName == null || pName.getHost() == null || pName.getHost().length() == 0) {
                throw new IllegalArgumentException("Empty host path");
            }
            if (pName.getScheme() == null || pName.getScheme().length() == 0) {
                throw new IllegalArgumentException("Empty scheme");
            }
            if (!pName.getScheme().equalsIgnoreCase("HTTP") && !pName.getScheme().equalsIgnoreCase("HTTPS")) {
                throw new IllegalArgumentException("Protocol not supported");
            }
            try {
                uri = CIMHelper.createCimomUri(pName);
            }
            catch (URISyntaxException e) {
                throw new WBEMException(4, "Malformed URI");
            }
            this.initializeClient(uri, pSubject, pLocales);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(URI pUri, Subject pSubject, Locale[] pLocales) throws IllegalArgumentException, WBEMException {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        try {
            URI uri;
            if (pUri == null || pUri.getHost() == null || pUri.getHost().length() == 0) {
                throw new IllegalArgumentException("Empty host path");
            }
            if (pUri.getScheme() == null || pUri.getScheme().length() == 0) {
                throw new IllegalArgumentException("Empty scheme");
            }
            if (!pUri.getScheme().equalsIgnoreCase("HTTP") && !pUri.getScheme().equalsIgnoreCase("HTTPS")) {
                throw new IllegalArgumentException("Protocol not supported");
            }
            try {
                uri = CIMHelper.createCimomUri(pUri);
            }
            catch (URISyntaxException e) {
                throw new WBEMException(4, "Malformed URI");
            }
            this.initializeClient(uri, pSubject, pLocales);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public Properties getProperties() {
        return this.iConfiguration.getDomainProperties();
    }

    private int getLastSeparator(String path) {
        if (path == null) {
            return -1;
        }
        int last = -1;
        int sepUnix = path.lastIndexOf(47);
        int sepWin = path.lastIndexOf(92);
        if (sepUnix != -1 && sepWin != -1) {
            last = sepUnix > sepWin ? sepUnix : sepWin;
        } else if (sepUnix != -1) {
            last = sepUnix;
        } else if (sepWin != -1) {
            last = sepWin;
        }
        return last;
    }

    @Override
    public String getProperty(String pKey) {
        if (pKey.startsWith("javax.wbem.")) {
            if (pKey.equals("javax.wbem.client.log.console.enabled")) {
                return this.iConfiguration.getLogConsoleLevel().getName();
            }
            if (pKey.equals("javax.wbem.client.log.file.enabled")) {
                return this.iConfiguration.getLogFileLevel().getName();
            }
            if (pKey.equals("javax.wbem.client.log.maxfilesize")) {
                return Integer.toString(this.iConfiguration.getLogFileSizeLimit());
            }
            if (pKey.equals("javax.wbem.client.log.dir")) {
                String SblimKey = this.iConfiguration.getLogFileLocation();
                if (SblimKey == null) {
                    return null;
                }
                int lastSep = this.getLastSeparator(SblimKey);
                return lastSep == -1 ? null : SblimKey.substring(0, lastSep);
            }
            if (pKey.equals("javax.wbem.client.log.filename")) {
                String SblimKey = this.iConfiguration.getLogFileLocation();
                if (SblimKey == null) {
                    return null;
                }
                int lastSep = this.getLastSeparator(SblimKey);
                return lastSep == -1 ? SblimKey : SblimKey.substring(lastSep + 1);
            }
            if (pKey.equals("javax.wbem.client.log.numfiles")) {
                return Integer.toString(this.iConfiguration.getLogFileCount());
            }
            if (pKey.equals("javax.wbem.client.timeout")) {
                return Integer.toString(this.iConfiguration.getHttpTimeout());
            }
            if (pKey.equals("javax.wbem.chunking")) {
                return this.iConfiguration.isHttpChunked() ? "1" : "0";
            }
            if (pKey.equals("javax.wbem.client.keyStore")) {
                return this.iConfiguration.getSslKeyStorePath();
            }
            if (pKey.equals("javax.wbem.client.keyStorePassword")) {
                return this.iConfiguration.getSslKeyStorePassword();
            }
            if (pKey.equals("javax.wbem.client.trustStore")) {
                return this.iConfiguration.getSslTrustStorePath();
            }
            return null;
        }
        return this.iConfiguration.getDomainProperty(pKey);
    }

    @Override
    public void setProperties(Properties pProperties) {
        this.iConfiguration.setDomainProperties(pProperties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setProperty(String pKey, String pValue) {
        if (pKey.startsWith("javax.wbem.")) {
            if (pKey.equals("javax.wbem.client.log.console.enabled")) {
                this.iConfiguration.setDomainProperty("sblim.wbem.logConsoleLevel", pValue);
                return;
            } else if (pKey.equals("javax.wbem.client.log.file.enabled")) {
                this.iConfiguration.setDomainProperty("sblim.wbem.logFileLevel", pValue);
                return;
            } else if (pKey.equals("javax.wbem.client.log.maxfilesize")) {
                this.iConfiguration.setDomainProperty("sblim.wbem.logFileSizeLimit", pValue);
                return;
            } else if (pKey.equals("javax.wbem.client.log.dir")) {
                int i;
                String CurSblimLog;
                StringBuffer NewSblimLog = new StringBuffer(pValue != null ? pValue : "");
                if (NewSblimLog.length() > 0 && NewSblimLog.charAt(NewSblimLog.length() - 1) != File.separatorChar) {
                    NewSblimLog.append(File.separator);
                }
                if ((CurSblimLog = this.iConfiguration.getDomainProperty("sblim.wbem.logFileLocation")) == null) {
                    CurSblimLog = "%t/cimclient_log_%g.txt";
                }
                if ((i = this.getLastSeparator(CurSblimLog)) == -1) {
                    NewSblimLog.append(CurSblimLog);
                } else {
                    NewSblimLog.append(CurSblimLog.substring(i + 1));
                }
                this.iConfiguration.setDomainProperty("sblim.wbem.logFileLocation", NewSblimLog.toString());
                return;
            } else if (pKey.equals("javax.wbem.client.log.filename")) {
                int i;
                StringBuffer NewSblimLog = new StringBuffer(pValue != null ? pValue : "");
                String CurSblimLog = this.iConfiguration.getDomainProperty("sblim.wbem.logFileLocation");
                if (CurSblimLog != null && (i = this.getLastSeparator(CurSblimLog)) != -1) {
                    NewSblimLog.insert(0, CurSblimLog.substring(0, i + 1));
                }
                this.iConfiguration.setDomainProperty("sblim.wbem.logFileLocation", NewSblimLog.toString());
                return;
            } else if (pKey.equals("javax.wbem.client.log.numfiles")) {
                this.iConfiguration.setDomainProperty("sblim.wbem.logFileCount", pValue);
                return;
            } else if (pKey.equals("javax.wbem.client.timeout")) {
                this.iConfiguration.setDomainProperty("sblim.wbem.httpTimeout", pValue);
                return;
            } else if (pKey.equals("javax.wbem.chunking")) {
                this.iConfiguration.setDomainProperty("sblim.wbem.httpChunking", pValue.equals("0") ? "false" : "true");
                return;
            } else if (pKey.equals("javax.wbem.client.keyStore")) {
                this.iConfiguration.setDomainProperty("javax.net.ssl.keyStore", pValue);
                return;
            } else if (pKey.equals("javax.wbem.client.keyStorePassword")) {
                this.iConfiguration.setDomainProperty("javax.net.ssl.keyStorePassword", pValue);
                return;
            } else {
                if (!pKey.equals("javax.wbem.client.trustStore")) throw new IllegalArgumentException(pKey);
                this.iConfiguration.setDomainProperty("javax.net.ssl.trustStore", pValue);
            }
            return;
        } else {
            this.iConfiguration.setDomainProperty(pKey, pValue);
        }
    }

    @Override
    public CloseableIterator<CIMObjectPath> associatorNames(CIMObjectPath pObjectName, String pAssociationClass, String pResultClass, String pRole, String pResultRole) throws WBEMException {
        String operation = "AssociatorNames";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMObjectPath> iter;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.associatorNames_request(doc, pObjectName, pAssociationClass, pResultClass, pRole, pResultRole));
            InputStreamReader is = this.transmitRequest("AssociatorNames", hh, doc);
            CloseableIterator<CIMObjectPath> closeableIterator = iter = this.getIterator(is, pObjectName);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "AssociatorNames request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "AssociatorNames request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "AssociatorNames request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMClass> associatorClasses(CIMObjectPath pObjectName, String pAssociationClass, String pResultClass, String pRole, String pResultRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "AssociatorClasses";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMClass> iter;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.associatorClasses_request(doc, pObjectName, pAssociationClass, pResultClass, pRole, pResultRole, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("Associators", hh, doc);
            CloseableIterator<CIMClass> closeableIterator = iter = this.getIterator(is, pObjectName);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "AssociatorClasses request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "AssociatorClasses request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "AssociatorClasses request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMInstance> associatorInstances(CIMObjectPath pObjectName, String pAssociationClass, String pResultClass, String pRole, String pResultRole, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "AssociatorInstances";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMInstance> iter;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.associatorInstances_request(doc, pObjectName, pAssociationClass, pResultClass, pRole, pResultRole, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("Associators", hh, doc);
            CloseableIterator<CIMInstance> closeableIterator = iter = this.getIterator(is, pObjectName);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "AssociatorInstances request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "AssociatorInstances request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "AssociatorInstances request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public synchronized void close() {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        try {
            this.checkState();
            if (this.iHttpClientPool != null) {
                this.iHttpClientPool.closePool();
            }
        }
        finally {
            this.iClosed = true;
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createClass(CIMClass pClass) throws WBEMException {
        String operation = "CreateClass";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pClass == null || pClass.getObjectPath() == null || pClass.getObjectPath().getNamespace() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pClass.getObjectPath().getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.createClass_request(doc, pClass.getObjectPath(), pClass));
            InputStreamReader is = this.transmitRequest("CreateClass", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, pClass.getObjectPath());){
                iter.hasNext();
            }
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "CreateClass request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "CreateClass request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "CreateClass request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CIMObjectPath createInstance(CIMInstance pInstance) throws WBEMException {
        String operation = "CreateInstance";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pInstance == null || pInstance.getObjectPath() == null || pInstance.getObjectPath().getNamespace() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pInstance.getObjectPath().getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.createInstance_request(doc, pInstance.getObjectPath(), pInstance));
            InputStreamReader is = this.transmitRequest("CreateInstance", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, pInstance.getObjectPath());){
                if (iter.hasNext()) {
                    CIMObjectPath cIMObjectPath = (CIMObjectPath)iter.next();
                    return cIMObjectPath;
                }
            }
            CIMObjectPath cIMObjectPath = null;
            return cIMObjectPath;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "CreateInstance request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "CreateInstance request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "CreateInstance request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteClass(CIMObjectPath pPath) throws WBEMException {
        String operation = "DeleteClass";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pPath == null || pPath.getNamespace() == null || pPath.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.deleteClass_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("DeleteClass", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, pPath);){
                iter.hasNext();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "DeleteClass request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "DeleteClass request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "DeleteClass request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteInstance(CIMObjectPath pPath) throws WBEMException {
        String operation = "DeleteInstance";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pPath == null || pPath.getNamespace() == null || pPath.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.deleteInstance_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("DeleteInstance", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, pPath);){
                iter.hasNext();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "DeleteInstance request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "DeleteInstance request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "DeleteInstance request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteQualifierType(CIMObjectPath pPath) throws WBEMException {
        String operation = "DeleteQualifierType";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pPath == null || pPath.getNamespace() == null || pPath.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.deleteQualifierType_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("DeleteQualifierType", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, pPath);){
                iter.hasNext();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "DeleteQualifierType request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "DeleteQualifierType request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "DeleteQualifierType request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMObjectPath> enumerateClassNames(CIMObjectPath pPath, boolean pDeep) throws WBEMException {
        String operation = "EnumerateClassNames";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMObjectPath> iter;
            if (pPath == null || pPath.getNamespace() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateClassNames_request(doc, pPath, pDeep));
            InputStreamReader is = this.transmitRequest("EnumerateClassNames", hh, doc);
            CloseableIterator<CIMObjectPath> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "EnumerateClassNames request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "EnumerateClassNames request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "EnumerateClassNames request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMClass> enumerateClasses(CIMObjectPath pPath, boolean pDeep, boolean pPropagated, boolean pIncludeQualifiers, boolean pIncludeClassOrigin) throws WBEMException {
        String operation = "EnumerateClasses";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMClass> iter;
            if (pPath == null || pPath.getNamespace() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateClasses_request(doc, pPath, pDeep, pPropagated, pIncludeQualifiers, pIncludeClassOrigin));
            InputStreamReader is = this.transmitRequest("EnumerateClasses", hh, doc);
            CloseableIterator<CIMClass> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "EnumerateClasses request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "EnumerateClasses request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "EnumerateClasses request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMObjectPath> enumerateInstanceNames(CIMObjectPath pPath) throws WBEMException {
        String operation = "EnumerateInstanceNames";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMObjectPath> iter;
            if (pPath == null || pPath.getNamespace() == null || pPath.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateInstanceNames_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("EnumerateInstanceNames", hh, doc);
            CloseableIterator<CIMObjectPath> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "EnumerateInstanceNames request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "EnumerateInstanceNames request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "EnumerateInstanceNames request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMInstance> enumerateInstances(CIMObjectPath pPath, boolean pDeep, boolean pPropagated, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "EnumerateInstances";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMInstance> iter;
            if (pPath == null || pPath.getNamespace() == null || pPath.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumerateInstances_request(doc, pPath, pDeep, pPropagated, false, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("EnumerateInstances", hh, doc);
            CloseableIterator<CIMInstance> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "EnumerateInstances request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "EnumerateInstances request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "EnumerateInstances request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    private CloseableIterator<CIMObjectPath> enumerateNamespace(String pNamespace) {
        if (pNamespace != null && pNamespace.trim().length() > 0) {
            try {
                CloseableIterator<CIMObjectPath> result = this.enumerateInstanceNames(new CIMObjectPath(null, null, null, pNamespace, "CIM_Namespace", null));
                if (result != null) {
                    return result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public CloseableIterator<CIMObjectPath> enumerateNamespaces(String pNamespace) throws WBEMException {
        CloseableIterator<CIMObjectPath> result;
        if (pNamespace != null && pNamespace.trim().length() > 0 && (result = this.enumerateNamespace(pNamespace)) != null) {
            return result;
        }
        if (this.iInteropNamespace != null) {
            result = this.enumerateNamespace(this.iInteropNamespace);
            if (result != null) {
                return result;
            }
            this.iInteropNamespace = null;
        }
        for (int i = 0; i < InteropNamespaces.length; ++i) {
            result = this.enumerateNamespace(InteropNamespaces[i]);
            if (result == null) continue;
            if (this.iInteropNamespace == null) {
                this.iInteropNamespace = InteropNamespaces[i];
            }
            return result;
        }
        throw new WBEMException(1, "Interop namespaces do not exist, CIMOM may not support DSP1033");
    }

    @Override
    public CloseableIterator<CIMQualifierType<?>> enumerateQualifierTypes(CIMObjectPath pPath) throws WBEMException {
        String operation = "EnumerateQualifiers";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMQualifierType<?>> iter;
            if (pPath == null || pPath.getNamespace() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.enumQualifierTypes_request(doc, pPath));
            InputStreamReader is = this.transmitRequest("EnumerateQualifiers", hh, doc);
            CloseableIterator<CIMQualifierType<?>> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "EnumerateQualifiers request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "EnumerateQualifiers request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "EnumerateQualifiers request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMInstance> execQuery(CIMObjectPath pPath, String pQuery, String pQueryLanguage) throws WBEMException {
        String operation = "ExecQuery";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMInstance> iter;
            if (pPath == null || pPath.getNamespace() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pPath.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.execQuery_request(doc, pPath, pQuery, pQueryLanguage));
            InputStreamReader is = this.transmitRequest("ExecQuery", hh, doc);
            CloseableIterator<CIMInstance> closeableIterator = iter = this.getIterator(is, pPath);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "ExecQuery request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "ExecQuery request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "ExecQuery request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CIMClass getClass(CIMObjectPath pName, boolean pPropagated, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "GetClass";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pName == null || pName.getNamespace() == null || pName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.getClass_request(doc, pName, pPropagated, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("GetClass", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, pName);){
                if (iter.hasNext()) {
                    CIMClass cIMClass = (CIMClass)iter.next();
                    return cIMClass;
                }
            }
            CIMClass cIMClass = null;
            return cIMClass;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "GetClass request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "GetClass request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "GetClass request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CIMInstance getInstance(CIMObjectPath pName, boolean pPropagated, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "GetInstance";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pName == null || pName.getNamespace() == null || pName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.getInstance_request(doc, pName, pPropagated, false, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("GetInstance", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, pName);){
                if (iter.hasNext()) {
                    CIMInstance result = (CIMInstance)iter.next();
                    CIMInstance cIMInstance = new CIMInstance(pName, result.getProperties());
                    return cIMInstance;
                }
            }
            CIMInstance cIMInstance = null;
            return cIMInstance;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "GetInstance request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "GetInstance request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "GetInstance request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CIMQualifierType<?> getQualifierType(CIMObjectPath pName) throws WBEMException {
        String operation = "GetQualifier";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pName == null || pName.getNamespace() == null || pName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.getQualifier_request(doc, pName, pName.getObjectName()));
            InputStreamReader is = this.transmitRequest("GetQualifier", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, pName);){
                if (iter.hasNext()) {
                    CIMQualifierType cIMQualifierType = (CIMQualifierType)iter.next();
                    return cIMQualifierType;
                }
            }
            CIMQualifierType<?> cIMQualifierType = null;
            return cIMQualifierType;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "GetQualifier request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "GetQualifier request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "GetQualifier request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public Object invokeMethod(CIMObjectPath pName, String pMethodName, CIMArgument<?>[] pInputArguments, CIMArgument<?>[] pOutputArguments) throws WBEMException {
        String operation = "InvokeMethod";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pName == null || pName.getNamespace() == null || pName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(MOF.objectHandle(pName, false, true), "UTF-8", "US-ASCII"));
            if (pMethodName != null && pMethodName.equalsIgnoreCase("UpdateExpiredPassword")) {
                hh.addField("Pragma", "UpdateExpiredPassword");
            }
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.invokeMethod_request(doc, pName, pMethodName, pInputArguments));
            InputStreamReader is = this.transmitRequest(pMethodName, hh, doc);
            CIMResponse response = null;
            String parser = this.iConfiguration.getCimXmlParser();
            if ("SAX".equals(parser) || "PULL".equals(parser)) {
                Object object = SAXHelper.parseInvokeMethodResponse(is, pOutputArguments, null);
                return object;
            }
            response = this.getSingleResponse(is, null);
            response.checkError();
            List<Object> resultSet = response.getFirstReturnValue();
            Object rc = resultSet.size() > 0 ? resultSet.get(0) : null;
            List<Object> outParamValues = response.getParamValues();
            if (pOutputArguments != null && outParamValues != null) {
                Iterator<Object> itr = outParamValues.iterator();
                for (int i = 0; i < pOutputArguments.length && itr.hasNext(); ++i) {
                    pOutputArguments[i] = (CIMArgument)itr.next();
                }
            }
            Object object = rc;
            return object;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "InvokeMethod request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "InvokeMethod request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "InvokeMethod request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public boolean isActive() {
        return this.iInitialized && !this.iClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyClass(CIMClass pClass) throws WBEMException {
        String operation = "ModifyClass";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pClass == null || pClass.getObjectPath() == null || pClass.getObjectPath().getNamespace() == null || pClass.getObjectPath().getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pClass.getObjectPath().getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.setClass_request(doc, pClass.getObjectPath(), pClass));
            InputStreamReader is = this.transmitRequest("ModifyClass", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, pClass.getObjectPath());){
                iter.hasNext();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "ModifyClass request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "ModifyClass request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "ModifyClass request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyInstance(CIMInstance pInst, String[] pPropertyList) throws WBEMException {
        String operation = "ModifyInstance";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        if (pInst == null || pInst.getObjectPath() == null || pInst.getObjectPath().getNamespace() == null || pInst.getObjectPath().getObjectName() == null) {
            throw new WBEMException(4, "Invalid object path");
        }
        CIMObjectPath path = pInst.getObjectPath();
        try {
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(path.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.setInstance_request(doc, path, pInst, true, pPropertyList));
            InputStreamReader is = this.transmitRequest("ModifyInstance", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, path);){
                iter.hasNext();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "ModifyInstance request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "ModifyInstance request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "ModifyInstance request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMClass> referenceClasses(CIMObjectPath pObjectName, String pResultClass, String pRole, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "ReferenceClasses";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.referenceClasses_request(doc, pObjectName, pResultClass, pRole, pIncludeQualifiers, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("References", hh, doc);
            CloseableIterator<CIMClass> closeableIterator = this.getIterator(is, pObjectName);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "ReferenceClasses request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "ReferenceClasses request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "ReferenceClasses request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMInstance> referenceInstances(CIMObjectPath pObjectName, String pResultClass, String pRole, boolean pIncludeClassOrigin, String[] pPropertyList) throws WBEMException {
        String operation = "ReferenceInstances";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.referenceInstances_request(doc, pObjectName, pResultClass, pRole, pIncludeClassOrigin, pPropertyList));
            InputStreamReader is = this.transmitRequest("References", hh, doc);
            CloseableIterator<CIMInstance> closeableIterator = this.getIterator(is, pObjectName);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "ReferenceInstances request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "ReferenceInstances request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "ReferenceInstances request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public CloseableIterator<CIMObjectPath> referenceNames(CIMObjectPath pObjectName, String pResultClass, String pRole) throws WBEMException {
        String operation = "ReferenceNames";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            CloseableIterator<CIMObjectPath> iter;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.referenceNames_request(doc, pObjectName, pResultClass, pRole));
            InputStreamReader is = this.transmitRequest("ReferenceNames", hh, doc);
            CloseableIterator<CIMObjectPath> closeableIterator = iter = this.getIterator(is, pObjectName);
            return closeableIterator;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "ReferenceNames request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "ReferenceNames request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "ReferenceNames request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public void setLocales(Locale[] pLocales) {
        this.iLocales = pLocales != null && pLocales.length > 0 ? pLocales : WBEMConstants.DEFAULT_LOCALES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setQualifierType(CIMQualifierType<?> pQualifierType) throws WBEMException {
        String operation = "SetQualifierType";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pQualifierType == null || pQualifierType.getObjectPath() == null || pQualifierType.getObjectPath().getNamespace() == null || pQualifierType.getObjectPath().getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pQualifierType.getObjectPath().getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.setQualifierType_request(doc, pQualifierType.getObjectPath(), pQualifierType));
            InputStreamReader is = this.transmitRequest("SetQualifierType", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, pQualifierType.getObjectPath());){
                iter.hasNext();
            }
            return;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "SetQualifierType request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "SetQualifierType request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "SetQualifierType request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public SocketFactory getCustomSocketFactory() {
        return this.iConfiguration.getCustomSocketFactory();
    }

    @Override
    public void setCustomSocketFactory(SocketFactory pFactory) throws UnsupportedOperationException {
        this.iConfiguration.setCustomSocketFactory(pFactory);
    }

    private String getHttpErrorString(int pStatusCode) {
        switch (pStatusCode) {
            case 400: {
                return "400 - BAD REQUEST";
            }
            case 401: {
                return "401 - UNAUTHORIZED";
            }
            case 403: {
                return "403 - FORBIDDEN";
            }
            case 405: {
                return "405 - METHOD NOT ALLOWED";
            }
            case 407: {
                return "407 - PROXY AUTHENTICATION REQUIRED";
            }
        }
        return null;
    }

    private InputStreamReader transmitRequest(String pCimMethod, HttpHeader pHeader, Document pDocument) throws IOException, ProtocolException, WBEMException {
        return this.transmitRequestWorker(false, this.iUri, this.iHttpClientPool, pCimMethod, pHeader, pDocument);
    }

    private InputStreamReader transmitRequestWorker(boolean pIsIndication, URI pRecipient, HttpClientPool pClientPool, String pCimMethod, HttpHeader pHeader, Document pDocument) throws IOException, ProtocolException, WBEMException {
        String errorSFCB;
        String errorOP;
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        HttpUrlConnection connection = null;
        int exceptionNum = 1;
        if (this.iMPostFailed && !pIsIndication) {
            this.iCurrentTime = System.currentTimeMillis();
            if (this.iCurrentTime - this.iMPostFailTime > 86400000L) {
                this.iMPostFailed = false;
            }
        }
        boolean useMPost = this.iMPostFailed || pIsIndication ? false : this.iConfiguration.isHttpMPost();
        int retries = this.iConfiguration.getHttpConnectRetriesCount();
        do {
            logger.trace(Level.FINE, "Attempting to connect.. number of attempts left:" + retries);
            if (connection != null) {
                connection.disconnect();
            }
            connection = this.newConnection(pIsIndication, pRecipient, pClientPool, pCimMethod, pHeader, useMPost);
            try {
                logger.trace(Level.FINE, "Connecting...");
                connection.connect();
            }
            catch (UnknownHostException e) {
                throw new WBEMException(1, "Unknown host", null, e);
            }
            catch (SocketException e) {
                throw new WBEMException(1, "Unable to connect", null, e);
            }
            catch (SSLHandshakeException e) {
                throw new WBEMException(1, "SSL handshake exception", null, e);
            }
            OutputStream os = connection.getOutputStream();
            if (this.iConfiguration.isCimXmlTracingEnabled() || LogAndTraceBroker.getBroker().isLoggableCIMXMLTrace(Level.FINEST)) {
                ByteArrayOutputStream pos = new ByteArrayOutputStream();
                CIMClientXML_HelperImpl.dumpDocument(pos, pDocument, pIsIndication ? "indication request" : "request");
                OutputStream debugStream = LogAndTraceBroker.getBroker().getXmlTraceStream();
                if (this.iConfiguration.isCimXmlTracingEnabled() && debugStream != null) {
                    debugStream.write(((Object)pos).toString().getBytes());
                }
                if (LogAndTraceBroker.getBroker().isLoggableCIMXMLTrace(Level.FINEST)) {
                    logger.traceCIMXML(Level.FINEST, ((Object)pos).toString(), true);
                }
            }
            CIMClientXML_HelperImpl.serialize(os, pDocument);
            os.flush();
            os.close();
            int resultCode = 200;
            try {
                resultCode = connection.getResponseCode();
            }
            catch (SocketException e) {
                connection.disconnect();
                throw new WBEMException(1, "Unable to connect", null, e);
            }
            catch (SocketTimeoutException e) {
                connection.disconnect();
                throw new WBEMException(1, "Connection timed out", null, e);
            }
            catch (SSLHandshakeException e) {
                connection.disconnect();
                throw new WBEMException(1, "SSL handshake exception", null, e);
            }
            HttpHeader headers = this.parseHeaders(connection);
            String auth = connection.getRequestProperty("Authorization");
            if (auth != null) {
                this.iAuthorization = auth;
            }
            exceptionNum = 1;
            switch (resultCode) {
                case 200: {
                    int lengthToCheck;
                    int contentLength;
                    String contentLengthField;
                    if (this.iConfiguration.isHttpContentLengthRetryEnabled() && (contentLengthField = headers.getField("Content-length")) != null && contentLengthField.trim().length() > 0 && (contentLength = Integer.parseInt(contentLengthField)) < (lengthToCheck = this.iConfiguration.getHttpContentLengthThreshold())) {
                        logger.trace(Level.FINE, "Content Length below " + lengthToCheck + ", retrying");
                        break;
                    }
                    String charset = this.getCharacterSet(headers);
                    InputStream is = connection.getInputStream();
                    OutputStream debugStream = LogAndTraceBroker.getBroker().getXmlTraceStream();
                    if (this.iConfiguration.isCimXmlTracingEnabled() && debugStream != null || LogAndTraceBroker.getBroker().isLoggableCIMXMLTrace(Level.FINEST)) {
                        is = new DebugInputStream(is, debugStream, pIsIndication ? "indication response" : "response");
                    }
                    return new InputStreamReader(is, charset);
                }
                case 501: {
                    String cimProtocolVersion = headers.getField("CIMProtocolVersion");
                    if (cimProtocolVersion == null && headers.getField("CIMError") == null && useMPost) {
                        logger.trace(Level.FINER, "Received HTTP Error 501 - NOT IMPLEMENTED with M-POST, falling back to POST");
                        this.iMPostFailTime = System.currentTimeMillis();
                        useMPost = false;
                        this.iMPostFailed = true;
                        ++retries;
                        break;
                    }
                    logger.trace(Level.FINER, "Received HTTP Error 501 - NOT IMPLEMENTED, skipping retries");
                    retries = 0;
                    break;
                }
                case 400: 
                case 403: 
                case 405: {
                    logger.trace(Level.FINER, "Received HTTP Error " + this.getHttpErrorString(resultCode) + ", skipping retries");
                    retries = 0;
                    break;
                }
                case 401: 
                case 407: {
                    logger.trace(Level.FINER, "Received HTTP Error " + this.getHttpErrorString(resultCode) + ", skipping retries");
                    exceptionNum = 2;
                    retries = 0;
                    break;
                }
                default: {
                    if (useMPost) {
                        logger.trace(Level.FINER, "Received HTTP Error " + resultCode + " with M-POST, falling back to POST");
                        this.iMPostFailTime = System.currentTimeMillis();
                        useMPost = false;
                        this.iMPostFailed = true;
                        ++retries;
                        break;
                    }
                    logger.trace(Level.FINER, "Received HTTP Error " + resultCode + ", retrying");
                }
            }
            if (retries <= 0) continue;
            OutputStream debugStream = LogAndTraceBroker.getBroker().getXmlTraceStream();
            if ((!this.iConfiguration.isCimXmlTracingEnabled() || debugStream == null) && !LogAndTraceBroker.getBroker().isLoggableCIMXMLTrace(Level.FINEST)) continue;
            StringBuilder resultStr = new StringBuilder("<--- error response begin ");
            resultStr.append(TimeStamp.formatWithMillis(System.currentTimeMillis()));
            resultStr.append(" ----\nHTTP ");
            resultStr.append(resultCode);
            resultStr.append(' ');
            resultStr.append(connection.getResponseMessage());
            resultStr.append(" (retrying request)\n---- error response end ----->\n");
            if (this.iConfiguration.isCimXmlTracingEnabled() && debugStream != null) {
                debugStream.write(resultStr.toString().getBytes());
            }
            if (!LogAndTraceBroker.getBroker().isLoggableCIMXMLTrace(Level.FINEST)) continue;
            logger.traceCIMXML(Level.FINEST, resultStr.toString(), false);
        } while (retries-- > 0);
        String errorCIM = connection.getHeaderField("CIMError");
        String errorDescriptionCIM = null;
        if (errorCIM != null) {
            logger.trace(Level.FINER, "Found CIMError field with value \"" + errorCIM + "\"");
            errorDescriptionCIM = connection.getHeaderField("CIMErrorDescription");
            if (errorDescriptionCIM != null) {
                try {
                    errorDescriptionCIM = URLDecoder.decode(errorDescriptionCIM, "UTF-8");
                }
                catch (Exception e) {
                    errorDescriptionCIM = null;
                }
                logger.trace(Level.FINER, "Found CIMErrorDescription field with value \"" + errorDescriptionCIM + "\"");
            }
        }
        if ((errorOP = connection.getHeaderField("PGErrorDetail")) != null) {
            try {
                errorOP = URLDecoder.decode(errorOP, "UTF-8");
            }
            catch (Exception e) {
                errorOP = null;
            }
            logger.trace(Level.FINER, "Found PGErrorDetail field with value \"" + errorOP + "\"");
        }
        if ((errorSFCB = connection.getHeaderField("SFCBErrorDetail")) != null) {
            try {
                errorSFCB = URLDecoder.decode(errorSFCB, "UTF-8");
            }
            catch (Exception e) {
                errorSFCB = null;
            }
            logger.trace(Level.FINER, "Found SFCBErrorDetail field with value \"" + errorSFCB + "\"");
        }
        StringBuffer errorMsg = new StringBuffer("HTTP ");
        errorMsg.append(connection.getResponseCode());
        errorMsg.append(" - ");
        errorMsg.append(connection.getResponseMessage());
        if (errorCIM != null && errorDescriptionCIM != null) {
            errorMsg.append(" (CIMError: \"");
            errorMsg.append(errorCIM);
            errorMsg.append("\", CIMErrorDescription: \"");
            errorMsg.append(errorDescriptionCIM);
            errorMsg.append("\")");
        } else if (errorCIM != null || errorOP != null || errorSFCB != null) {
            errorMsg.append(" (");
            if (errorCIM != null) {
                errorMsg.append("CIMError: \"");
                errorMsg.append(errorCIM);
                errorMsg.append('\"');
            }
            if (errorOP != null) {
                if (errorCIM != null) {
                    errorMsg.append(", ");
                }
                errorMsg.append("OpenPegasus Error: \"");
                errorMsg.append(errorOP);
                errorMsg.append('\"');
            }
            if (errorSFCB != null) {
                if (errorCIM != null || errorOP != null) {
                    errorMsg.append(", ");
                }
                errorMsg.append("SFCB Error: \"");
                errorMsg.append(errorSFCB);
                errorMsg.append('\"');
            }
            errorMsg.append(')');
        }
        connection.disconnect();
        throw new WBEMException(exceptionNum, errorMsg.toString());
    }

    private HttpUrlConnection newConnection(boolean pIsIndication, URI pRecipient, HttpClientPool pClientPool, String pCimMethod, HttpHeader pHeader, boolean pUseMPost) {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        HttpUrlConnection connection = new HttpUrlConnection(pRecipient, pClientPool, this.iAuthorizationHandler);
        if (pUseMPost) {
            connection.setRequestMethod("M-POST");
        } else {
            connection.setRequestMethod("POST");
        }
        connection.useHttp11("1.1".equals(this.iConfiguration.getHttpVersion()));
        String firstLocaleStr = this.iLocales[0].getLanguage();
        if (this.iLocales[0].getCountry().length() > 0) {
            firstLocaleStr = firstLocaleStr + '-' + this.iLocales[0].getCountry();
        }
        StringBuilder restLocaleStrBld = new StringBuilder("");
        for (int i = 1; i < this.iLocales.length; ++i) {
            if (this.iLocales[i] == null || this.iLocales[i].getLanguage().length() <= 0) continue;
            restLocaleStrBld.append(", ");
            restLocaleStrBld.append(this.iLocales[i].getLanguage());
            if (this.iLocales[i].getCountry().length() <= 0) continue;
            restLocaleStrBld.append('-');
            restLocaleStrBld.append(this.iLocales[i].getCountry());
        }
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml; charset=\"utf-8\"");
        connection.setRequestProperty("Accept", "text/html, text/xml, application/xml");
        connection.setRequestProperty("Cache-Control", "no-cache");
        connection.setRequestProperty("Content-Language", firstLocaleStr);
        connection.setRequestProperty("Accept-Language", firstLocaleStr + restLocaleStrBld.toString() + ", *");
        if (this.iAuthorization != null) {
            connection.setRequestProperty("Authorization", this.iAuthorization);
        }
        String prefix = "";
        if (connection.getRequestMethod().equalsIgnoreCase("M-POST")) {
            String ns = this.getNextNs();
            connection.setRequestProperty("Man", "http://www.dmtf.org/cim/mapping/http/v1.0;ns=" + ns);
            prefix = ns + "-";
        }
        connection.setRequestProperty(prefix + "CIMProtocolVersion", "1.0");
        if (pIsIndication) {
            try {
                connection.setRequestProperty("CIMExport", HttpHeader.encode("MethodRequest", "UTF-8", "US-ASCII"));
                connection.setRequestProperty("CIMExportMethod", HttpHeader.encode("ExportIndication", "UTF-8", "US-ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                logger.trace(Level.FINE, "Exception while encoding http header", e);
                connection.setRequestProperty("CIMExport", "MethodRequest");
                connection.setRequestProperty("CIMExportMethod", "ExportIndication");
            }
        } else {
            connection.setRequestProperty(prefix + "CIMOperation", "MethodCall");
            try {
                connection.setRequestProperty(prefix + "CIMMethod", HttpHeader.encode(pCimMethod, "UTF-8", "US-ASCII"));
            }
            catch (UnsupportedEncodingException e) {
                logger.trace(Level.FINE, "Exception while encoding http header", e);
                connection.setRequestProperty(prefix + "CIMMethod", pCimMethod);
            }
        }
        Iterator<Map.Entry<HttpHeader.HeaderEntry, String>> iter = pHeader.iterator();
        while (iter.hasNext()) {
            Map.Entry<HttpHeader.HeaderEntry, String> entry = iter.next();
            connection.setRequestProperty(prefix + entry.getKey().toString(), entry.getValue().toString());
        }
        logger.exit();
        return connection;
    }

    private String getNextNs() {
        this.iNsCounter = this.iNsCounter < 99 ? (this.iNsCounter = this.iNsCounter + 1) : 10;
        return String.valueOf(this.iNsCounter);
    }

    private HttpHeader parseHeaders(URLConnection pConnection) {
        String man = pConnection.getHeaderField("Man");
        String opt = pConnection.getHeaderField("Opt");
        HttpHeader headers = new HttpHeader();
        String ns = null;
        HttpHeaderParser manOptHeader = null;
        if (man != null && man.length() > 0) {
            manOptHeader = new HttpHeaderParser(man);
        } else if (opt != null && opt.length() > 0) {
            manOptHeader = new HttpHeaderParser(opt);
        }
        if (manOptHeader != null) {
            ns = manOptHeader.getValue("ns");
        }
        if (ns != null) {
            String key;
            int i = 0;
            while ((key = pConnection.getHeaderFieldKey(++i)) != null) {
                if (key.startsWith(ns + "-")) {
                    headers.addParsedField(key.substring(3), pConnection.getHeaderField(i));
                    continue;
                }
                headers.addParsedField(key, pConnection.getHeaderField(i));
            }
        } else {
            String key;
            int i = 0;
            while ((key = pConnection.getHeaderFieldKey(++i)) != null) {
                headers.addParsedField(key, pConnection.getHeaderField(i));
            }
        }
        return headers;
    }

    private String getCharacterSet(HttpHeader pHeader) {
        String contentType = pHeader.getField("Content-type");
        String charset = "UTF-8";
        if (contentType != null && contentType.length() > 0) {
            HttpHeaderParser contentTypeHeader = new HttpHeaderParser(contentType);
            charset = contentTypeHeader.getValue("charset", charset);
        }
        return charset;
    }

    private <T> CloseableIterator<T> getIterator(InputStreamReader pStream, CIMObjectPath pPath) throws IOException, SAXException, ParserConfigurationException, WBEMException {
        String parser = this.iConfiguration.getCimXmlParser();
        CloseableIterator<Object> iter = null;
        if ("SAX".equals(parser)) {
            iter = new CloseableIteratorSAX(pStream, pPath);
        } else if ("PULL".equals(parser)) {
            iter = new CloseableIteratorPULL(pStream, pPath);
        } else if ("DOM".equals(parser)) {
            iter = new CloseableIteratorDOM(pStream, pPath);
        } else {
            throw new IllegalArgumentException("Invalid CIM-XML parser configured (\"" + parser + "\") ");
        }
        try {
            iter.hasNext();
            return iter;
        }
        catch (RuntimeException e) {
            iter.close();
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                throw (WBEMException)e.getCause();
            }
            throw e;
        }
    }

    private <T> EnumerateResponse<T> getEnumerateResponse(InputStreamReader pStream, CIMObjectPath pPath) throws IOException, SAXException, ParserConfigurationException, WBEMException {
        String parser = this.iConfiguration.getCimXmlParser();
        if ("SAX".equals(parser)) {
            return new EnumerateResponseSAX(pStream, pPath).getEnumResponse();
        }
        if ("PULL".equals(parser)) {
            return new EnumerateResponsePULL(pStream, pPath).getEnumResponse();
        }
        if ("DOM".equals(parser)) {
            return new EnumerateResponseDOM(pStream, pPath).getEnumResponse();
        }
        throw new IllegalArgumentException("Invalid CIM-XML parser configured (\"" + parser + "\") ");
    }

    private CIMResponse getSingleResponse(InputStreamReader pStream, CIMObjectPath pLocalPath) throws WBEMException {
        CIMMessage cimMsg;
        Document dom;
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(new InputSource(pStream));
        }
        catch (TrailerException e) {
            throw e.getWBEMException();
        }
        catch (Exception e) {
            String msg = "Exception occurred during DOM parsing!";
            logger.trace(Level.SEVERE, msg, e);
            throw new WBEMException(1, msg, null, e);
        }
        CIMXMLParserImpl.setLocalObjectPath(pLocalPath);
        try {
            cimMsg = CIMXMLParserImpl.parseCIM(dom.getDocumentElement());
        }
        catch (CIMXMLParseException e) {
            String msg = "Exception occurred during parseCIM!";
            logger.trace(Level.SEVERE, msg, e);
            throw new WBEMException(1, msg, null, e);
        }
        if (!(cimMsg instanceof CIMResponse)) {
            String msg = "CIM message must be response!";
            logger.trace(Level.SEVERE, msg);
            throw new WBEMException(msg);
        }
        return (CIMResponse)cimMsg;
    }

    @Override
    public Properties getLocalProperties() {
        return this.iConfiguration.getLocalProperties();
    }

    @Override
    public void setLocalProperties(Properties pProperties) {
        this.iConfiguration.setLocalProperties(pProperties);
    }

    @Override
    public void setLocalProperty(String pKey, String pValue) {
        this.iConfiguration.setLocalProperty(pKey, pValue);
    }

    private synchronized void checkState() throws IllegalStateException {
        if (this.iInitialized && !this.iClosed) {
            return;
        }
        String state = this.iClosed ? "closed." : "not initialized.";
        LogAndTraceBroker.getBroker().trace(Level.FINE, "Illegal state for operation: " + state);
        throw new IllegalStateException("WBEMClient is " + state);
    }

    @Override
    public EnumerateResponse<CIMObjectPath> associatorPaths(CIMObjectPath pObjectName, String pAssociationClass, String pResultClass, String pRole, String pResultRole, String pFilterQueryLanguage, String pFilterQuery, UnsignedInteger32 pTimeout, boolean pContinueOnError, UnsignedInteger32 pMaxObjects) throws WBEMException {
        String operation = "OpenAssociatorInstancePaths";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            EnumerateResponse<CIMObjectPath> enumResp;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.OpenAssociatorInstancePaths_request(doc, pObjectName, pAssociationClass, pResultClass, pRole, pResultRole, pFilterQueryLanguage, pFilterQuery, pTimeout, pContinueOnError, pMaxObjects));
            InputStreamReader is = this.transmitRequest("OpenAssociatorInstancePaths", hh, doc);
            EnumerateResponse<CIMObjectPath> enumerateResponse = enumResp = this.getEnumerateResponse(is, pObjectName);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "OpenAssociatorInstancePaths request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "OpenAssociatorInstancePaths request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "OpenAssociatorInstancePaths request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public EnumerateResponse<CIMInstance> associators(CIMObjectPath pObjectName, String pAssocClass, String pResultClass, String pRole, String pResultRole, boolean pIncludeClassOrigin, String[] pPropertyList, String pFilterQueryLanguage, String pFilterQuery, UnsignedInteger32 pTimeout, boolean pContinueOnError, UnsignedInteger32 pMaxObjects) throws WBEMException {
        String operation = "OpenAssociatorInstances";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            EnumerateResponse<CIMInstance> enumResp;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.OpenAssociatorInstances_request(doc, pObjectName, pAssocClass, pResultClass, pRole, pResultRole, pIncludeClassOrigin, pPropertyList, pFilterQueryLanguage, pFilterQuery, pTimeout, pContinueOnError, pMaxObjects));
            InputStreamReader is = this.transmitRequest("OpenAssociatorInstances", hh, doc);
            EnumerateResponse<CIMInstance> enumerateResponse = enumResp = this.getEnumerateResponse(is, pObjectName);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "OpenAssociatorInstances request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "OpenAssociatorInstances request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "OpenAssociatorInstances request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeEnumeration(CIMObjectPath pObjectName, String pEnumerationContext) throws WBEMException {
        String operation = "CloseEnumeration";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.CloseEnumeration_request(doc, pObjectName, pEnumerationContext));
            InputStreamReader is = this.transmitRequest("CloseEnumeration", hh, doc);
            try (CloseableIterator iter = this.getIterator(is, pObjectName);){
                iter.hasNext();
            }
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "CloseEnumeration request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "CloseEnumeration request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "CloseEnumeration request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public EnumerateResponse<CIMObjectPath> enumerateInstancePaths(CIMObjectPath pObjectName, String pFilterQueryLanguage, String pFilterQuery, UnsignedInteger32 pTimeout, boolean pContinueOnError, UnsignedInteger32 pMaxObjects) throws WBEMException {
        String operation = "OpenEnumerateInstancePaths";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            EnumerateResponse<CIMObjectPath> enumResp;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.OpenEnumerateInstancePaths_request(doc, pObjectName, pFilterQueryLanguage, pFilterQuery, pTimeout, pContinueOnError, pMaxObjects));
            InputStreamReader is = this.transmitRequest("OpenEnumerateInstancePaths", hh, doc);
            EnumerateResponse<CIMObjectPath> enumerateResponse = enumResp = this.getEnumerateResponse(is, pObjectName);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "OpenEnumerateInstancePaths request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "OpenEnumerateInstancePaths request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "OpenEnumerateInstancePaths request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public EnumerateResponse<CIMInstance> enumerateInstances(CIMObjectPath pObjectName, boolean pDeepInheritance, boolean pIncludeClassOrigin, String[] pPropertyList, String pFilterQueryLanguage, String pFilterQuery, UnsignedInteger32 pTimeout, boolean pContinueOnError, UnsignedInteger32 pMaxObjects) throws WBEMException {
        String operation = "OpenEnumerateInstances";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            EnumerateResponse<CIMInstance> enumResp;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.OpenEnumerateInstances_request(doc, pObjectName, pDeepInheritance, pIncludeClassOrigin, pPropertyList, pFilterQueryLanguage, pFilterQuery, pTimeout, pContinueOnError, pMaxObjects));
            InputStreamReader is = this.transmitRequest("OpenEnumerateInstances", hh, doc);
            EnumerateResponse<CIMInstance> enumerateResponse = enumResp = this.getEnumerateResponse(is, pObjectName);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "OpenEnumerateInstances request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "OpenEnumerateInstances request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "OpenEnumerateInstances request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public UnsignedInteger64 enumerationCount(CIMObjectPath pObjectName, String pEnumerationContext) throws WBEMException {
        String operation = "EnumerationCount";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            try {
                if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                    throw new WBEMException(4, "Invalid object path");
                }
                HttpHeader hh = new HttpHeader();
                hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
                Document doc = this.iXmlHelper.newDocument();
                this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.EnumerationCount_request(doc, pObjectName, pEnumerationContext));
                InputStreamReader is = this.transmitRequest("EnumerationCount", hh, doc);
                this.getEnumerateResponse(is, pObjectName);
                throw new WBEMException("EnumerationCount is currently not supported by client");
            }
            catch (WBEMException e) {
                logger.trace(Level.FINE, "EnumerationCount request resulted in CIM Error", e);
                throw e;
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                    logger.trace(Level.FINE, "EnumerationCount request resulted in CIM Error", e.getCause());
                    throw (WBEMException)e.getCause();
                }
                logger.trace(Level.FINE, "EnumerationCount request failed", e);
                throw new WBEMException(1, null, null, e);
            }
        }
        catch (Throwable throwable) {
            logger.exit();
            throw throwable;
        }
    }

    @Override
    public EnumerateResponse<CIMInstance> execQueryInstances(CIMObjectPath pObjectName, String pFilterQuery, String pFilterQueryLanguage, boolean pReturnQueryResultClass, UnsignedInteger32 pTimeout, boolean pContinueOnError, UnsignedInteger32 pMaxObjects, CIMClass pQueryResultClass) throws WBEMException {
        String operation = "OpenQueryInstances";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            EnumerateResponse<CIMInstance> enumResp;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.OpenQueryInstances_request(doc, pObjectName, pFilterQuery, pFilterQueryLanguage, pReturnQueryResultClass, pTimeout, pContinueOnError, pMaxObjects, pQueryResultClass));
            InputStreamReader is = this.transmitRequest("OpenQueryInstances", hh, doc);
            EnumerateResponse<CIMInstance> enumerateResponse = enumResp = this.getEnumerateResponse(is, pObjectName);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "OpenQueryInstances request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "OpenQueryInstances request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "OpenQueryInstances request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public EnumerateResponse<CIMObjectPath> getInstancePaths(CIMObjectPath pObjectName, String pContext, UnsignedInteger32 pMaxObjects) throws WBEMException {
        String operation = "PullInstancePaths";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            EnumerateResponse<CIMObjectPath> enumResp;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.PullInstancePaths_request(doc, pObjectName, pContext, pMaxObjects));
            InputStreamReader is = this.transmitRequest("PullInstancePaths", hh, doc);
            EnumerateResponse<CIMObjectPath> enumerateResponse = enumResp = this.getEnumerateResponse(is, pObjectName);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "PullInstancePaths request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "PullInstancePaths request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "PullInstancePaths request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public EnumerateResponse<CIMInstance> getInstances(CIMObjectPath pObjectName, String pContext, UnsignedInteger32 pMaxObjects) throws WBEMException {
        String operation = "PullInstances";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            EnumerateResponse<CIMInstance> enumResp;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.PullInstances_request(doc, pObjectName, pContext, pMaxObjects));
            InputStreamReader is = this.transmitRequest("PullInstances", hh, doc);
            EnumerateResponse<CIMInstance> enumerateResponse = enumResp = this.getEnumerateResponse(is, pObjectName);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "PullInstances request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "PullInstances request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "PullInstances request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public EnumerateResponse<CIMInstance> getInstancesWithPath(CIMObjectPath pObjectName, String pContext, UnsignedInteger32 pMaxObjects) throws WBEMException {
        String operation = "PullInstancesWithPath";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            EnumerateResponse<CIMInstance> enumResp;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.PullInstancesWithPath_request(doc, pObjectName, pContext, pMaxObjects));
            InputStreamReader is = this.transmitRequest("PullInstancesWithPath", hh, doc);
            EnumerateResponse<CIMInstance> enumerateResponse = enumResp = this.getEnumerateResponse(is, pObjectName);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "PullInstancesWithPath request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "PullInstancesWithPath request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "PullInstancesWithPath request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public EnumerateResponse<CIMObjectPath> referencePaths(CIMObjectPath pObjectName, String pResultClass, String pRole, String pFilterQueryLanguage, String pFilterQuery, UnsignedInteger32 pTimeout, boolean pContinueOnError, UnsignedInteger32 pMaxObjects) throws WBEMException {
        String operation = "OpenReferenceInstancePaths";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            EnumerateResponse<CIMObjectPath> enumResp;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.OpenReferenceInstancePaths_request(doc, pObjectName, pResultClass, pRole, pFilterQueryLanguage, pFilterQuery, pTimeout, pContinueOnError, pMaxObjects));
            InputStreamReader is = this.transmitRequest("OpenReferenceInstancePaths", hh, doc);
            EnumerateResponse<CIMObjectPath> enumerateResponse = enumResp = this.getEnumerateResponse(is, pObjectName);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "OpenReferenceInstancePaths request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "OpenReferenceInstancePaths request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "OpenReferenceInstancePaths request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    @Override
    public EnumerateResponse<CIMInstance> references(CIMObjectPath pObjectName, String pResultClass, String pRole, boolean pIncludeClassOrigin, String[] pPropertyList, String pFilterQueryLanguage, String pFilterQuery, UnsignedInteger32 pTimeout, boolean pContinueOnError, UnsignedInteger32 pMaxObjects) throws WBEMException {
        String operation = "OpenReferenceInstances";
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            EnumerateResponse<CIMInstance> enumResp;
            if (pObjectName == null || pObjectName.getNamespace() == null || pObjectName.getObjectName() == null) {
                throw new WBEMException(4, "Invalid object path");
            }
            HttpHeader hh = new HttpHeader();
            hh.addField("CIMObject", HttpHeader.encode(pObjectName.getNamespace(), "UTF-8", "US-ASCII"));
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.OpenReferenceInstances_request(doc, pObjectName, pResultClass, pRole, pIncludeClassOrigin, pPropertyList, pFilterQueryLanguage, pFilterQuery, pTimeout, pContinueOnError, pMaxObjects));
            InputStreamReader is = this.transmitRequest("OpenReferenceInstances", hh, doc);
            EnumerateResponse<CIMInstance> enumerateResponse = enumResp = this.getEnumerateResponse(is, pObjectName);
            return enumerateResponse;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "OpenReferenceInstances request resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "OpenReferenceInstances request resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "OpenReferenceInstances request failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }

    private InputStreamReader transmitIndicationRequest(URI pRecipient, HttpClientPool pClientPool, HttpHeader pHeader, Document pDocument) throws IOException, ProtocolException, WBEMException {
        return this.transmitRequestWorker(true, pRecipient, pClientPool, null, pHeader, pDocument);
    }

    @Override
    public boolean sendIndication(URI pRecipient, CIMInstance pIndication) throws WBEMException {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        this.checkState();
        try {
            if (pRecipient == null || pRecipient.getScheme() == null || pRecipient.getHost() == null || pRecipient.getPort() <= 0) {
                throw new WBEMException(4, "Invalid recipient URI, must contain valid scheme://host:port");
            }
            if (!pRecipient.getScheme().equalsIgnoreCase("HTTP") && !pRecipient.getScheme().equalsIgnoreCase("HTTPS")) {
                throw new WBEMException(4, "Invalid scheme " + pRecipient.getScheme() + ", must be http or https");
            }
            if (pIndication == null) {
                throw new WBEMException(4, "Invalid indication, must not be null");
            }
            logger.trace(Level.FINER, "Attempting to send following indication to " + pRecipient.toString() + ":\n" + pIndication.toString());
            HttpHeader hh = new HttpHeader();
            Document doc = this.iXmlHelper.newDocument();
            this.iXmlHelper.createCIMMessage(doc, this.iXmlHelper.sendIndication_request(doc, pIndication));
            HttpClientPool indPool = new HttpClientPool(this.iConfiguration);
            InputStreamReader is = this.transmitIndicationRequest(pRecipient, indPool, hh, doc);
            boolean success = false;
            if (is != null) {
                CIMResponse response = this.getSingleResponse(is, null);
                success = response != null && response.isSuccessful();
            }
            indPool.closePool();
            boolean bl = success;
            return bl;
        }
        catch (WBEMException e) {
            logger.trace(Level.FINE, "Sending indication resulted in CIM Error", e);
            throw e;
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause() instanceof WBEMException) {
                logger.trace(Level.FINE, "Sending indication resulted in CIM Error", e.getCause());
                throw (WBEMException)e.getCause();
            }
            logger.trace(Level.FINE, "Sending indication failed", e);
            throw new WBEMException(1, null, null, e);
        }
        finally {
            logger.exit();
        }
    }
}

