/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.wbem;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.sentrysoftware.wbem.javax.cim.CIMObjectPath;
import org.sentrysoftware.wbem.javax.wbem.CloseableIterator;
import org.sentrysoftware.wbem.javax.wbem.WBEMException;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMMessage;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMResponse;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMXMLParseException;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.CIMXMLParserImpl;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.TrailerException;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class CloseableIteratorDOM
implements CloseableIterator<Object> {
    private Iterator<Object> iItr;
    private CIMResponse iRsp;
    private WBEMException iWBEMException;
    private List<Object> outParamValues;

    private void trace(Level pLevel, String pMsg, Exception pE) {
        LogAndTraceBroker.getBroker().trace(pLevel, pMsg, pE);
    }

    private void trace(Level pLevel, String pMsg) {
        LogAndTraceBroker.getBroker().trace(pLevel, pMsg, null);
    }

    public CloseableIteratorDOM(InputStreamReader pStream, CIMObjectPath pPath) throws WBEMException, IOException {
        try {
            this.parse(new InputSource(pStream), pPath);
        }
        finally {
            pStream.close();
        }
    }

    public CloseableIteratorDOM(InputSource pIs, CIMObjectPath pLocalPath) throws WBEMException {
        this.parse(pIs, pLocalPath);
    }

    @Override
    public void close() {
        this.iItr = null;
        this.iRsp = null;
        this.iWBEMException = null;
        this.outParamValues = null;
    }

    @Override
    public boolean hasNext() {
        if (this.iWBEMException != null) {
            throw new RuntimeException(this.iWBEMException);
        }
        if (this.iRsp == null) {
            return false;
        }
        try {
            this.iRsp.checkError();
        }
        catch (WBEMException e) {
            throw new RuntimeException(e);
        }
        return this.iItr == null ? false : this.iItr.hasNext();
    }

    @Override
    public Object next() {
        return this.iItr.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WBEMException getWBEMException() {
        return this.iWBEMException;
    }

    public List<Object> getParamValues() {
        return this.outParamValues;
    }

    private void parse(InputSource pIs, CIMObjectPath pLocalPath) throws WBEMException {
        CIMMessage cimMsg;
        Document dom;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            dom = db.parse(pIs);
        }
        catch (TrailerException e) {
            this.iWBEMException = e.getWBEMException();
            return;
        }
        catch (Exception e) {
            String msg = "Exception occurred during DOM parsing!";
            this.trace(Level.SEVERE, msg, e);
            throw new WBEMException(1, msg, null, e);
        }
        CIMXMLParserImpl.setLocalObjectPath(pLocalPath);
        try {
            cimMsg = CIMXMLParserImpl.parseCIM(dom.getDocumentElement());
        }
        catch (CIMXMLParseException e) {
            String msg = "Exception occurred during parseCIM!";
            this.trace(Level.SEVERE, msg, e);
            throw new WBEMException(1, msg, null, e);
        }
        if (!(cimMsg instanceof CIMResponse)) {
            String msg = "CIM message must be response!";
            this.trace(Level.SEVERE, msg);
            throw new WBEMException(msg);
        }
        this.iRsp = (CIMResponse)cimMsg;
        List<Object> retValVec = this.iRsp.getFirstReturnValue();
        this.iItr = retValVec == null ? null : retValVec.iterator();
        this.outParamValues = this.iRsp.getParamValues();
    }
}

