/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.uri;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URIString
implements CharSequence {
    private char[] iCA;
    private int iInitStart;
    private int iStart;
    private int iEnd;
    private Matcher iM;

    public URIString(char[] pCharArray, int pStart, int pEnd) {
        if (pEnd < pStart) {
            throw new IndexOutOfBoundsException("end:" + pEnd + " < start:" + pStart);
        }
        if (pEnd > pCharArray.length) {
            throw new IndexOutOfBoundsException("charArray.length:" + pCharArray.length + ", start:" + pStart + ", end:" + pEnd + "\nend:" + pEnd + " > charArray.length:" + pCharArray.length);
        }
        this.iCA = pCharArray;
        this.iInitStart = this.iStart = pStart;
        this.iEnd = pEnd;
    }

    public URIString(char[] pCharArray) {
        this(pCharArray, 0, pCharArray.length);
    }

    public URIString(String pStr) {
        this(pStr.toCharArray());
    }

    public URIString(URIString pUriStr) {
        this.set(pUriStr);
    }

    public void set(URIString pUriStr) {
        this.iCA = pUriStr.iCA;
        this.iStart = pUriStr.iStart;
        this.iEnd = pUriStr.iEnd;
    }

    public URIString deepCopy() {
        return new URIString(this);
    }

    public int find(char pChar) {
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) != pChar) continue;
            return i;
        }
        return -1;
    }

    @Override
    public char charAt(int pIdx) {
        return this.iCA[this.iStart + pIdx];
    }

    @Override
    public int length() {
        return this.iEnd - this.iStart;
    }

    @Override
    public CharSequence subSequence(int pStart, int pEnd) {
        return new URIString(this.iCA, this.iStart + pStart, this.iStart + pEnd);
    }

    @Override
    public String toString() {
        return new String(this.iCA, this.iStart, this.length());
    }

    public String toInitString() {
        return new String(this.iCA, this.iInitStart, this.iEnd - this.iInitStart);
    }

    public int getPos() {
        return this.iStart - this.iInitStart;
    }

    public String markPosition() {
        return this.markPosition(this.getPos());
    }

    public String markPosition(int pPos) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.toInitString() + '\n');
        for (int i = 0; i < pPos; ++i) {
            buf.append(' ');
        }
        buf.append("^\n");
        return buf.toString();
    }

    public String substring(int pBeginIdx, int pEndIdx) {
        return new String(this.iCA, this.iStart + pBeginIdx, pEndIdx - pBeginIdx);
    }

    public boolean startsWith(char pC) {
        if (this.length() == 0) {
            return false;
        }
        return this.charAt(0) == pC;
    }

    public void cutStarting() {
        this.cutStarting(1);
    }

    public boolean cutStarting(char pC) {
        if (this.startsWith(pC)) {
            ++this.iStart;
            return true;
        }
        return false;
    }

    public boolean cutStarting(CharSequence pSeq) {
        if (pSeq.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < pSeq.length(); ++i) {
            if (this.charAt(i) == pSeq.charAt(i)) continue;
            return false;
        }
        this.iStart += pSeq.length();
        return true;
    }

    public boolean cutStarting(String pStr, boolean pIgnoreCase) {
        if (pStr.length() > this.length()) {
            return false;
        }
        String subStr = this.substring(0, pStr.length());
        if (pIgnoreCase ? pStr.equalsIgnoreCase(subStr) : pStr.equals(subStr)) {
            this.iStart += pStr.length();
            return true;
        }
        return false;
    }

    public void cutStarting(int pChars) {
        if (pChars > this.length()) {
            throw new IndexOutOfBoundsException("chars:" + pChars + " > length()" + this.length());
        }
        this.iStart += pChars;
    }

    public String removeTill(char pChar, boolean pRemoveChar, boolean pMustFound) {
        int pos = this.find(pChar);
        if (pos < 0) {
            if (pMustFound) {
                return null;
            }
            pos = this.length();
            pRemoveChar = false;
        }
        String strVal = this.substring(0, pos);
        this.cutStarting(pRemoveChar ? pos + 1 : pos);
        return strVal;
    }

    public String removeTill(char pChar, boolean pRemoveChar) {
        return this.removeTill(pChar, pRemoveChar, false);
    }

    public String removeTill(char pChar) {
        return this.removeTill(pChar, false);
    }

    public boolean matchAndCut(Pattern pPat, int pGroup) {
        this.iM = pPat.matcher(new URIString(this));
        if (this.iM.matches()) {
            this.iStart += this.iM.end(pGroup);
            return true;
        }
        return false;
    }

    public String group(int pI) {
        return this.iM.group(pI);
    }
}

