/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.uri;

import java.util.regex.Pattern;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.KeyValuePairs;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.NamespaceHandle;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.NamespacePath;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.URIString;

public class URI {
    private NamespacePath iNamespacePath;
    private String iUriType;
    private String iClassName;
    private KeyValuePairs iKeyValuePairs;
    private boolean iIsRef;
    private static final String NAMESPACE = "namespace";
    private static final String CLASS = "class";
    private static final String INSTANCE = "instance";
    private static final Pattern PAT = Pattern.compile("^([A-Za-z_]+[A-Za-z0-9_]*).*");

    public static URI parse(String pUri) throws IllegalArgumentException {
        boolean typed;
        URIString uriStr = new URIString(pUri);
        NamespacePath nsPath = NamespacePath.parse(uriStr);
        if (nsPath == null) {
            String msg = "namespacePath expected!\n" + uriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        String uriType = URI.parseUriType(uriStr);
        boolean bl = typed = uriType != null;
        if (uriStr.length() == 0) {
            if (typed && uriType != NAMESPACE) {
                String msg = uriType + " excepted but " + NAMESPACE + " found!\n" + uriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return new URI(nsPath, uriType, null, null);
        }
        if (!typed && !uriStr.cutStarting(':')) {
            String msg = "':' expected!\n" + uriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        String className = URI.parseClassName(uriStr, typed);
        if (uriStr.length() == 0) {
            if (typed && uriType != CLASS) {
                String msg = uriType + " expected but " + CLASS + " found!\n" + uriStr.markPosition();
                throw new IllegalArgumentException(msg);
            }
            return new URI(nsPath, uriType, className, null);
        }
        KeyValuePairs keyValuePairs = URI.parseKeyValuePairs(uriStr, typed);
        return new URI(nsPath, uriType, className, keyValuePairs);
    }

    public static URI parseRef(URIString pUriStr, boolean pTyped) throws IllegalArgumentException {
        URIString uriStr = pUriStr.deepCopy();
        String namespaceName = NamespaceHandle.parseNamespaceName(uriStr);
        if (pTyped) {
            if (!uriStr.cutStarting("/(instance)")) {
                namespaceName = null;
                uriStr.set(pUriStr);
            }
        } else if (!uriStr.cutStarting(':')) {
            namespaceName = null;
            uriStr.set(pUriStr);
        }
        String className = URI.parseClassName(uriStr, false);
        if (uriStr.length() == 0) {
            if (pTyped) {
                return new URI(null, className, null, pTyped);
            }
            String msg = "Untyped reference can be instance reference only!\n" + uriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        KeyValuePairs keyValuePairs = URI.parseKeyValuePairs(uriStr, pTyped);
        if (keyValuePairs == null) {
            String msg = "Property reference must contain key-value pairs!\n" + uriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        pUriStr.set(uriStr);
        return new URI(namespaceName, className, keyValuePairs, pTyped);
    }

    public String getNamespaceType() {
        return this.iNamespacePath == null ? null : this.iNamespacePath.getNamespaceType();
    }

    public String getNamespaceName() {
        return this.iNamespacePath == null ? null : this.iNamespacePath.getNamespaceName();
    }

    public String getUserInfo() {
        return this.iNamespacePath == null ? null : this.iNamespacePath.getUserInfo();
    }

    public String getHost() {
        if (this.iNamespacePath == null) {
            return null;
        }
        String userInfo = this.iNamespacePath.getUserInfo();
        String host = this.iNamespacePath.getHost();
        return userInfo == null ? host : userInfo + '@' + host;
    }

    public String getPort() {
        return this.iNamespacePath == null ? null : this.iNamespacePath.getPort();
    }

    public String getClassName() {
        return this.iClassName;
    }

    public KeyValuePairs getKeyValuePairs() {
        return this.iKeyValuePairs;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.iNamespacePath != null) {
            if (this.iIsRef) {
                buf.append(this.getNamespaceName());
            } else {
                buf.append(this.iNamespacePath.toString());
            }
        }
        if (this.iUriType != null) {
            buf.append("/(" + this.iUriType + ")");
        }
        if (this.iClassName != null) {
            if (this.iNamespacePath != null && this.iUriType == null) {
                buf.append(':');
            }
            buf.append(this.iClassName);
            if (this.iKeyValuePairs != null) {
                buf.append('.');
                buf.append(this.iKeyValuePairs.toString());
            }
        }
        return buf.toString();
    }

    private URI(NamespacePath pNamespacePath, String pUriType, String pClassName, KeyValuePairs pKeyValuePairs) {
        this.iNamespacePath = pNamespacePath;
        this.iUriType = pUriType;
        this.iClassName = pClassName;
        this.iKeyValuePairs = pKeyValuePairs;
        this.iIsRef = false;
    }

    private URI(String pNamespaceName, String pClassName, KeyValuePairs pKeyValuePairs, boolean pTyped) {
        if (pNamespaceName == null && pClassName == null) {
            String msg = "pNamespaceName or pClassName must be set!";
            throw new IllegalArgumentException(msg);
        }
        if (pKeyValuePairs != null && pClassName == null) {
            String msg = "If pKeyValuePairs is set pClassName cannot be null!";
            throw new IllegalArgumentException(msg);
        }
        NamespacePath namespacePath = this.iNamespacePath = pNamespaceName == null ? null : new NamespacePath(pNamespaceName);
        this.iUriType = pTyped ? (pKeyValuePairs != null ? INSTANCE : (pClassName != null ? CLASS : NAMESPACE)) : null;
        this.iClassName = pClassName;
        this.iKeyValuePairs = pKeyValuePairs;
        this.iIsRef = true;
    }

    private static String parseUriType(URIString pUriStr) {
        URIString uriStr = pUriStr.deepCopy();
        if (!uriStr.cutStarting("/(")) {
            return null;
        }
        String typeStr = uriStr.removeTill(')', true, true);
        if (typeStr == null) {
            return null;
        }
        if (typeStr.equalsIgnoreCase(NAMESPACE)) {
            typeStr = NAMESPACE;
        } else if (typeStr.equalsIgnoreCase(CLASS)) {
            typeStr = CLASS;
        } else if (typeStr.equalsIgnoreCase(INSTANCE)) {
            typeStr = INSTANCE;
        } else {
            return null;
        }
        pUriStr.set(uriStr);
        return typeStr;
    }

    private static String parseClassName(URIString pUriStr, boolean pTyped) throws IllegalArgumentException {
        if (!pUriStr.matchAndCut(PAT, 1)) {
            String msg = "className expected!\n" + pUriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        String className = pUriStr.group(1);
        return className;
    }

    private static KeyValuePairs parseKeyValuePairs(URIString pUriStr, boolean pTyped) throws IllegalArgumentException {
        if (!pUriStr.cutStarting('.')) {
            String msg = "'.' expected!\n" + pUriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        KeyValuePairs keyValuePairs = KeyValuePairs.parse(pTyped, pUriStr);
        if (keyValuePairs == null) {
            String msg = "keyValuePairs expected!\n" + pUriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        return keyValuePairs;
    }
}

