/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.uri;

import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.QuotedValue;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.URIString;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.Value;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.Util;

public class StringValue
extends Value
implements QuotedValue {
    private static final int NORMAL = 0;
    private static final int ESCAPED = 1;
    private static final int CLOSED = 2;
    private String iStr;

    public static Value parse(URIString pUriStr) throws IllegalArgumentException {
        URIString uriStr = pUriStr.deepCopy();
        if (uriStr.charAt(0) != '\"') {
            String msg = "Starting '\"' is missing!\n" + uriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        int rIdx = 1;
        StringBuffer dstBuf = new StringBuffer();
        int state = 0;
        while (rIdx < uriStr.length()) {
            char ch = uriStr.charAt(rIdx++);
            if (state == 0) {
                if (ch == '\\') {
                    state = 1;
                    continue;
                }
                if (ch == '\"') {
                    state = 2;
                    break;
                }
            } else {
                state = 0;
            }
            dstBuf.append(ch);
        }
        if (state != 2) {
            String msg = "Closing '\"' is missing!\n" + uriStr.markPosition(rIdx);
            throw new IllegalArgumentException(msg);
        }
        uriStr.cutStarting(rIdx);
        if (uriStr.length() != 0 && uriStr.charAt(0) != ',') {
            String msg = "Next character should be ',' or end of string!\n" + uriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        pUriStr.set(uriStr);
        return new StringValue(dstBuf.toString());
    }

    private StringValue(String pStr) {
        this.iStr = pStr;
    }

    public String toString() {
        return this.iStr;
    }

    @Override
    public String toQuotedString() {
        return Util.quote(this.iStr);
    }

    @Override
    public String getTypeInfo() {
        return "string";
    }
}

