/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.uri;

import java.util.regex.Pattern;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.QuotedValue;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.URIString;
import org.sentrysoftware.wbem.sblim.cimclient.internal.uri.Value;

public class KeyValuePair {
    private static final Pattern KEYNAMEPAT = Pattern.compile("^([A-Za-z][0-9A-Za-z_]*).*");
    private String iKey;
    private Value iValue;
    private boolean iTyped;

    public static KeyValuePair parse(boolean pTyped, URIString pUriStr) throws IllegalArgumentException {
        URIString uriStr = pUriStr.deepCopy();
        if (!uriStr.matchAndCut(KEYNAMEPAT, 1)) {
            String msg = "keyName expected!\n" + uriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        String key = uriStr.group(1);
        if (!uriStr.cutStarting('=')) {
            String msg = "'=' expected!\n" + uriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        Value value = Value.parse(pTyped, uriStr);
        if (value == null) {
            String msg = "value expected!\n" + uriStr.markPosition();
            throw new IllegalArgumentException(msg);
        }
        pUriStr.set(uriStr);
        return new KeyValuePair(key, value, pTyped);
    }

    private KeyValuePair(String pKey, Value pValue, boolean pTyped) {
        this.iKey = pKey;
        this.iValue = pValue;
        this.iTyped = pTyped;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(this.iKey + '=');
        if (this.iTyped) {
            buf.append('(' + this.iValue.getTypeInfo() + ')');
        }
        buf.append(this.iValue instanceof QuotedValue ? ((QuotedValue)((Object)this.iValue)).toQuotedString() : this.iValue.toString());
        return buf.toString();
    }

    public String getKey() {
        return this.iKey;
    }

    public Value getValue() {
        return this.iValue;
    }
}

