/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.http.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends FilterInputStream {
    private long maxLen;
    private long used;
    private boolean closed = false;

    public BoundedInputStream(InputStream pStream) {
        this(pStream, -1L);
    }

    public BoundedInputStream(InputStream pStream, long pMaximumLength) {
        super(pStream);
        this.maxLen = pMaximumLength;
        this.used = 0L;
        this.in = pStream;
    }

    @Override
    public int read() throws IOException {
        if (this.maxLen > -1L) {
            if (this.used >= this.maxLen) {
                return -1;
            }
            int value = this.in.read();
            if (value > -1) {
                ++this.used;
            }
            return value;
        }
        return this.in.read();
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("I/O error - the stream is closed");
        }
        if (this.maxLen > -1L) {
            if (this.used >= this.maxLen) {
                return -1;
            }
            long min = this.used + (long)len > this.maxLen ? this.maxLen - this.used : (long)len;
            int total = this.in.read(buf, off, (int)min);
            if (total > -1) {
                this.used += (long)total;
            }
            return total;
        }
        return this.in.read(buf, off, len);
    }

    @Override
    public long skip(long len) throws IOException {
        if (this.maxLen > -1L) {
            if (len >= 0L) {
                long min = this.used + len > this.maxLen ? this.maxLen - this.used : len;
                long total = this.in.skip(min);
                if (total > -1L) {
                    this.used += total;
                }
                return total;
            }
            return -1L;
        }
        return this.in.skip(len);
    }

    @Override
    public int available() throws IOException {
        if (this.maxLen > -1L) {
            return (int)(this.maxLen - this.used);
        }
        return this.in.available();
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.maxLen > -1L) {
            if (!this.closed) {
                byte[] buf = new byte[512];
                while (this.read(buf, 0, buf.length) > -1) {
                }
                this.closed = true;
            }
        } else {
            this.in.close();
        }
    }
}

