/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.http;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.logging.Level;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.AuthorizationInfo;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.Challenge;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;

public class PegasusLocalAuthInfo
extends AuthorizationInfo {
    private boolean iChallenged = false;

    @Override
    public void updateAuthenticationInfo(Challenge challenge, String authenticate, URI url, String requestMethod) {
        this.iChallenged = true;
        this.iResponse = authenticate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        if (this.iChallenged && this.iResponse != null && this.iResponse.startsWith("Local ")) {
            String fileName = "";
            BufferedReader in = null;
            try {
                String line;
                fileName = this.iResponse.substring(7, this.iResponse.length() - 1);
                if (fileName.length() == 0) {
                    throw new IOException("No local authorization file specified");
                }
                File authorizationFile = new File(fileName);
                if (!authorizationFile.canRead()) {
                    throw new IOException("Local authorization file not accessible");
                }
                in = "z/OS".equals(System.getProperty("os.name")) ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(authorizationFile), "ISO-8859-1")) : new BufferedReader(new FileReader(authorizationFile));
                StringBuffer buffer = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    buffer.append(line);
                }
                StringBuffer header = new StringBuffer();
                header.append("Local \"");
                header.append(this.getCredentials().getUserName());
                header.append(':');
                header.append(fileName);
                header.append(':');
                header.append(buffer);
                header.append('\"');
                String string = header.toString();
                return string;
            }
            catch (IOException e) {
                LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
                logger.trace(Level.FINER, "Exception while reading OpenPegasus local authorization file", e);
                logger.message("CIM2007S", fileName);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while closing OpenPegasus local authorization file", e);
                    }
                }
            }
        }
        return "Local \"" + this.getCredentials().getUserName() + "\"";
    }

    @Override
    public String getHeaderFieldName() {
        return "PegasusAuthorization";
    }

    @Override
    public boolean isSentOnFirstRequest() {
        return true;
    }

    @Override
    public boolean isKeptAlive() {
        return true;
    }
}

