/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketPermission;
import java.net.URI;
import java.security.Permission;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.AuthorizationHandler;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpClient;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpClientPool;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;

public class HttpUrlConnection
extends HttpURLConnection {
    private boolean iConnected;
    private HttpClient iHttpClient;
    protected URI iUrl;
    private HttpClientPool iHttpClientPool;
    AuthorizationHandler iAuthHandler;

    public HttpUrlConnection(URI pUri, HttpClientPool pHttpClientPool, AuthorizationHandler pAuthHandler) {
        super(null);
        this.iUrl = pUri;
        this.iHttpClientPool = pHttpClientPool;
        this.iAuthHandler = pAuthHandler;
    }

    @Override
    public String toString() {
        return "HttpUrlConnection=[url=" + this.iUrl + ",PoolSize=" + this.iHttpClientPool.getNumberOfAvailableConnections() + "," + this.iAuthHandler + "]";
    }

    @Override
    public Permission getPermission() {
        int port = this.iUrl.getPort();
        port = port < 0 ? 80 : port;
        String host = this.iUrl.getHost() + ":" + port;
        SocketPermission permission = new SocketPermission(host, "connect");
        return permission;
    }

    @Override
    public synchronized void connect() throws IOException {
        if (!this.iConnected) {
            this.getClient();
        }
        this.iHttpClient.connect();
    }

    private synchronized void getClient() {
        if (this.iConnected) {
            return;
        }
        this.iHttpClient = HttpClient.getClient(this.iUrl, this.iHttpClientPool, this.iAuthHandler);
        this.iHttpClient.reset();
        this.iConnected = true;
    }

    @Override
    public synchronized void setRequestMethod(String pMethod) {
        if (!this.iConnected) {
            this.getClient();
        }
        this.iHttpClient.setRequestMethod(pMethod);
        this.method = pMethod;
    }

    @Override
    public synchronized void setRequestProperty(String key, String value) {
        if (!this.iConnected) {
            this.getClient();
        }
        this.iHttpClient.setRequestProperty(key, value);
    }

    @Override
    public synchronized void disconnect() {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        if (this.iConnected) {
            this.iConnected = false;
            this.iHttpClient.disconnect();
            if (this.iHttpClientPool != null) {
                this.iHttpClientPool.removeConnectionFromPool(this.iHttpClient);
                this.iHttpClient = null;
            }
        }
        logger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        if (this.iHttpClientPool != null) {
            HttpClientPool httpClientPool = this.iHttpClientPool;
            synchronized (httpClientPool) {
                this.iHttpClientPool.closePool();
                this.iHttpClientPool = null;
            }
        }
        logger.exit();
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        if (!this.iConnected) {
            this.getClient();
        }
        try {
            return this.iHttpClient.getInputStream();
        }
        catch (RuntimeException e) {
            this.disconnect();
            throw e;
        }
        catch (IOException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    public synchronized OutputStream getOutputStream() throws RuntimeException {
        if (!this.iConnected) {
            this.getClient();
        }
        try {
            return this.iHttpClient.getOutputStream();
        }
        catch (RuntimeException e) {
            this.disconnect();
            throw e;
        }
    }

    @Override
    public boolean usingProxy() {
        return false;
    }

    public synchronized HttpClient getHttpClient() {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient;
    }

    @Override
    public synchronized String getHeaderField(String name) {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getHeaderField(name);
    }

    @Override
    public synchronized String getHeaderFieldKey(int index) {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getHeaderFieldName(index);
    }

    @Override
    public synchronized String getHeaderField(int index) {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getHeaderFieldValue(index);
    }

    @Override
    public synchronized String getRequestProperty(String key) {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getRequestProperty(key);
    }

    @Override
    public synchronized String getRequestMethod() {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getRequestMethod();
    }

    public synchronized void reset() {
        if (!this.iConnected) {
            this.getClient();
        }
        this.iHttpClient.reset();
    }

    @Override
    public synchronized int getResponseCode() throws IOException {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getResponseCode();
    }

    @Override
    public synchronized String getResponseMessage() {
        if (!this.iConnected) {
            this.getClient();
        }
        return this.iHttpClient.getResponseMessage();
    }

    public synchronized void useHttp11(boolean pUse11) {
        if (!this.iConnected) {
            this.getClient();
        }
        this.iHttpClient.useHttp11(pUse11);
    }
}

