/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.http;

import java.io.IOException;
import java.io.InputStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpException;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpMethod;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.ASCIIPrintStream;

public class HttpServerMethod
extends HttpMethod {
    private String iMethodName;
    private String iFile;
    private String iProtocol;
    private int iMinor;
    private int iMajor;
    private int iStatus;
    private String iReason;

    public HttpServerMethod(int pMajor, int pMinor, int pStatus, String pReason) {
        this.iMinor = pMinor;
        this.iMajor = pMajor;
        this.iStatus = pStatus;
        this.iReason = pReason;
    }

    public HttpServerMethod(InputStream pReader) throws IOException, HttpException {
        String line;
        while ((line = HttpMethod.readLine(pReader)) == null || line.length() == 0) {
        }
        int next = line.indexOf(32);
        int prev = 0;
        if (next > -1) {
            this.iMethodName = line.substring(0, next).toUpperCase();
            if (this.iMethodName.equals("GET") && line.indexOf(32, next + 1) == -1) {
                this.iFile = line.substring(next + 1);
            } else {
                prev = next + 1;
                next = line.indexOf(32, prev);
                this.iFile = line.substring(prev, next);
                prev = next + 1;
                this.iProtocol = line.substring(prev).toUpperCase();
                prev = this.iProtocol.indexOf(47);
                next = this.iProtocol.indexOf(46, prev + 1);
                try {
                    this.iMajor = Integer.parseInt(this.iProtocol.substring(prev + 1, next));
                    this.iMinor = Integer.parseInt(this.iProtocol.substring(next + 1));
                }
                catch (Exception e) {
                    throw new HttpException(405, "Bad method");
                }
            }
        } else {
            throw new HttpException(405, "Bad method");
        }
    }

    public int getMajorVersion() {
        return this.iMajor;
    }

    public int getMinorVersion() {
        return this.iMinor;
    }

    public String getMethodName() {
        return this.iMethodName;
    }

    public String getFile() {
        return this.iFile;
    }

    public void write(ASCIIPrintStream pStream) {
        pStream.print("HTTP/" + this.iMajor + "." + this.iMinor + " " + this.iStatus + " " + this.iReason + "\r\n");
    }
}

