/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpContentHandler;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpException;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpHeader;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpServerMethod;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.MessageReader;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.MessageWriter;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.io.ASCIIPrintStream;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.WBEMConfiguration;

public class HttpConnectionHandler {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 1;
    HttpContentHandler iHandler;
    private int iHeaderTimeout;
    private int iMaxAllowedTimeouts;
    private Map<String, Integer> iSuspectIPs = new HashMap<String, Integer>();
    private StringBuilder iBlockedIPs = null;

    public HttpConnectionHandler(HttpContentHandler pHandler, WBEMConfiguration pProperties) {
        this.iHandler = pHandler;
        this.iHeaderTimeout = pProperties.getListenerHttpHeaderTimeout();
        this.iMaxAllowedTimeouts = pProperties.getListenerMaxAllowedTimeouts();
    }

    private synchronized void addSuspectIP(String pSuspectIP) {
        if (this.iMaxAllowedTimeouts == 0) {
            return;
        }
        Integer times = this.iSuspectIPs.get(pSuspectIP);
        if (times == null) {
            this.iSuspectIPs.put(pSuspectIP, 1);
        } else {
            int timesVal = times + 1;
            this.iSuspectIPs.put(pSuspectIP, timesVal);
            if (timesVal >= this.iMaxAllowedTimeouts) {
                boolean newIP = false;
                if (this.iBlockedIPs == null) {
                    this.iBlockedIPs = new StringBuilder(pSuspectIP);
                    newIP = true;
                } else if (this.iBlockedIPs.indexOf(pSuspectIP) == -1) {
                    this.iBlockedIPs.append(',');
                    this.iBlockedIPs.append(pSuspectIP);
                    newIP = true;
                }
                if (newIP) {
                    LogAndTraceBroker.getBroker().trace(Level.WARNING, "Maximum allowable timeouts exceeded, all future connections ignored from " + pSuspectIP);
                }
            }
        }
    }

    private synchronized boolean isBlockedIP(Socket socket) {
        return this.iBlockedIPs != null && this.iBlockedIPs.indexOf(socket.getInetAddress().getHostAddress()) != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConnection(Socket socket) {
        block31: {
            InputStream is = null;
            OutputStream os = null;
            if (this.isBlockedIP(socket)) {
                LogAndTraceBroker.getBroker().trace(Level.FINEST, "Incoming connection ignored from blocked IP " + socket.getInetAddress().getHostAddress());
            } else {
                try {
                    is = socket.getInputStream();
                    os = socket.getOutputStream();
                    while (true) {
                        MessageWriter writer;
                        MessageReader reader = new MessageReader(is, this.iHeaderTimeout);
                        boolean persistent = reader.isPersistentConnectionSupported();
                        persistent = false;
                        boolean chunk = reader.isChunkSupported();
                        HttpServerMethod readerMethod = reader.getMethod();
                        if (readerMethod.getMethodName().equals("POST") || readerMethod.getMethodName().equals("M-POST")) {
                            writer = new MessageWriter(os, persistent, chunk);
                            try {
                                StringBuilder localURL = new StringBuilder(socket instanceof SSLSocket ? "https://" : "http://");
                                InetAddress localAddress = socket.getLocalAddress();
                                if (localAddress != null) {
                                    localURL.append(localAddress.getHostAddress());
                                    int port = socket.getLocalPort();
                                    if (port > 0) {
                                        localURL.append(":");
                                        localURL.append(port);
                                    }
                                }
                                this.iHandler.handleContent(reader, writer, socket.getInetAddress(), localURL.toString());
                                writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), 200, "OK"));
                            }
                            catch (HttpException e) {
                                writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), e.getStatus(), e.getMessage()));
                            }
                            catch (Throwable t) {
                                writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), 501, "Not Implemented"));
                                writer.reset();
                                this.writeError(writer.getOutputStream(), "error", "error");
                            }
                            finally {
                                try {
                                    writer.close();
                                }
                                catch (IOException e) {
                                    LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while closing output stream from server socket", e);
                                }
                            }
                        } else {
                            persistent = false;
                            writer = new MessageWriter(os, false, false);
                            HttpHeader header = new HttpHeader();
                            writer.setHeader(header);
                            writer.setMethod(new HttpServerMethod(readerMethod.getMajorVersion(), readerMethod.getMinorVersion(), 501, "Not Implemented"));
                            this.writeError(writer.getOutputStream(), "", "");
                            try {
                                writer.close();
                            }
                            catch (IOException e) {
                                LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while closing output stream from server socket", e);
                            }
                        }
                        if (persistent) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while closing input stream from server socket", e);
                            }
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while reading from server socket", e);
                    if (!(e instanceof SocketTimeoutException) && !"Indication sender taking too long, possible DoS underway?".equalsIgnoreCase(e.getMessage())) break block31;
                    this.addSuspectIP(socket.getInetAddress().getHostAddress());
                }
            }
        }
        try {
            socket.close();
        }
        catch (IOException e) {
            LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while closing server socket", e);
        }
    }

    public void close() {
        this.iHandler.close();
    }

    private void writeError(ASCIIPrintStream dos, String title, String body) {
        dos.print("<HTML> <HEAD> <TITLE>" + title + "</TITLE></HEAD><BODY>" + body + "</BODY></HTML>");
    }

    public synchronized String getBlockedIPs() {
        return this.iBlockedIPs == null ? null : this.iBlockedIPs.toString();
    }

    public synchronized void setBlockedIPs(String pIPs) {
        this.iBlockedIPs = pIPs == null || pIPs.trim().length() == 0 ? null : new StringBuilder(pIPs);
    }
}

