/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.http;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLContext;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.AuthorizationHandler;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpClient;
import org.sentrysoftware.wbem.sblim.cimclient.internal.http.HttpSocketFactory;
import org.sentrysoftware.wbem.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.Util;
import org.sentrysoftware.wbem.sblim.cimclient.internal.util.WBEMConfiguration;

public class HttpClientPool {
    private List<HttpClient> iAllConnections;
    private List<HttpClient> iAvailableConnections;
    private boolean iClosed = false;
    private final int iPoolSize;
    private final WBEMConfiguration iConfiguration;
    private SSLContext iSslContext;
    private String[] iEnabledCipherSuites = null;

    public HttpClientPool(WBEMConfiguration pConfiguration) {
        this.iConfiguration = pConfiguration;
        this.iAllConnections = new ArrayList<HttpClient>(pConfiguration.getHttpPoolSize());
        this.iAvailableConnections = new ArrayList<HttpClient>(pConfiguration.getHttpPoolSize());
        this.iPoolSize = pConfiguration.getHttpPoolSize();
        this.iSslContext = null;
        this.iEnabledCipherSuites = null;
    }

    public synchronized int getNumberOfAllConnections() {
        return this.iAllConnections.size();
    }

    public synchronized int getNumberOfAvailableConnections() {
        return this.iAvailableConnections.size();
    }

    public WBEMConfiguration getConfigurationContext() {
        return this.iConfiguration;
    }

    public synchronized SSLContext getSslContext() {
        if (this.iSslContext == null) {
            this.iSslContext = HttpSocketFactory.getInstance().getClientSSLContext(this.iConfiguration);
        }
        return this.iSslContext;
    }

    public synchronized HttpClient retrieveAvailableConnectionFromPool(URI pUri, AuthorizationHandler pHandler) {
        if (this.iClosed) {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "Attempt to get client from closed http client pool,");
            throw new IllegalStateException("HttpClientPool is closed. Retrieve connection failed.");
        }
        if (this.getNumberOfAvailableConnections() > 0) {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "Reusing client (" + pUri.toString() + ", max: " + this.getPoolSize() + ", current:" + this.getNumberOfAvailableConnections());
            return this.iAvailableConnections.remove(0);
        }
        LogAndTraceBroker.getBroker().trace(Level.FINE, "New client (" + pUri.toString() + ", max: " + this.getPoolSize() + ", current:" + this.getNumberOfAvailableConnections());
        HttpClient client = new HttpClient(pUri, this, pHandler);
        this.addConnectionToPool(client);
        return client;
    }

    public synchronized boolean returnAvailableConnectionToPool(HttpClient httpClient) {
        if (httpClient == null) {
            return false;
        }
        if (this.iClosed) {
            this.iAllConnections.remove(httpClient);
            httpClient.disconnect();
            return false;
        }
        if (this.getPoolSize() > this.iAvailableConnections.size()) {
            if (!this.iAvailableConnections.contains(httpClient)) {
                this.addConnectionToPool(httpClient);
                this.iAvailableConnections.add(httpClient);
                return true;
            }
        } else {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "Http pool size reached, discarding client.");
            this.iAllConnections.remove(httpClient);
            this.iAvailableConnections.remove(httpClient);
            httpClient.disconnect();
        }
        return false;
    }

    public synchronized boolean addConnectionToPool(HttpClient httpClient) {
        if (this.iClosed) {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "Attempt to add client to closed http client pool,");
            throw new IllegalStateException("HttpClientPool is closed. Add connection failed.");
        }
        if (httpClient != null && !this.iAllConnections.contains(httpClient)) {
            this.iAllConnections.add(httpClient);
            return true;
        }
        return false;
    }

    public synchronized boolean removeConnectionFromPool(HttpClient httpClient) {
        if (httpClient != null) {
            this.iAvailableConnections.remove(httpClient);
            return this.iAllConnections.remove(httpClient);
        }
        return false;
    }

    public synchronized void closePool() {
        this.iClosed = true;
        for (HttpClient httpClient : this.iAvailableConnections) {
            this.iAllConnections.remove(httpClient);
            httpClient.disconnect();
        }
        this.iAvailableConnections.clear();
    }

    protected void finalize() throws Throwable {
        this.closePool();
        super.finalize();
    }

    public int getPoolSize() {
        return this.iPoolSize;
    }

    public synchronized String[] getUpdatedCipherSuites(String[] pCurrentCipherSuites, String pDisableCipherSuites) {
        if (this.iEnabledCipherSuites == null) {
            this.iEnabledCipherSuites = Util.getFilteredStringArray(pCurrentCipherSuites, pDisableCipherSuites);
            int before = pCurrentCipherSuites.length;
            int after = this.iEnabledCipherSuites.length;
            if (before > 0 && after == 0) {
                LogAndTraceBroker.getBroker().trace(Level.WARNING, "All cipher suites disabled for client!");
            } else if (before > after) {
                LogAndTraceBroker.getBroker().trace(Level.FINE, "Some (" + (before - after) + ") cipher suites disabled for client");
            } else if (before == after) {
                LogAndTraceBroker.getBroker().trace(Level.FINER, "No cipher suites disabled for client");
            }
        }
        return this.iEnabledCipherSuites;
    }
}

