/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node;

import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.HostNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.LocalNameSpacePathNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NameSpacePathNode
extends Node {
    private boolean iHasHost;
    private String iHostStr;
    private boolean iHasLocalNameSpacePath;
    private String iLocalNameSpacePathStr;

    public NameSpacePathNode() {
        super("NAMESPACEPATH");
    }

    @Override
    public void init(Attributes pAttribs, SAXSession pSession) {
        this.iHasLocalNameSpacePath = false;
        this.iHasHost = false;
        this.iLocalNameSpacePathStr = null;
        this.iHostStr = null;
    }

    @Override
    public void parseData(String pData) {
    }

    @Override
    public void testChild(String pNodeNameEnum) throws SAXException {
        if (pNodeNameEnum == "HOST") {
            if (this.iHasHost) {
                throw new SAXException(this.getNodeName() + " node can have only one HOST child node!");
            }
        } else if (pNodeNameEnum == "LOCALNAMESPACEPATH") {
            if (this.iHasLocalNameSpacePath) {
                throw new SAXException(this.getNodeName() + " node can have only one LOCALNAMESPACEPATH child node!");
            }
        } else {
            throw new SAXException(this.getNodeName() + " node cannot have " + pNodeNameEnum + " child node!");
        }
    }

    @Override
    public void childParsed(Node pChild) {
        if (pChild instanceof HostNode) {
            this.iHasHost = true;
            this.iHostStr = ((HostNode)pChild).getHostStr();
        } else {
            this.iHasLocalNameSpacePath = true;
            this.iLocalNameSpacePathStr = ((LocalNameSpacePathNode)pChild).getNameSpace();
        }
    }

    @Override
    public void testCompletness() throws SAXException {
        if (!this.iHasHost) {
            throw new SAXException("HOST child node is mandatory for " + this.getNodeName() + " node!");
        }
        if (!this.iHasLocalNameSpacePath) {
            throw new SAXException("LOCALNAMESPACEPATH child node is mandatory for " + this.getNodeName() + " node!");
        }
    }

    public String getHostStr() {
        return this.iHostStr;
    }

    public String getLocalNameSpacePath() {
        return this.iLocalNameSpacePathStr;
    }
}

