/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node;

import java.util.ArrayList;
import org.sentrysoftware.wbem.javax.cim.CIMDataType;
import org.sentrysoftware.wbem.javax.cim.CIMMethod;
import org.sentrysoftware.wbem.javax.cim.CIMParameter;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.EmbObjHandler;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.SAXSession;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.AbstractParameterNode;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.Node;
import org.sentrysoftware.wbem.sblim.cimclient.internal.cimxml.sax.node.QualifiedNodeHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MethodNode
extends Node {
    private String iName;
    private CIMDataType iType;
    private String iClassOrigin;
    private boolean iPropagated;
    private QualifiedNodeHandler iQualiHandler;
    private EmbObjHandler iEmbObjHandler;
    private SAXSession iSession;
    private ArrayList<CIMParameter<?>> iCIMParamAL;
    private static final String[] ALLOWED_CHILDREN = new String[]{"QUALIFIER", "PARAMETER", "PARAMETER.REFERENCE", "PARAMETER.ARRAY", "PARAMETER.REFARRAY"};
    private static final CIMParameter<?>[] EMPTY_PA = new CIMParameter[0];

    public MethodNode() {
        super("METHOD");
    }

    @Override
    public void init(Attributes pAttribs, SAXSession pSession) throws SAXException {
        this.iSession = pSession;
        this.iQualiHandler = QualifiedNodeHandler.init(this.iQualiHandler);
        this.iEmbObjHandler = EmbObjHandler.init(this.iEmbObjHandler, this.getNodeName(), pAttribs, this.iSession, this.iQualiHandler, true);
        if (this.iCIMParamAL != null) {
            this.iCIMParamAL.clear();
        }
        this.iName = MethodNode.getCIMName(pAttribs);
        this.iType = MethodNode.getCIMType(pAttribs, true);
        if (this.iType != null && this.iType.isArray()) {
            throw new SAXException("METHOD node's TYPE cannot be an array!");
        }
        this.iClassOrigin = MethodNode.getClassOrigin(pAttribs);
        this.iPropagated = MethodNode.getPropagated(pAttribs);
    }

    @Override
    public void parseData(String pData) {
    }

    @Override
    public void testChild(String pNodeNameEnum) throws SAXException {
        for (int i = 0; i < ALLOWED_CHILDREN.length; ++i) {
            if (!pNodeNameEnum.equalsIgnoreCase(ALLOWED_CHILDREN[i])) continue;
            return;
        }
        throw new SAXException(this.getNodeName() + " node cannot have " + pNodeNameEnum + " child node!");
    }

    @Override
    public void childParsed(Node pChild) {
        if (this.iQualiHandler.addQualifierNode(pChild)) {
            return;
        }
        if (this.iCIMParamAL == null) {
            this.iCIMParamAL = new ArrayList();
        }
        this.iCIMParamAL.add(((AbstractParameterNode)pChild).getCIMParameter());
    }

    @Override
    public void testCompletness() throws SAXException {
        this.iType = this.iEmbObjHandler.getType();
        if (this.iType != null && this.iType.isArray()) {
            throw new SAXException("METHOD node's TYPE attribute cannot be an array!");
        }
    }

    public CIMMethod<?> getCIMMethod() {
        return new CIMMethod(this.iName, this.iType, this.iQualiHandler.getQualis(!this.iSession.strictEmbObjParsing()), this.iCIMParamAL == null ? null : this.iCIMParamAL.toArray(EMPTY_PA), this.iPropagated, this.iClassOrigin);
    }
}

